/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.internal.util.GridBoundedLinkedHashMap;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryAbstractMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryCustomEventMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryNodeAddFinishedMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryNodeAddedMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryNodeFailedMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryNodeLeftMessage;

public class TcpDiscoveryStatistics {
    private long joinStartedTs;
    private long joinFinishedTs;
    private final AtomicLong crdSinceTs = new AtomicLong();
    private int joinedNodesCnt;
    private int failedNodesCnt;
    private int leftNodesCnt;
    private int ackTimeoutsCnt;
    private int sockTimeoutsCnt;
    @GridToStringInclude
    private final Map<String, Integer> rcvdMsgs = new HashMap<String, Integer>();
    @GridToStringInclude
    private final Map<String, Integer> procMsgs = new HashMap<String, Integer>();
    @GridToStringInclude
    private final Map<String, Long> avgMsgsSndTimes = new HashMap<String, Long>();
    @GridToStringInclude
    private final Map<String, Long> maxMsgsSndTimes = new HashMap<String, Long>();
    @GridToStringInclude
    private final Map<String, Integer> sentMsgs = new HashMap<String, Integer>();
    private final Map<IgniteUuid, Long> msgsRcvTs = new GridBoundedLinkedHashMap<IgniteUuid, Long>(1024);
    private final Map<IgniteUuid, Long> msgsProcStartTs = new GridBoundedLinkedHashMap<IgniteUuid, Long>(1024);
    private final Map<IgniteUuid, Long> ringMsgsSndTs = new GridBoundedLinkedHashMap<IgniteUuid, Long>(1024);
    @GridToStringInclude
    private final Map<String, Long> avgMsgsAckTimes = new HashMap<String, Long>();
    @GridToStringInclude
    private final Map<String, Long> maxMsgsAckTimes = new HashMap<String, Long>();
    private long avgMsgQueueTime;
    private long maxMsgQueueTime;
    private int ringMsgsSent;
    private long avgRingMsgTime;
    private long maxRingMsgTime;
    private String maxRingTimeMsgCls;
    private long avgMsgProcTime;
    private long maxMsgProcTime;
    private String maxProcTimeMsgCls;
    private int sockReadersCreated;
    private int sockReadersRmv;
    private long avgSrvSockInitTime;
    private long maxSrvSockInitTime;
    private int clientSockCreatedCnt;
    private long avgClientSockInitTime;
    private long maxClientSockInitTime;
    private int pendingMsgsRegistered;
    private int pendingMsgsDiscarded;

    public synchronized void onNodeJoined() {
        ++this.joinedNodesCnt;
    }

    public synchronized void onNodeLeft() {
        ++this.leftNodesCnt;
    }

    public synchronized void onNodeFailed() {
        ++this.failedNodesCnt;
    }

    public synchronized void onAckTimeout() {
        ++this.ackTimeoutsCnt;
    }

    public synchronized void onSocketTimeout() {
        ++this.sockTimeoutsCnt;
    }

    public void onBecomingCoordinator() {
        this.crdSinceTs.compareAndSet(0L, U.currentTimeMillis());
    }

    public synchronized void onJoinStarted() {
        this.joinStartedTs = U.currentTimeMillis();
    }

    public synchronized void onJoinFinished() {
        this.joinFinishedTs = U.currentTimeMillis();
    }

    public synchronized long joinStarted() {
        return this.joinStartedTs;
    }

    public synchronized long joinFinished() {
        return this.joinFinishedTs;
    }

    public synchronized void onMessageReceived(TcpDiscoveryAbstractMessage msg) {
        assert (msg != null);
        Integer cnt = (Integer)((Object)F.addIfAbsent(this.rcvdMsgs, msg.getClass().getSimpleName(), new Callable<Integer>(){

            @Override
            public Integer call() {
                return 0;
            }
        }));
        assert (cnt != null);
        cnt = cnt + 1;
        this.rcvdMsgs.put(msg.getClass().getSimpleName(), cnt);
        this.msgsRcvTs.put(msg.id(), U.currentTimeMillis());
    }

    public synchronized void onMessageProcessingStarted(TcpDiscoveryAbstractMessage msg) {
        assert (msg != null);
        Integer cnt = (Integer)((Object)F.addIfAbsent(this.procMsgs, msg.getClass().getSimpleName(), new Callable<Integer>(){

            @Override
            public Integer call() {
                return 0;
            }
        }));
        assert (cnt != null);
        cnt = cnt + 1;
        this.procMsgs.put(msg.getClass().getSimpleName(), cnt);
        Long rcvdTs = this.msgsRcvTs.remove(msg.id());
        if (rcvdTs != null) {
            int totalProcMsgs;
            long duration = U.currentTimeMillis() - rcvdTs;
            if (this.maxMsgQueueTime < duration) {
                this.maxMsgQueueTime = duration;
            }
            if ((totalProcMsgs = this.totalProcessedMessages()) != 0) {
                this.avgMsgQueueTime = this.avgMsgQueueTime * (long)(totalProcMsgs - 1) / (long)totalProcMsgs;
            }
        }
        this.msgsProcStartTs.put(msg.id(), U.currentTimeMillis());
    }

    public synchronized void onMessageProcessingFinished(TcpDiscoveryAbstractMessage msg) {
        assert (msg != null);
        Long startTs = this.msgsProcStartTs.get(msg.id());
        if (startTs != null) {
            long duration = U.currentTimeMillis() - startTs;
            int totalProcMsgs = this.totalProcessedMessages();
            if (totalProcMsgs != 0) {
                this.avgMsgProcTime = (this.avgMsgProcTime * (long)(totalProcMsgs - 1) + duration) / (long)totalProcMsgs;
            }
            if (duration > this.maxMsgProcTime) {
                this.maxMsgProcTime = duration;
                this.maxProcTimeMsgCls = msg.getClass().getSimpleName();
            }
            this.msgsProcStartTs.remove(msg.id());
        }
    }

    public synchronized void onMessageSent(TcpDiscoveryAbstractMessage msg, long time) {
        assert (msg != null);
        assert (time >= 0L) : time;
        if (this.crdSinceTs.get() > 0L && msg instanceof TcpDiscoveryCustomEventMessage || msg instanceof TcpDiscoveryNodeAddedMessage || msg instanceof TcpDiscoveryNodeAddFinishedMessage || msg instanceof TcpDiscoveryNodeLeftMessage || msg instanceof TcpDiscoveryNodeFailedMessage) {
            this.ringMsgsSndTs.put(msg.id(), U.currentTimeMillis());
            ++this.ringMsgsSent;
        }
        Integer cnt = (Integer)((Object)F.addIfAbsent(this.sentMsgs, msg.getClass().getSimpleName(), new Callable<Integer>(){

            @Override
            public Integer call() {
                return 0;
            }
        }));
        assert (cnt != null);
        cnt = cnt + 1;
        this.sentMsgs.put(msg.getClass().getSimpleName(), cnt);
        this.addTimeInfo(this.avgMsgsSndTimes, this.maxMsgsSndTimes, msg, cnt, time);
        this.addTimeInfo(this.avgMsgsAckTimes, this.maxMsgsAckTimes, msg, cnt, time);
    }

    private void addTimeInfo(Map<String, Long> avgTimes, Map<String, Long> maxTimes, TcpDiscoveryAbstractMessage msg, int cnt, long time) {
        Long avgTime = (Long)((Object)F.addIfAbsent(avgTimes, msg.getClass().getSimpleName(), new Callable<Long>(){

            @Override
            public Long call() {
                return 0L;
            }
        }));
        assert (avgTime != null);
        avgTime = (avgTime * (long)(cnt - 1) + time) / (long)cnt;
        avgTimes.put(msg.getClass().getSimpleName(), avgTime);
        Long maxTime = (Long)((Object)F.addIfAbsent(maxTimes, msg.getClass().getSimpleName(), new Callable<Long>(){

            @Override
            public Long call() {
                return 0L;
            }
        }));
        assert (maxTime != null);
        if (time > maxTime) {
            maxTimes.put(msg.getClass().getSimpleName(), time);
        }
    }

    public synchronized void onRingMessageReceived(TcpDiscoveryAbstractMessage msg) {
        assert (msg != null);
        Long sentTs = this.ringMsgsSndTs.get(msg.id());
        if (sentTs != null) {
            long duration = U.currentTimeMillis() - sentTs;
            if (this.maxRingMsgTime < duration) {
                this.maxRingMsgTime = duration;
                this.maxRingTimeMsgCls = msg.getClass().getSimpleName();
            }
            if (this.ringMsgsSent != 0) {
                this.avgRingMsgTime = (this.avgRingMsgTime * (long)(this.ringMsgsSent - 1) + duration) / (long)this.ringMsgsSent;
            }
        }
    }

    public synchronized long maxRingMessageTime() {
        return this.maxRingMsgTime;
    }

    public synchronized String maxRingDurationMessageClass() {
        return this.maxRingTimeMsgCls;
    }

    public synchronized String maxProcessingTimeMessageClass() {
        return this.maxProcTimeMsgCls;
    }

    public synchronized void onServerSocketInitialized(long initTime) {
        assert (initTime >= 0L);
        if (this.maxSrvSockInitTime < initTime) {
            this.maxSrvSockInitTime = initTime;
        }
        this.avgSrvSockInitTime = (this.avgSrvSockInitTime * (long)(this.sockReadersCreated - 1) + initTime) / (long)this.sockReadersCreated;
    }

    public synchronized void onClientSocketInitialized(long initTime) {
        assert (initTime >= 0L);
        ++this.clientSockCreatedCnt;
        if (this.maxClientSockInitTime < initTime) {
            this.maxClientSockInitTime = initTime;
        }
        this.avgClientSockInitTime = (this.avgClientSockInitTime * (long)(this.clientSockCreatedCnt - 1) + initTime) / (long)this.clientSockCreatedCnt;
    }

    public synchronized void onPendingMessageRegistered() {
        ++this.pendingMsgsRegistered;
    }

    public synchronized void onPendingMessageDiscarded() {
        ++this.pendingMsgsDiscarded;
    }

    public synchronized void onSocketReaderCreated() {
        ++this.sockReadersCreated;
    }

    public synchronized void onSocketReaderRemoved() {
        ++this.sockReadersRmv;
    }

    public synchronized Map<String, Integer> processedMessages() {
        return new HashMap<String, Integer>(this.procMsgs);
    }

    public synchronized Map<String, Integer> receivedMessages() {
        return new HashMap<String, Integer>(this.rcvdMsgs);
    }

    public synchronized Map<String, Integer> sentMessages() {
        return new HashMap<String, Integer>(this.sentMsgs);
    }

    public synchronized Map<String, Long> maxMessagesSendTimes() {
        return new HashMap<String, Long>(this.maxMsgsSndTimes);
    }

    public synchronized Map<String, Long> avgMessagesSendTimes() {
        return new HashMap<String, Long>(this.avgMsgsSndTimes);
    }

    public synchronized int totalReceivedMessages() {
        return F.sumInt(this.receivedMessages().values());
    }

    public synchronized int totalProcessedMessages() {
        return F.sumInt(this.processedMessages().values());
    }

    public synchronized long maxMessageProcessingTime() {
        return this.maxMsgProcTime;
    }

    public synchronized long avgMessageProcessingTime() {
        return this.avgMsgProcTime;
    }

    public synchronized long pendingMessagesRegistered() {
        return this.pendingMsgsRegistered;
    }

    public synchronized long pendingMessagesDiscarded() {
        return this.pendingMsgsDiscarded;
    }

    public synchronized int joinedNodesCount() {
        return this.joinedNodesCnt;
    }

    public synchronized int leftNodesCount() {
        return this.leftNodesCnt;
    }

    public synchronized int failedNodesCount() {
        return this.failedNodesCnt;
    }

    public synchronized int ackTimeoutsCount() {
        return this.ackTimeoutsCnt;
    }

    public synchronized int socketTimeoutsCount() {
        return this.sockTimeoutsCnt;
    }

    public synchronized int socketReadersCreated() {
        return this.sockReadersCreated;
    }

    public synchronized int socketReadersRemoved() {
        return this.sockReadersRmv;
    }

    public long coordinatorSinceTimestamp() {
        return this.crdSinceTs.get();
    }

    public synchronized void clear() {
        this.ackTimeoutsCnt = 0;
        this.avgClientSockInitTime = 0L;
        this.avgMsgProcTime = 0L;
        this.avgMsgQueueTime = 0L;
        this.avgMsgsAckTimes.clear();
        this.avgMsgsSndTimes.clear();
        this.avgRingMsgTime = 0L;
        this.avgSrvSockInitTime = 0L;
        this.clientSockCreatedCnt = 0;
        this.crdSinceTs.set(0L);
        this.failedNodesCnt = 0;
        this.joinedNodesCnt = 0;
        this.joinFinishedTs = 0L;
        this.joinStartedTs = 0L;
        this.leftNodesCnt = 0;
        this.maxClientSockInitTime = 0L;
        this.maxMsgProcTime = 0L;
        this.maxMsgQueueTime = 0L;
        this.maxMsgsAckTimes.clear();
        this.maxMsgsSndTimes.clear();
        this.maxProcTimeMsgCls = null;
        this.maxRingMsgTime = 0L;
        this.maxRingTimeMsgCls = null;
        this.maxSrvSockInitTime = 0L;
        this.pendingMsgsDiscarded = 0;
        this.pendingMsgsRegistered = 0;
        this.procMsgs.clear();
        this.rcvdMsgs.clear();
        this.ringMsgsSent = 0;
        this.sentMsgs.clear();
        this.sockReadersCreated = 0;
        this.sockReadersRmv = 0;
        this.sockTimeoutsCnt = 0;
    }

    public synchronized String toString() {
        return S.toString(TcpDiscoveryStatistics.class, this);
    }
}

