/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp.messages;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.spi.discovery.tcp.internal.TcpDiscoveryNode;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryAbstractMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryEnsureDelivery;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryRedirectToClient;
import org.jetbrains.annotations.Nullable;

@TcpDiscoveryEnsureDelivery
@TcpDiscoveryRedirectToClient
public class TcpDiscoveryNodeAddedMessage
extends TcpDiscoveryAbstractMessage {
    private static final long serialVersionUID = 0L;
    private final TcpDiscoveryNode node;
    private Collection<TcpDiscoveryAbstractMessage> msgs;
    private IgniteUuid discardMsgId;
    private IgniteUuid discardCustomMsgId;
    @GridToStringInclude
    private Collection<TcpDiscoveryNode> top;
    @GridToStringInclude
    private transient Collection<TcpDiscoveryNode> clientTop;
    private Map<Long, Collection<ClusterNode>> topHist;
    private Map<Integer, byte[]> newNodeDiscoData;
    private Map<UUID, Map<Integer, byte[]>> oldNodesDiscoData;
    private final long gridStartTime;

    public TcpDiscoveryNodeAddedMessage(UUID creatorNodeId, TcpDiscoveryNode node, Map<Integer, byte[]> newNodeDiscoData, long gridStartTime) {
        super(creatorNodeId);
        assert (node != null);
        assert (gridStartTime > 0L);
        this.node = node;
        this.newNodeDiscoData = newNodeDiscoData;
        this.gridStartTime = gridStartTime;
        this.oldNodesDiscoData = new LinkedHashMap<UUID, Map<Integer, byte[]>>();
    }

    public TcpDiscoveryNodeAddedMessage(TcpDiscoveryNodeAddedMessage msg) {
        super(msg);
        this.node = msg.node;
        this.msgs = msg.msgs;
        this.discardMsgId = msg.discardMsgId;
        this.discardCustomMsgId = msg.discardCustomMsgId;
        this.top = msg.top;
        this.clientTop = msg.clientTop;
        this.topHist = msg.topHist;
        this.newNodeDiscoData = msg.newNodeDiscoData;
        this.oldNodesDiscoData = msg.oldNodesDiscoData;
        this.gridStartTime = msg.gridStartTime;
    }

    public TcpDiscoveryNode node() {
        return this.node;
    }

    @Nullable
    public Collection<TcpDiscoveryAbstractMessage> messages() {
        return this.msgs;
    }

    @Nullable
    public IgniteUuid discardedMessageId() {
        return this.discardMsgId;
    }

    @Nullable
    public IgniteUuid discardedCustomMessageId() {
        return this.discardCustomMsgId;
    }

    public void messages(@Nullable Collection<TcpDiscoveryAbstractMessage> msgs, @Nullable IgniteUuid discardMsgId, @Nullable IgniteUuid discardCustomMsgId) {
        this.msgs = msgs;
        this.discardMsgId = discardMsgId;
        this.discardCustomMsgId = discardCustomMsgId;
    }

    @Nullable
    public Collection<TcpDiscoveryNode> topology() {
        return this.top;
    }

    public void topology(@Nullable Collection<TcpDiscoveryNode> top) {
        this.top = top;
    }

    public void clientTopology(Collection<TcpDiscoveryNode> top) {
        assert (top != null && !top.isEmpty()) : top;
        this.clientTop = top;
    }

    public Collection<TcpDiscoveryNode> clientTopology() {
        return this.clientTop;
    }

    public Map<Long, Collection<ClusterNode>> topologyHistory() {
        return this.topHist;
    }

    public void topologyHistory(@Nullable Map<Long, Collection<ClusterNode>> topHist) {
        this.topHist = topHist;
    }

    public Map<Integer, byte[]> newNodeDiscoveryData() {
        return this.newNodeDiscoData;
    }

    public Map<UUID, Map<Integer, byte[]>> oldNodesDiscoveryData() {
        return this.oldNodesDiscoData;
    }

    public void oldNodesDiscoveryData(Map<UUID, Map<Integer, byte[]>> oldNodesDiscoData) {
        this.oldNodesDiscoData = oldNodesDiscoData;
    }

    public void addDiscoveryData(UUID nodeId, Map<Integer, byte[]> discoData) {
        if (this.oldNodesDiscoData != null) {
            for (Map.Entry<UUID, Map<Integer, byte[]>> existingDataEntry : this.oldNodesDiscoData.entrySet()) {
                Map<Integer, byte[]> existingData = existingDataEntry.getValue();
                Iterator<Map.Entry<Integer, byte[]>> it = discoData.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Integer, byte[]> discoDataEntry = it.next();
                    byte[] curData = existingData.get(discoDataEntry.getKey());
                    if (!Arrays.equals(curData, discoDataEntry.getValue())) continue;
                    it.remove();
                }
                if (!discoData.isEmpty()) continue;
                break;
            }
            if (!discoData.isEmpty()) {
                this.oldNodesDiscoData.put(nodeId, discoData);
            }
        }
    }

    public void clearDiscoveryData() {
        this.newNodeDiscoData = null;
        this.oldNodesDiscoData = null;
    }

    public long gridStartTime() {
        return this.gridStartTime;
    }

    @Override
    public String toString() {
        return S.toString(TcpDiscoveryNodeAddedMessage.class, this, "super", super.toString());
    }
}

