/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.eventstorage.memory;

import java.util.Collection;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiConfiguration;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.IgniteSpiMultipleInstancesSupport;
import org.apache.ignite.spi.eventstorage.EventStorageSpi;
import org.apache.ignite.spi.eventstorage.memory.MemoryEventStorageSpiMBean;
import org.jsr166.ConcurrentLinkedDeque8;

@IgniteSpiMultipleInstancesSupport(value=true)
public class MemoryEventStorageSpi
extends IgniteSpiAdapter
implements EventStorageSpi,
MemoryEventStorageSpiMBean {
    public static final long DFLT_EXPIRE_AGE_MS = Long.MAX_VALUE;
    public static final int DFLT_EXPIRE_COUNT = 10000;
    @LoggerResource
    private IgniteLogger log;
    private long expireAgeMs = Long.MAX_VALUE;
    private long expireCnt = 10000L;
    private ConcurrentLinkedDeque8<Event> evts = new ConcurrentLinkedDeque8();
    private IgnitePredicate<Event> filter;

    public IgnitePredicate<Event> getFilter() {
        return this.filter;
    }

    @IgniteSpiConfiguration(optional=true)
    public void setFilter(IgnitePredicate<Event> filter) {
        this.filter = filter;
    }

    @Override
    public void spiStart(String gridName) throws IgniteSpiException {
        this.startStopwatch();
        this.assertParameter(this.expireCnt > 0L, "expireCnt > 0");
        this.assertParameter(this.expireAgeMs > 0L, "expireAgeMs > 0");
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.configInfo("expireAgeMs", this.expireAgeMs));
            this.log.debug(this.configInfo("expireCnt", this.expireCnt));
        }
        this.registerMBean(gridName, this, MemoryEventStorageSpiMBean.class);
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.startInfo());
        }
    }

    @Override
    public void spiStop() throws IgniteSpiException {
        this.unregisterMBean();
        this.evts.clear();
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.stopInfo());
        }
    }

    @IgniteSpiConfiguration(optional=true)
    public void setExpireAgeMs(long expireAgeMs) {
        this.expireAgeMs = expireAgeMs;
    }

    @IgniteSpiConfiguration(optional=true)
    public void setExpireCount(long expireCnt) {
        this.expireCnt = expireCnt;
    }

    @Override
    public long getExpireAgeMs() {
        return this.expireAgeMs;
    }

    @Override
    public long getExpireCount() {
        return this.expireCnt;
    }

    @Override
    public long getQueueSize() {
        return this.evts.sizex();
    }

    @Override
    public void clearAll() {
        this.evts.clear();
    }

    @Override
    public <T extends Event> Collection<T> localEvents(IgnitePredicate<T> p) {
        A.notNull(p, "p");
        this.cleanupQueue();
        return F.retain(this.evts, true, p);
    }

    @Override
    public void record(Event evt) throws IgniteSpiException {
        assert (evt != null);
        if (this.filter == null || this.filter.apply(evt)) {
            this.cleanupQueue();
            this.evts.add(evt);
            if (evt.type() != 13 && this.log.isDebugEnabled()) {
                this.log.debug("Event recorded: " + evt);
            }
        }
    }

    private void cleanupQueue() {
        ConcurrentLinkedDeque8.Node<Event> node;
        long now = U.currentTimeMillis();
        long queueOversize = (long)this.evts.sizex() - this.expireCnt;
        int i = 0;
        while ((long)i < queueOversize && (long)this.evts.sizex() > this.expireCnt) {
            Event expired = this.evts.poll();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Event expired by count: " + expired);
            }
            ++i;
        }
        while ((node = this.evts.peekx()) != null) {
            Event evt = node.item();
            if (evt == null) continue;
            if (now - evt.timestamp() < this.expireAgeMs) break;
            if (!this.evts.unlinkx(node) || !this.log.isDebugEnabled()) continue;
            this.log.debug("Event expired by age: " + node.item());
        }
    }

    public String toString() {
        return S.toString(MemoryEventStorageSpi.class, this);
    }
}

