/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.failover.always;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.managers.failover.GridFailoverContextImpl;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiConfiguration;
import org.apache.ignite.spi.IgniteSpiConsistencyChecked;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.IgniteSpiMultipleInstancesSupport;
import org.apache.ignite.spi.failover.FailoverContext;
import org.apache.ignite.spi.failover.FailoverSpi;
import org.apache.ignite.spi.failover.always.AlwaysFailoverSpiMBean;

@IgniteSpiMultipleInstancesSupport(value=true)
@IgniteSpiConsistencyChecked(optional=true)
public class AlwaysFailoverSpi
extends IgniteSpiAdapter
implements FailoverSpi,
AlwaysFailoverSpiMBean {
    public static final int DFLT_MAX_FAILOVER_ATTEMPTS = 5;
    public static final String FAILED_NODE_LIST_ATTR = "gg:failover:failednodelist";
    public static final String AFFINITY_CALL_ATTEMPT = "ignite:failover:affinitycallattempt";
    public static final String MAX_FAILOVER_ATTEMPT_ATTR = "gg:failover:maxattempts";
    @LoggerResource
    private IgniteLogger log;
    private int maxFailoverAttempts = 5;
    private int totalFailoverJobs;

    @Override
    public int getMaximumFailoverAttempts() {
        return this.maxFailoverAttempts;
    }

    @IgniteSpiConfiguration(optional=true)
    public void setMaximumFailoverAttempts(int maxFailoverAttempts) {
        this.maxFailoverAttempts = maxFailoverAttempts;
    }

    @Override
    public int getTotalFailoverJobsCount() {
        return this.totalFailoverJobs;
    }

    @Override
    public Map<String, Object> getNodeAttributes() throws IgniteSpiException {
        return F.asMap(this.createSpiAttributeName(MAX_FAILOVER_ATTEMPT_ATTR), this.maxFailoverAttempts);
    }

    @Override
    public void spiStart(String gridName) throws IgniteSpiException {
        this.startStopwatch();
        this.assertParameter(this.maxFailoverAttempts >= 0, "maxFailoverAttempts >= 0");
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.configInfo("maximumFailoverAttempts", this.maxFailoverAttempts));
        }
        this.registerMBean(gridName, this, AlwaysFailoverSpiMBean.class);
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.startInfo());
        }
    }

    @Override
    public void spiStop() throws IgniteSpiException {
        this.unregisterMBean();
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.stopInfo());
        }
    }

    @Override
    public ClusterNode failover(FailoverContext ctx, List<ClusterNode> top) {
        Integer failoverCnt;
        assert (ctx != null);
        assert (top != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received failed job result: " + ctx.getJobResult());
        }
        if (top.isEmpty()) {
            U.warn(this.log, "Received empty topology for failover and is forced to fail.");
            return null;
        }
        if (ctx.partition() >= 0) {
            Integer affCallAttempt = (Integer)ctx.getJobResult().getJobContext().getAttribute(AFFINITY_CALL_ATTEMPT);
            if (affCallAttempt == null) {
                affCallAttempt = 1;
            }
            if (this.maxFailoverAttempts <= affCallAttempt) {
                U.warn(this.log, "Job failover failed because number of maximum failover attempts for affinity call is exceeded [failedJob=" + ctx.getJobResult().getJob() + ", maxFailoverAttempts=" + this.maxFailoverAttempts + ']');
                return null;
            }
            ctx.getJobResult().getJobContext().setAttribute(AFFINITY_CALL_ATTEMPT, affCallAttempt + 1);
            try {
                return ((IgniteEx)this.ignite).context().affinity().mapPartitionToNode(ctx.affinityCacheName(), ctx.partition(), ((GridFailoverContextImpl)ctx).affinityTopologyVersion());
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to get map job to node on failover: " + ctx, e);
                return null;
            }
        }
        HashSet failedNodes = (HashSet)ctx.getJobResult().getJobContext().getAttribute(FAILED_NODE_LIST_ATTR);
        if (failedNodes == null) {
            failedNodes = U.newHashSet(1);
        }
        if ((failoverCnt = Integer.valueOf(failedNodes.size())) >= this.maxFailoverAttempts) {
            U.warn(this.log, "Job failover failed because number of maximum failover attempts is exceeded [failedJob=" + ctx.getJobResult().getJob() + ", maxFailoverAttempts=" + this.maxFailoverAttempts + ']');
            return null;
        }
        failedNodes.add(ctx.getJobResult().getNode().id());
        ArrayList<ClusterNode> newTop = new ArrayList<ClusterNode>(top.size());
        for (ClusterNode node : top) {
            if (failedNodes.contains(node.id())) continue;
            newTop.add(node);
        }
        if (newTop.isEmpty()) {
            U.warn(this.log, "Received topology with only nodes that job had failed on (forced to fail) [failedNodes=" + failedNodes + ']');
            return null;
        }
        try {
            ClusterNode node = ctx.getBalancedNode(newTop);
            if (node == null) {
                U.warn(this.log, "Load balancer returned null node for topology: " + newTop);
            } else {
                ctx.getJobResult().getJobContext().setAttribute(FAILED_NODE_LIST_ATTR, failedNodes);
                ++this.totalFailoverJobs;
            }
            if (node != null) {
                U.warn(this.log, "Failed over job to a new node [newNode=" + node.id() + ", oldNode=" + ctx.getJobResult().getNode().id() + ", sesId=" + ctx.getTaskSession().getId() + ", job=" + ctx.getJobResult().getJob() + ", jobCtx=" + ctx.getJobResult().getJobContext() + ", task=" + ctx.getTaskSession().getTaskName() + ']');
            }
            return node;
        }
        catch (IgniteException e) {
            U.error(this.log, "Failed to get next balanced node for failover: " + ctx, e);
            return null;
        }
    }

    @Override
    protected List<String> getConsistentAttributeNames() {
        return Collections.singletonList(this.createSpiAttributeName(MAX_FAILOVER_ATTEMPT_ATTR));
    }

    public String toString() {
        return S.toString(AlwaysFailoverSpi.class, this);
    }
}

