/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.loadbalancing.adaptive;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeTaskSession;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.events.JobEvent;
import org.apache.ignite.events.TaskEvent;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiConfiguration;
import org.apache.ignite.spi.IgniteSpiContext;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.IgniteSpiMultipleInstancesSupport;
import org.apache.ignite.spi.loadbalancing.LoadBalancingSpi;
import org.apache.ignite.spi.loadbalancing.adaptive.AdaptiveCpuLoadProbe;
import org.apache.ignite.spi.loadbalancing.adaptive.AdaptiveLoadBalancingSpiMBean;
import org.apache.ignite.spi.loadbalancing.adaptive.AdaptiveLoadProbe;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentHashMap8;

@IgniteSpiMultipleInstancesSupport(value=true)
public class AdaptiveLoadBalancingSpi
extends IgniteSpiAdapter
implements LoadBalancingSpi,
AdaptiveLoadBalancingSpiMBean {
    private static final Random RAND = new Random();
    @LoggerResource
    private IgniteLogger log;
    private AdaptiveLoadProbe probe = new AdaptiveCpuLoadProbe();
    private GridLocalEventListener evtLsnr;
    private ConcurrentMap<IgniteUuid, IgniteBiTuple<Boolean, WeightedTopology>> taskTops = new ConcurrentHashMap8<IgniteUuid, IgniteBiTuple<Boolean, WeightedTopology>>();
    private final Map<UUID, AtomicInteger> nodeJobs = new HashMap<UUID, AtomicInteger>();
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();

    @Override
    public String getLoadProbeFormatted() {
        return this.probe.toString();
    }

    @IgniteSpiConfiguration(optional=true)
    public void setLoadProbe(AdaptiveLoadProbe probe) {
        A.ensure(probe != null, "probe != null");
        this.probe = probe;
    }

    @Override
    public void spiStart(@Nullable String gridName) throws IgniteSpiException {
        this.startStopwatch();
        this.assertParameter(this.probe != null, "loadProbe != null");
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.configInfo("loadProbe", this.probe));
        }
        this.registerMBean(gridName, this, AdaptiveLoadBalancingSpiMBean.class);
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.startInfo());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void spiStop() throws IgniteSpiException {
        this.rwLock.writeLock().lock();
        try {
            this.nodeJobs.clear();
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        this.unregisterMBean();
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.stopInfo());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onContextInitialized0(IgniteSpiContext spiCtx) throws IgniteSpiException {
        this.evtLsnr = new GridLocalEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onEvent(Event evt) {
                switch (evt.type()) {
                    case 21: 
                    case 22: {
                        TaskEvent taskEvt = (TaskEvent)evt;
                        AdaptiveLoadBalancingSpi.this.taskTops.remove(taskEvt.taskSessionId());
                        if (!AdaptiveLoadBalancingSpi.this.log.isDebugEnabled()) return;
                        AdaptiveLoadBalancingSpi.this.log.debug("Removed task topology from topology cache for session: " + taskEvt.taskSessionId());
                        return;
                    }
                    case 40: {
                        JobEvent jobEvt = (JobEvent)evt;
                        IgniteBiTuple weightedTop = (IgniteBiTuple)AdaptiveLoadBalancingSpi.this.taskTops.get(jobEvt.taskSessionId());
                        if (weightedTop != null) {
                            weightedTop.set1(true);
                        }
                        if (!AdaptiveLoadBalancingSpi.this.log.isDebugEnabled()) return;
                        AdaptiveLoadBalancingSpi.this.log.debug("Job has been mapped. Ignore cache for session: " + jobEvt.taskSessionId());
                        return;
                    }
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        DiscoveryEvent discoEvt = (DiscoveryEvent)evt;
                        AdaptiveLoadBalancingSpi.this.rwLock.writeLock().lock();
                        try {
                            switch (evt.type()) {
                                case 10: {
                                    AdaptiveLoadBalancingSpi.this.nodeJobs.put(discoEvt.eventNode().id(), new AtomicInteger(0));
                                    return;
                                }
                                case 11: 
                                case 12: {
                                    AdaptiveLoadBalancingSpi.this.nodeJobs.remove(discoEvt.eventNode().id());
                                    return;
                                }
                                case 13: {
                                    AdaptiveLoadBalancingSpi.this.nodeJobs.put(discoEvt.eventNode().id(), new AtomicInteger(0));
                                    return;
                                }
                            }
                            return;
                        }
                        finally {
                            AdaptiveLoadBalancingSpi.this.rwLock.writeLock().unlock();
                        }
                    }
                }
            }
        };
        this.getSpiContext().addLocalEventListener(this.evtLsnr, 13, 12, 10, 11, 21, 22, 40);
        this.rwLock.writeLock().lock();
        try {
            for (ClusterNode node : this.getSpiContext().nodes()) {
                this.nodeJobs.put(node.id(), new AtomicInteger(0));
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    protected void onContextDestroyed0() {
        IgniteSpiContext ctx;
        if (this.evtLsnr != null && (ctx = this.getSpiContext()) != null) {
            ctx.removeLocalEventListener(this.evtLsnr);
        }
    }

    @Override
    public ClusterNode getBalancedNode(ComputeTaskSession ses, List<ClusterNode> top, ComputeJob job) {
        A.notNull(ses, "ses");
        A.notNull(top, "top");
        A.notNull(job, "job");
        IgniteBiTuple<Boolean, WeightedTopology> weightedTop = (IgniteBiTuple<Boolean, WeightedTopology>)this.taskTops.get(ses.getId());
        if (weightedTop == null) {
            weightedTop = F.t(false, new WeightedTopology(top));
            this.taskTops.put(ses.getId(), weightedTop);
        } else if (((Boolean)weightedTop.get1()).booleanValue()) {
            return new WeightedTopology(top).pickWeightedNode();
        }
        return ((WeightedTopology)weightedTop.get2()).pickWeightedNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double getLoad(Collection<ClusterNode> top, ClusterNode node) throws IgniteException {
        assert (!F.isEmpty(top));
        int jobsSentSinceLastUpdate = 0;
        this.rwLock.readLock().lock();
        try {
            AtomicInteger cnt = this.nodeJobs.get(node.id());
            jobsSentSinceLastUpdate = cnt == null ? 0 : cnt.get();
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        double load = this.probe.getLoad(node, jobsSentSinceLastUpdate);
        if (load < 0.0) {
            throw new IgniteException("Failed to obtain non-negative load from adaptive load probe: " + load);
        }
        return load;
    }

    public String toString() {
        return S.toString(AdaptiveLoadBalancingSpi.class, this);
    }

    private class WeightedTopology {
        private final SortedMap<Double, ClusterNode> circle = new TreeMap<Double, ClusterNode>();

        WeightedTopology(List<ClusterNode> top) throws IgniteException {
            assert (!F.isEmpty(top));
            double totalLoad = 0.0;
            double[] nums = new double[top.size()];
            int zeroCnt = 0;
            for (int i = 0; i < top.size(); ++i) {
                double load;
                nums[i] = load = AdaptiveLoadBalancingSpi.this.getLoad(top, top.get(i));
                if (load == 0.0) {
                    ++zeroCnt;
                }
                totalLoad += load;
            }
            if (zeroCnt > 0) {
                double newTotal = totalLoad;
                int nonZeroCnt = top.size() - zeroCnt;
                for (int i = 0; i < nums.length; ++i) {
                    double load = nums[i];
                    if (load != 0.0) continue;
                    if (nonZeroCnt > 0) {
                        load = totalLoad / (double)nonZeroCnt;
                    }
                    if (load == 0.0) {
                        load = 1.0;
                    }
                    nums[i] = load;
                    newTotal += load;
                }
                totalLoad = newTotal;
            }
            double totalWeight = 0.0;
            for (int i = 0; i < nums.length; ++i) {
                double weight;
                assert (nums[i] > 0.0) : "Invalid load: " + nums[i];
                nums[i] = weight = totalLoad / nums[i];
                totalWeight += weight;
            }
            double weight = 0.0;
            for (int i = 0; i < nums.length; ++i) {
                double d = weight = i == nums.length - 1 ? 1.0 : weight + nums[i] / totalWeight;
                assert (weight < 2.0) : "Invalid weight: " + weight;
                this.circle.put(weight, top.get(i));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ClusterNode pickWeightedNode() {
            double weight = RAND.nextDouble();
            SortedMap<Double, ClusterNode> pick = this.circle.tailMap(weight);
            ClusterNode node = (ClusterNode)pick.get(pick.firstKey());
            AdaptiveLoadBalancingSpi.this.rwLock.readLock().lock();
            try {
                AtomicInteger cnt = (AtomicInteger)AdaptiveLoadBalancingSpi.this.nodeJobs.get(node.id());
                if (cnt != null) {
                    cnt.incrementAndGet();
                }
            }
            finally {
                AdaptiveLoadBalancingSpi.this.rwLock.readLock().unlock();
            }
            return node;
        }
    }
}

