/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.loadbalancing.weightedrandom;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeTaskSession;
import org.apache.ignite.events.Event;
import org.apache.ignite.events.JobEvent;
import org.apache.ignite.events.TaskEvent;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiConfiguration;
import org.apache.ignite.spi.IgniteSpiConsistencyChecked;
import org.apache.ignite.spi.IgniteSpiContext;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.IgniteSpiMultipleInstancesSupport;
import org.apache.ignite.spi.loadbalancing.LoadBalancingSpi;
import org.apache.ignite.spi.loadbalancing.weightedrandom.WeightedRandomLoadBalancingSpiMBean;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentHashMap8;

@IgniteSpiMultipleInstancesSupport(value=true)
@IgniteSpiConsistencyChecked(optional=true)
public class WeightedRandomLoadBalancingSpi
extends IgniteSpiAdapter
implements LoadBalancingSpi,
WeightedRandomLoadBalancingSpiMBean {
    private static final Random RAND = new Random();
    public static final String NODE_WEIGHT_ATTR_NAME = "ignite.node.weight.attr.name";
    public static final int DFLT_NODE_WEIGHT = 10;
    @LoggerResource
    private IgniteLogger log;
    private boolean isUseWeights;
    private GridLocalEventListener evtLsnr;
    private int nodeWeight = 10;
    private ConcurrentMap<IgniteUuid, IgniteBiTuple<Boolean, WeightedTopology>> taskTops = new ConcurrentHashMap8<IgniteUuid, IgniteBiTuple<Boolean, WeightedTopology>>();

    @IgniteSpiConfiguration(optional=true)
    public void setUseWeights(boolean isUseWeights) {
        this.isUseWeights = isUseWeights;
    }

    @Override
    public boolean isUseWeights() {
        return this.isUseWeights;
    }

    @IgniteSpiConfiguration(optional=true)
    public void setNodeWeight(int nodeWeight) {
        this.nodeWeight = nodeWeight;
    }

    @Override
    public int getNodeWeight() {
        return this.nodeWeight;
    }

    @Override
    public Map<String, Object> getNodeAttributes() throws IgniteSpiException {
        return F.asMap(this.createSpiAttributeName(NODE_WEIGHT_ATTR_NAME), this.nodeWeight);
    }

    @Override
    public void spiStart(@Nullable String gridName) throws IgniteSpiException {
        this.startStopwatch();
        this.assertParameter(this.nodeWeight > 0, "nodeWeight > 0");
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.configInfo("isUseWeights", this.isUseWeights));
            this.log.debug(this.configInfo("nodeWeight", this.nodeWeight));
        }
        this.registerMBean(gridName, this, WeightedRandomLoadBalancingSpiMBean.class);
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.startInfo());
        }
    }

    @Override
    public void spiStop() throws IgniteSpiException {
        this.unregisterMBean();
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.stopInfo());
        }
    }

    @Override
    protected void onContextInitialized0(IgniteSpiContext spiCtx) throws IgniteSpiException {
        this.evtLsnr = new GridLocalEventListener(){

            @Override
            public void onEvent(Event evt) {
                assert (evt instanceof TaskEvent || evt instanceof JobEvent);
                if (evt.type() == 21 || evt.type() == 22) {
                    IgniteUuid sesId = ((TaskEvent)evt).taskSessionId();
                    WeightedRandomLoadBalancingSpi.this.taskTops.remove(sesId);
                    if (WeightedRandomLoadBalancingSpi.this.log.isDebugEnabled()) {
                        WeightedRandomLoadBalancingSpi.this.log.debug("Removed task topology from topology cache for session: " + sesId);
                    }
                } else if (evt.type() == 40) {
                    IgniteUuid sesId = ((JobEvent)evt).taskSessionId();
                    IgniteBiTuple weightedTop = (IgniteBiTuple)WeightedRandomLoadBalancingSpi.this.taskTops.get(sesId);
                    if (weightedTop != null) {
                        weightedTop.set1(true);
                    }
                    if (WeightedRandomLoadBalancingSpi.this.log.isDebugEnabled()) {
                        WeightedRandomLoadBalancingSpi.this.log.debug("Job has been mapped. Ignore cache for session: " + sesId);
                    }
                }
            }
        };
        this.getSpiContext().addLocalEventListener(this.evtLsnr, 22, 21, 40);
    }

    @Override
    protected void onContextDestroyed0() {
        IgniteSpiContext ctx;
        if (this.evtLsnr != null && (ctx = this.getSpiContext()) != null) {
            ctx.removeLocalEventListener(this.evtLsnr);
        }
    }

    @Override
    public ClusterNode getBalancedNode(ComputeTaskSession ses, List<ClusterNode> top, ComputeJob job) {
        A.notNull(ses, "ses");
        A.notNull(top, "top");
        A.notNull(job, "job");
        if (!this.isUseWeights) {
            return top.get(RAND.nextInt(top.size()));
        }
        IgniteBiTuple<Boolean, WeightedTopology> weightedTop = (IgniteBiTuple<Boolean, WeightedTopology>)this.taskTops.get(ses.getId());
        if (weightedTop == null) {
            weightedTop = F.t(false, new WeightedTopology(top));
            this.taskTops.put(ses.getId(), weightedTop);
        } else if (((Boolean)weightedTop.get1()).booleanValue()) {
            return new WeightedTopology(top).pickWeightedNode();
        }
        return ((WeightedTopology)weightedTop.get2()).pickWeightedNode();
    }

    private int getWeight(ClusterNode node) {
        Integer weight = (Integer)node.attribute(this.createSpiAttributeName(NODE_WEIGHT_ATTR_NAME));
        if (weight != null && weight == 0) {
            throw new IllegalStateException("Node weight cannot be zero: " + node);
        }
        return weight == null ? 10 : weight;
    }

    @Override
    protected List<String> getConsistentAttributeNames() {
        return Collections.singletonList(this.createSpiAttributeName(NODE_WEIGHT_ATTR_NAME));
    }

    public String toString() {
        return S.toString(WeightedRandomLoadBalancingSpi.class, this);
    }

    private class WeightedTopology {
        private final int totalWeight;
        private final SortedMap<Integer, ClusterNode> circle = new TreeMap<Integer, ClusterNode>();

        WeightedTopology(Collection<ClusterNode> top) {
            assert (!F.isEmpty(top));
            int totalWeight = 0;
            for (ClusterNode node : top) {
                this.circle.put(totalWeight += WeightedRandomLoadBalancingSpi.this.getWeight(node), node);
            }
            this.totalWeight = totalWeight;
        }

        ClusterNode pickWeightedNode() {
            int weight = RAND.nextInt(this.totalWeight) + 1;
            SortedMap<Integer, ClusterNode> pick = this.circle.tailMap(weight);
            assert (!pick.isEmpty());
            return (ClusterNode)pick.get(pick.firstKey());
        }
    }
}

