/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.swapspace;

import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class SwapKey {
    @GridToStringInclude
    private final Object key;
    private final int part;
    @GridToStringExclude
    private byte[] keyBytes;

    public SwapKey(Object key) {
        this.key = key;
        this.part = Integer.MAX_VALUE;
    }

    public SwapKey(Object key, int part) {
        this.key = key;
        this.part = part;
    }

    public SwapKey(KeyCacheObject key, int part, @Nullable byte[] keyBytes) {
        assert (key != null);
        assert (part >= 0);
        this.key = key;
        this.part = part;
        this.keyBytes = keyBytes;
    }

    public Object key() {
        return this.key;
    }

    public int partition() {
        return this.part;
    }

    @Nullable
    public byte[] keyBytes() {
        return this.keyBytes;
    }

    public void keyBytes(byte[] keyBytes) {
        assert (keyBytes != null);
        this.keyBytes = keyBytes;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SwapKey) {
            SwapKey other = (SwapKey)obj;
            return this.part == other.part && this.key.equals(other.key);
        }
        return false;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return S.toString(SwapKey.class, this);
    }
}

