/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.swapspace.file;

import java.util.concurrent.atomic.AtomicReferenceArray;
import org.jetbrains.annotations.Nullable;

class FileSwapArray<X> {
    private static final int FIRST_ARRAY_SIZE = 4096;
    private static final int LADDER_SIZE = Integer.numberOfLeadingZeros(4096) + 1;
    private final AtomicReferenceArray<X>[] ladder = new AtomicReferenceArray[LADDER_SIZE];
    private int idx = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileSwapArray() {
        AtomicReferenceArray<X>[] atomicReferenceArrayArray = this.ladder;
        synchronized (this.ladder) {
            this.ladder[0] = new AtomicReferenceArray(4096);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public int size() {
        return this.idx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int add(X x) {
        int i = this.idx++;
        assert (i >= 0 && i != Integer.MAX_VALUE) : "Integer overflow";
        Slot<X> s = this.slot(i);
        assert (s != null);
        ((Slot)s).set(x);
        int len = ((Slot)s).arr.length();
        if (((Slot)s).idx + 1 != len) return i;
        AtomicReferenceArray<X>[] atomicReferenceArrayArray = this.ladder;
        synchronized (this.ladder) {
            this.ladder[((Slot)s).arrIdx + 1] = new AtomicReferenceArray(((Slot)s).arrIdx == 0 ? len : len << 1);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void truncate(int size) {
        assert (size > 0);
        this.idx = size;
        int arrIdx = FileSwapArray.arrayIndex(this.idx) + 1;
        if (arrIdx >= this.ladder.length || this.ladder[arrIdx] == null) return;
        AtomicReferenceArray<X>[] atomicReferenceArrayArray = this.ladder;
        synchronized (this.ladder) {
            do {
                this.ladder[arrIdx++] = null;
            } while (arrIdx < this.ladder.length && this.ladder[arrIdx] != null);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    static int arrayIndex(int idx) {
        if (idx < 4096) {
            return 0;
        }
        return LADDER_SIZE - Integer.numberOfLeadingZeros(idx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    Slot<X> slot(int idx) {
        assert (idx > 0) : idx;
        int arrIdx = FileSwapArray.arrayIndex(idx);
        AtomicReferenceArray<X> arr = this.ladder[arrIdx];
        if (arr != null) return new Slot(arrIdx, arr, arrIdx == 0 ? idx : idx - arr.length());
        AtomicReferenceArray<X>[] atomicReferenceArrayArray = this.ladder;
        synchronized (this.ladder) {
            arr = this.ladder[arrIdx];
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (arr != null) return new Slot(arrIdx, arr, arrIdx == 0 ? idx : idx - arr.length());
            return null;
        }
    }

    static final class Slot<X> {
        private final int arrIdx;
        private final AtomicReferenceArray<X> arr;
        private final int idx;

        private Slot(int arrIdx, AtomicReferenceArray<X> arr, int idx) {
            this.arrIdx = arrIdx;
            this.arr = arr;
            this.idx = idx;
        }

        public X get() {
            return this.arr.get(this.idx);
        }

        public boolean cas(@Nullable X exp, @Nullable X x) {
            return exp == x || this.arr.compareAndSet(this.idx, exp, x);
        }

        private void set(X x) {
            this.arr.lazySet(this.idx, x);
        }
    }
}

