/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.swapspace.noop;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.GridEmptyCloseableIterator;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiCloseableIterator;
import org.apache.ignite.spi.IgniteSpiConsistencyChecked;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.IgniteSpiMultipleInstancesSupport;
import org.apache.ignite.spi.IgniteSpiNoop;
import org.apache.ignite.spi.swapspace.SwapContext;
import org.apache.ignite.spi.swapspace.SwapKey;
import org.apache.ignite.spi.swapspace.SwapSpaceSpi;
import org.apache.ignite.spi.swapspace.SwapSpaceSpiListener;
import org.jetbrains.annotations.Nullable;

@IgniteSpiNoop
@IgniteSpiMultipleInstancesSupport(value=true)
@IgniteSpiConsistencyChecked(optional=false, checkClient=false)
public class NoopSwapSpaceSpi
extends IgniteSpiAdapter
implements SwapSpaceSpi {
    @LoggerResource
    private IgniteLogger log;

    @Override
    public void spiStart(@Nullable String gridName) throws IgniteSpiException {
        U.warn(this.log, "Swap space is disabled. To enable use FileSwapSpaceSpi.");
    }

    @Override
    public void spiStop() throws IgniteSpiException {
    }

    @Override
    public void clear(@Nullable String space) throws IgniteSpiException {
    }

    @Override
    public long size(@Nullable String space) throws IgniteSpiException {
        return 0L;
    }

    @Override
    public long count(@Nullable String space) throws IgniteSpiException {
        return 0L;
    }

    @Override
    public long count(@Nullable String spaceName, Set<Integer> parts) throws IgniteSpiException {
        return 0L;
    }

    @Override
    @Nullable
    public byte[] read(@Nullable String spaceName, SwapKey key, SwapContext ctx) throws IgniteSpiException {
        return null;
    }

    @Override
    public Map<SwapKey, byte[]> readAll(@Nullable String spaceName, Iterable<SwapKey> keys, SwapContext ctx) throws IgniteSpiException {
        return Collections.emptyMap();
    }

    @Override
    public void remove(@Nullable String spaceName, SwapKey key, @Nullable IgniteInClosure<byte[]> c, SwapContext ctx) throws IgniteSpiException {
    }

    @Override
    public void removeAll(@Nullable String spaceName, Collection<SwapKey> keys, @Nullable IgniteBiInClosure<SwapKey, byte[]> c, SwapContext ctx) throws IgniteSpiException {
    }

    @Override
    public void store(@Nullable String spaceName, SwapKey key, @Nullable byte[] val, SwapContext ctx) throws IgniteSpiException {
    }

    @Override
    public void storeAll(@Nullable String spaceName, Map<SwapKey, byte[]> pairs, SwapContext ctx) throws IgniteSpiException {
    }

    @Override
    public void setListener(@Nullable SwapSpaceSpiListener evictLsnr) {
    }

    @Override
    public Collection<Integer> partitions(@Nullable String spaceName) throws IgniteSpiException {
        return Collections.emptyList();
    }

    @Override
    public <K> IgniteSpiCloseableIterator<K> keyIterator(@Nullable String spaceName, SwapContext ctx) throws IgniteSpiException {
        return new GridEmptyCloseableIterator();
    }

    @Override
    public IgniteSpiCloseableIterator<Map.Entry<byte[], byte[]>> rawIterator(@Nullable String spaceName) throws IgniteSpiException {
        return new GridEmptyCloseableIterator<Map.Entry<byte[], byte[]>>();
    }

    @Override
    public IgniteSpiCloseableIterator<Map.Entry<byte[], byte[]>> rawIterator(@Nullable String spaceName, int part) throws IgniteSpiException {
        return new GridEmptyCloseableIterator<Map.Entry<byte[], byte[]>>();
    }

    public String toString() {
        return S.toString(NoopSwapSpaceSpi.class, this);
    }
}

