/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.stream;

import java.util.Collection;
import java.util.Map;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheEntryProcessor;
import org.apache.ignite.stream.StreamReceiver;

public abstract class StreamTransformer<K, V>
implements StreamReceiver<K, V>,
EntryProcessor<K, V, Object> {
    private static final long serialVersionUID = 0L;

    @Override
    public void receive(IgniteCache<K, V> cache, Collection<Map.Entry<K, V>> entries) throws IgniteException {
        for (Map.Entry<K, V> entry : entries) {
            cache.invoke(entry.getKey(), this, entry.getValue());
        }
    }

    public static <K, V> StreamTransformer<K, V> from(final CacheEntryProcessor<K, V, Object> ep) {
        return new StreamTransformer<K, V>(){

            @Override
            public Object process(MutableEntry<K, V> entry, Object ... args) throws EntryProcessorException {
                return ep.process(entry, args);
            }
        };
    }
}

