/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.thread;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.worker.GridWorker;

public class IgniteThread
extends Thread {
    public static final int GRP_IDX_UNASSIGNED = -1;
    private static final ThreadGroup DFLT_GRP = new ThreadGroup("ignite");
    private static final AtomicLong cntr = new AtomicLong();
    protected final String gridName;
    private final int grpIdx;

    public IgniteThread(GridWorker worker) {
        this(DFLT_GRP, worker.gridName(), worker.name(), worker, -1);
    }

    public IgniteThread(String gridName, String threadName, Runnable r) {
        this(gridName, threadName, r, -1);
    }

    public IgniteThread(String gridName, String threadName, Runnable r, int grpIdx) {
        this(DFLT_GRP, gridName, threadName, r, grpIdx);
    }

    public IgniteThread(ThreadGroup grp, String gridName, String threadName, Runnable r, int grpIdx) {
        super(grp, r, IgniteThread.createName(cntr.incrementAndGet(), threadName, gridName));
        this.gridName = gridName;
        this.grpIdx = grpIdx;
    }

    protected IgniteThread(String gridName, ThreadGroup threadGrp, String threadName) {
        super(threadGrp, threadName);
        this.gridName = gridName;
        this.grpIdx = -1;
    }

    public String getGridName() {
        return this.gridName;
    }

    public int groupIndex() {
        return this.grpIdx;
    }

    protected static String createName(long num, String threadName, String gridName) {
        return threadName + "-#" + num + '%' + gridName + '%';
    }

    @Override
    public String toString() {
        return S.toString(IgniteThread.class, this, "name", this.getName());
    }
}

