/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.thread;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.thread.IgniteThread;
import org.jetbrains.annotations.NotNull;

public class IgniteThreadFactory
implements ThreadFactory {
    private final String gridName;
    private final String threadName;
    private final AtomicInteger idxGen = new AtomicInteger();

    public IgniteThreadFactory(String gridName) {
        this(gridName, "ignite");
    }

    public IgniteThreadFactory(String gridName, String threadName) {
        this.gridName = gridName;
        this.threadName = threadName;
    }

    @Override
    public Thread newThread(@NotNull Runnable r) {
        return new IgniteThread(this.gridName, this.threadName, r, this.idxGen.incrementAndGet());
    }

    public String toString() {
        return S.toString(IgniteThreadFactory.class, this, super.toString());
    }
}

