/*
 * Decompiled with CFR 0.152.
 */
package org.jsr166;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentLinkedDeque8;
import org.jsr166.LongAdder8;

public class ConcurrentLinkedHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    public static final int DFLT_INIT_CAP = 16;
    public static final float DFLT_LOAD_FACTOR = 0.75f;
    public static final int DFLT_CONCUR_LVL = 16;
    public static final int MAX_CAP_LIMIT = 0x40000000;
    public static final int MAX_SEGS = 65536;
    public static final int RETRIES_BEFORE_LOCK = 2;
    private final int segmentMask;
    private final int segmentShift;
    private final Segment<K, V>[] segments;
    private Set<K> keySet;
    private Set<K> descKeySet;
    private Set<Map.Entry<K, V>> entrySet;
    private Set<Map.Entry<K, V>> descEntrySet;
    private Collection<V> vals;
    private Collection<V> descVals;
    private final ConcurrentLinkedDeque8<HashEntry<K, V>> entryQ;
    private final LongAdder8 size = new LongAdder8();
    private final LongAdder8 modCnt = new LongAdder8();
    private final int maxCap;
    private final QueuePolicy qPlc;

    private static int hash(int h) {
        h ^= h >>> 16;
        h *= -2048144789;
        h ^= h >>> 13;
        return (h *= -1028477387) >>> 16 ^ h;
    }

    private Segment<K, V> segmentFor(int hash) {
        return this.segments[hash >>> this.segmentShift & this.segmentMask];
    }

    public ConcurrentLinkedHashMap(int initCap, float loadFactor, int concurLvl, int maxCap, QueuePolicy qPlc) {
        int cap;
        int c;
        int ssize;
        if (!(loadFactor > 0.0f) || initCap < 0 || concurLvl <= 0) {
            throw new IllegalArgumentException();
        }
        if (concurLvl > 65536) {
            concurLvl = 65536;
        }
        this.maxCap = maxCap;
        this.qPlc = qPlc;
        this.entryQ = qPlc == QueuePolicy.SINGLE_Q ? new ConcurrentLinkedDeque8() : null;
        int sshift = 0;
        for (ssize = 1; ssize < concurLvl; ssize <<= 1) {
            ++sshift;
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = ssize - 1;
        this.segments = new Segment[ssize];
        if (initCap > 0x40000000) {
            initCap = 0x40000000;
        }
        if ((c = initCap / ssize) * ssize < initCap) {
            ++c;
        }
        for (cap = 1; cap < c; cap <<= 1) {
        }
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new Segment(cap, loadFactor);
        }
    }

    public ConcurrentLinkedHashMap(int initCap, float loadFactor, int concurLvl, int maxCap) {
        this(initCap, loadFactor, concurLvl, maxCap, QueuePolicy.SINGLE_Q);
    }

    public ConcurrentLinkedHashMap(int initCap, float loadFactor, int concurLvl) {
        this(initCap, loadFactor, concurLvl, 0);
    }

    public ConcurrentLinkedHashMap(int initCap, float loadFactor) {
        this(initCap, loadFactor, 16);
    }

    public ConcurrentLinkedHashMap(int initCap) {
        this(initCap, 0.75f, 16);
    }

    public ConcurrentLinkedHashMap() {
        this(16, 0.75f, 16);
    }

    public ConcurrentLinkedHashMap(Map<? extends K, ? extends V> m) {
        this(Math.max((int)((float)m.size() / 0.75f) + 1, 16), 0.75f, 16);
        this.putAll(m);
    }

    @Override
    public boolean isEmpty() {
        int i;
        Segment<K, V>[] segments = this.segments;
        int[] mc = new int[segments.length];
        int mcsum = 0;
        for (i = 0; i < segments.length; ++i) {
            if (((Segment)segments[i]).cnt != 0) {
                return false;
            }
            mc[i] = ((Segment)segments[i]).modCnt;
            mcsum += mc[i];
        }
        if (mcsum != 0) {
            for (i = 0; i < segments.length; ++i) {
                if (((Segment)segments[i]).cnt == 0 && mc[i] == ((Segment)segments[i]).modCnt) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int size() {
        Segment<K, V>[] segments = this.segments;
        long sum = 0L;
        long check = 0L;
        int[] mc = new int[segments.length];
        for (int k = 0; k < 2; ++k) {
            int i;
            check = 0L;
            sum = 0L;
            int mcsum = 0;
            for (i = 0; i < segments.length; ++i) {
                sum += (long)((Segment)segments[i]).cnt;
                mc[i] = ((Segment)segments[i]).modCnt;
                mcsum += mc[i];
            }
            if (mcsum != 0) {
                for (i = 0; i < segments.length; ++i) {
                    check += (long)((Segment)segments[i]).cnt;
                    if (mc[i] == ((Segment)segments[i]).modCnt) continue;
                    check = -1L;
                    break;
                }
            }
            if (check == sum) break;
        }
        if (check != sum) {
            sum = 0L;
            for (Segment<K, V> segment : segments) {
                segment.readLock().lock();
            }
            for (Segment<K, V> segment : segments) {
                sum += (long)((Segment)segment).cnt;
            }
            for (Segment<K, V> segment : segments) {
                segment.readLock().unlock();
            }
        }
        return sum > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)sum;
    }

    public int sizex() {
        int i = this.size.intValue();
        return i > 0 ? i : 0;
    }

    public boolean isEmptyx() {
        return this.sizex() == 0;
    }

    @Override
    public V get(Object key) {
        int hash = ConcurrentLinkedHashMap.hash(key.hashCode());
        return this.segmentFor(hash).get(key, hash);
    }

    public V getSafe(Object key) {
        int hash = ConcurrentLinkedHashMap.hash(key.hashCode());
        return this.segmentFor(hash).getSafe(key, hash);
    }

    @Override
    public boolean containsKey(Object key) {
        int hash = ConcurrentLinkedHashMap.hash(key.hashCode());
        return this.segmentFor(hash).containsKey(key, hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object val) {
        if (val == null) {
            throw new NullPointerException();
        }
        Segment<K, V>[] segments = this.segments;
        int[] mc = new int[segments.length];
        for (int k = 0; k < 2; ++k) {
            int mcsum = 0;
            for (int i = 0; i < segments.length; ++i) {
                mc[i] = ((Segment)segments[i]).modCnt;
                mcsum += mc[i];
                if (!segments[i].containsValue(val)) continue;
                return true;
            }
            boolean cleanSweep = true;
            if (mcsum != 0) {
                for (int i = 0; i < segments.length; ++i) {
                    if (mc[i] == ((Segment)segments[i]).modCnt) continue;
                    cleanSweep = false;
                    break;
                }
            }
            if (!cleanSweep) continue;
            return false;
        }
        for (Segment<K, V> segment : segments) {
            segment.readLock().lock();
        }
        boolean found = false;
        try {
            for (Segment<K, V> segment : segments) {
                if (!segment.containsValue(val)) continue;
                found = true;
                break;
            }
        }
        finally {
            for (Segment<K, V> segment : segments) {
                segment.readLock().unlock();
            }
        }
        return found;
    }

    public boolean contains(Object val) {
        return this.containsValue(val);
    }

    @Override
    public V put(K key, V val) {
        if (val == null) {
            throw new NullPointerException();
        }
        int hash = ConcurrentLinkedHashMap.hash(key.hashCode());
        return this.segmentFor(hash).put(key, hash, val, false);
    }

    @Override
    public V putIfAbsent(K key, V val) {
        if (val == null) {
            throw new NullPointerException();
        }
        int hash = ConcurrentLinkedHashMap.hash(key.hashCode());
        return this.segmentFor(hash).put(key, hash, val, true);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        int hash = ConcurrentLinkedHashMap.hash(key.hashCode());
        return this.segmentFor(hash).remove(key, hash, null, true);
    }

    @Override
    public boolean remove(Object key, Object val) {
        int hash = ConcurrentLinkedHashMap.hash(key.hashCode());
        return val != null && this.segmentFor(hash).remove(key, hash, val, true) != null;
    }

    @Override
    public boolean replace(K key, V oldVal, V newVal) {
        if (oldVal == null || newVal == null) {
            throw new NullPointerException();
        }
        int hash = ConcurrentLinkedHashMap.hash(key.hashCode());
        return this.segmentFor(hash).replace(key, hash, oldVal, newVal);
    }

    public V replacex(K key, V oldVal, V newVal) {
        if (oldVal == null || newVal == null) {
            throw new NullPointerException();
        }
        int hash = ConcurrentLinkedHashMap.hash(key.hashCode());
        return this.segmentFor(hash).replacex(key, hash, oldVal, newVal);
    }

    @Override
    public V replace(K key, V val) {
        if (val == null) {
            throw new NullPointerException();
        }
        int hash = ConcurrentLinkedHashMap.hash(key.hashCode());
        return this.segmentFor(hash).replace(key, hash, val);
    }

    @Override
    public void clear() {
        for (Segment<K, V> segment : this.segments) {
            segment.clear();
        }
    }

    @Override
    public Set<K> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    public Set<K> descendingKeySet() {
        KeySetDescending ks = this.descKeySet;
        return ks != null ? ks : (this.descKeySet = new KeySetDescending());
    }

    @Override
    public Collection<V> values() {
        Values vs = this.vals;
        return vs != null ? vs : (this.vals = new Values());
    }

    public Collection<V> descendingValues() {
        ValuesDescending vs = this.descVals;
        return vs != null ? vs : (this.descVals = new ValuesDescending());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    public Set<Map.Entry<K, V>> descendingEntrySet() {
        EntrySetDescending es = this.descEntrySet;
        return es != null ? es : (this.descEntrySet = new EntrySetDescending());
    }

    public Enumeration<K> keys() {
        return new KeyIterator(true);
    }

    public Enumeration<K> descendingKeys() {
        return new KeyIterator(false);
    }

    public Enumeration<V> elements() {
        return new ValueIterator(true);
    }

    public Enumeration<V> descendingElements() {
        return new ValueIterator(false);
    }

    private void recordInsert(HashEntry e, ConcurrentLinkedDeque8 q) {
        e.node = q.addx(e);
    }

    private void checkRemoveEldestEntry() {
        assert (this.maxCap > 0);
        assert (this.qPlc == QueuePolicy.SINGLE_Q);
        int sizex = this.sizex();
        for (int i = this.maxCap; i < sizex; ++i) {
            HashEntry<K, V> e = this.entryQ.poll();
            if (e == null) {
                return;
            }
            this.segmentFor(((HashEntry)e).hash).remove(((HashEntry)e).key, ((HashEntry)e).hash, ((HashEntry)e).val, false);
            if (this.sizex() > this.maxCap) continue;
            return;
        }
    }

    public ConcurrentLinkedDeque8<HashEntry<K, V>> queue() {
        return this.entryQ;
    }

    public QueuePolicy policy() {
        return this.qPlc;
    }

    static /* synthetic */ void access$900(ConcurrentLinkedHashMap x0, HashEntry x1, ConcurrentLinkedDeque8 x2) {
        x0.recordInsert(x1, x2);
    }

    static /* synthetic */ void access$1200(ConcurrentLinkedHashMap x0) {
        x0.checkRemoveEldestEntry();
    }

    public static enum QueuePolicy {
        SINGLE_Q,
        PER_SEGMENT_Q,
        PER_SEGMENT_Q_OPTIMIZED_RMV;

    }

    private final class EntrySetDescending
    extends AbstractEntrySet {
        private EntrySetDescending() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(false);
        }
    }

    private final class EntrySet
    extends AbstractEntrySet {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(true);
        }
    }

    private abstract class AbstractEntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private AbstractEntrySet() {
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object v = ConcurrentLinkedHashMap.this.get(e.getKey());
            return v != null && v.equals(e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return ConcurrentLinkedHashMap.this.remove(e.getKey(), e.getValue());
        }

        @Override
        public int size() {
            return ConcurrentLinkedHashMap.this.size();
        }

        @Override
        public void clear() {
            ConcurrentLinkedHashMap.this.clear();
        }
    }

    private final class ValuesDescending
    extends AbstractValues {
        private ValuesDescending() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator(false);
        }
    }

    private final class Values
    extends AbstractValues {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator(true);
        }
    }

    private abstract class AbstractValues
    extends AbstractCollection<V> {
        private AbstractValues() {
        }

        @Override
        public int size() {
            return ConcurrentLinkedHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return ConcurrentLinkedHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            ConcurrentLinkedHashMap.this.clear();
        }
    }

    private final class KeySetDescending
    extends AbstractKeySet {
        private KeySetDescending() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator(false);
        }
    }

    private final class KeySet
    extends AbstractKeySet {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator(true);
        }
    }

    private abstract class AbstractKeySet
    extends AbstractSet<K> {
        private AbstractKeySet() {
        }

        @Override
        public int size() {
            return ConcurrentLinkedHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return ConcurrentLinkedHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return ConcurrentLinkedHashMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            ConcurrentLinkedHashMap.this.clear();
        }
    }

    private final class EntryIterator
    extends HashIterator
    implements Iterator<Map.Entry<K, V>> {
        private EntryIterator(boolean asc) {
            super(asc);
        }

        @Override
        public Map.Entry<K, V> next() {
            HashEntry e = this.nextEntry();
            return new WriteThroughEntry(e.key, e.val);
        }
    }

    private final class WriteThroughEntry
    extends AbstractMap.SimpleEntry<K, V> {
        WriteThroughEntry(K k, V v) {
            super(k, v);
        }

        @Override
        public V setValue(V val) {
            if (val == null) {
                throw new NullPointerException();
            }
            Object v = super.setValue(val);
            ConcurrentLinkedHashMap.this.put(this.getKey(), val);
            return v;
        }
    }

    private final class ValueIterator
    extends HashIterator
    implements Iterator<V>,
    Enumeration<V> {
        private ValueIterator(boolean asc) {
            super(asc);
        }

        @Override
        public V next() {
            return this.nextEntry().val;
        }

        @Override
        public V nextElement() {
            return this.nextEntry().val;
        }
    }

    private final class KeyIterator
    extends HashIterator
    implements Iterator<K>,
    Enumeration<K> {
        private KeyIterator(boolean asc) {
            super(asc);
        }

        @Override
        public K next() {
            return this.nextEntry().key;
        }

        @Override
        public K nextElement() {
            return this.nextEntry().key;
        }
    }

    private class HashIteratorDelegate
    implements Iterator<HashEntry<K, V>> {
        private HashEntry<K, V>[] curTbl;
        private int nextSegIdx;
        private int nextTblIdx;
        private HashEntry<K, V> next;
        private HashEntry<K, V> next0;
        private HashEntry<K, V> cur;

        public HashIteratorDelegate() {
            this.nextSegIdx = ConcurrentLinkedHashMap.this.segments.length - 1;
            this.nextTblIdx = -1;
            this.advance();
        }

        private void advance() {
            if (this.next0 != null && this.advanceInBucket(this.next0, true)) {
                return;
            }
            while (this.nextTblIdx >= 0) {
                HashEntry bucket;
                if ((bucket = this.curTbl[this.nextTblIdx--]) == null || !this.advanceInBucket(bucket, false)) continue;
                return;
            }
            while (this.nextSegIdx >= 0) {
                int nextSegIdx0;
                --this.nextSegIdx;
                Segment seg = ConcurrentLinkedHashMap.this.segments[nextSegIdx0];
                this.curTbl = seg.tbl;
                for (int j = this.curTbl.length - 1; j >= 0; --j) {
                    HashEntry bucket = this.curTbl[j];
                    if (bucket == null || !this.advanceInBucket(bucket, false)) continue;
                    this.nextTblIdx = j - 1;
                    return;
                }
            }
        }

        private boolean advanceInBucket(@Nullable HashEntry<K, V> e, boolean skipFirst) {
            if (e == null) {
                return false;
            }
            this.next0 = e;
            do {
                if (!skipFirst) {
                    this.next = this.next0;
                    return true;
                }
                skipFirst = false;
            } while ((this.next0 = this.next0.next) != null);
            assert (this.next0 == null);
            this.next = null;
            return false;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public HashEntry<K, V> next() {
            HashEntry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.advance();
            return e;
        }

        @Override
        public void remove() {
            if (this.cur == null) {
                throw new IllegalStateException();
            }
            HashEntry e = this.cur;
            this.cur = null;
            ConcurrentLinkedHashMap.this.remove(e.key, e.val);
        }
    }

    private abstract class HashIterator {
        private Iterator<HashEntry<K, V>> delegate;
        private HashEntry<K, V> lastReturned;
        private HashEntry<K, V> nextEntry;
        private int modCnt;

        HashIterator(boolean asc) {
            this.modCnt = ConcurrentLinkedHashMap.this.modCnt.intValue();
            switch (ConcurrentLinkedHashMap.this.qPlc) {
                case SINGLE_Q: {
                    this.delegate = asc ? ConcurrentLinkedHashMap.this.entryQ.iterator() : ConcurrentLinkedHashMap.this.entryQ.descendingIterator();
                    break;
                }
                default: {
                    assert (ConcurrentLinkedHashMap.this.qPlc == QueuePolicy.PER_SEGMENT_Q || ConcurrentLinkedHashMap.this.qPlc == QueuePolicy.PER_SEGMENT_Q_OPTIMIZED_RMV) : ConcurrentLinkedHashMap.access$000(concurrentLinkedHashMap);
                    this.delegate = new HashIteratorDelegate();
                }
            }
            this.advance();
        }

        public boolean hasMoreElements() {
            return this.hasNext();
        }

        public boolean hasNext() {
            return this.nextEntry != null;
        }

        HashEntry<K, V> nextEntry() {
            if (this.nextEntry == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextEntry;
            this.advance();
            return this.lastReturned;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            ConcurrentLinkedHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
        }

        private void advance() {
            this.nextEntry = null;
            while (this.delegate.hasNext()) {
                HashEntry n = this.delegate.next();
                if (n.modCnt > this.modCnt) continue;
                this.nextEntry = n;
                break;
            }
        }
    }

    private final class Segment<K, V>
    extends ReentrantReadWriteLock {
        private volatile transient int cnt;
        private transient int modCnt;
        private transient int threshold;
        private volatile transient HashEntry<K, V>[] tbl;
        private final float loadFactor;
        private final Queue<HashEntry<K, V>> segEntryQ;

        Segment(int initCap, float loadFactor) {
            this.loadFactor = loadFactor;
            this.segEntryQ = (Queue)((Object)(ConcurrentLinkedHashMap.this.qPlc == QueuePolicy.PER_SEGMENT_Q ? new ArrayDeque() : (ConcurrentLinkedHashMap.this.qPlc == QueuePolicy.PER_SEGMENT_Q_OPTIMIZED_RMV ? new ConcurrentLinkedDeque8() : null)));
            this.setTable(HashEntry.newArray(initCap));
        }

        void setTable(HashEntry<K, V>[] newTbl) {
            this.threshold = (int)((float)newTbl.length * this.loadFactor);
            this.tbl = newTbl;
        }

        HashEntry<K, V> getFirst(int hash) {
            HashEntry<K, V>[] tab = this.tbl;
            return tab[hash & tab.length - 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V readValueUnderLock(HashEntry<K, V> e) {
            this.readLock().lock();
            try {
                Object object = ((HashEntry)e).val;
                return (V)object;
            }
            finally {
                this.readLock().unlock();
            }
        }

        V get(Object key, int hash) {
            if (this.cnt != 0) {
                HashEntry e = this.getFirst(hash);
                while (e != null) {
                    if (e.hash == hash && key.equals(e.key)) {
                        Object v = e.val;
                        if (v != null) {
                            return (V)v;
                        }
                        v = this.readValueUnderLock(e);
                        return (V)v;
                    }
                    e = e.next;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V getSafe(Object key, int hash) {
            this.readLock().lock();
            try {
                HashEntry e = this.getFirst(hash);
                while (e != null) {
                    if (e.hash == hash && key.equals(e.key)) {
                        Object object = e.val;
                        return (V)object;
                    }
                    e = e.next;
                }
                V v = null;
                return v;
            }
            finally {
                this.readLock().unlock();
            }
        }

        boolean containsKey(Object key, int hash) {
            if (this.cnt != 0) {
                HashEntry e = this.getFirst(hash);
                while (e != null) {
                    if (e.hash == hash && key.equals(e.key)) {
                        return true;
                    }
                    e = e.next;
                }
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        boolean containsValue(Object val) {
            if (this.cnt != 0) {
                for (HashEntry<K, V> hashEntry : this.tbl) {
                    void var5_5;
                    while (var5_5 != null) {
                        Object v = ((HashEntry)var5_5).val;
                        if (v == null) {
                            v = this.readValueUnderLock((HashEntry<K, V>)var5_5);
                        }
                        if (val.equals(v)) {
                            return true;
                        }
                        HashEntry hashEntry2 = ((HashEntry)var5_5).next;
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean replace(K key, int hash, V oldVal, V newVal) {
            this.writeLock().lock();
            boolean replaced = false;
            try {
                HashEntry e = this.getFirst(hash);
                while (!(e == null || e.hash == hash && key.equals(e.key))) {
                    e = e.next;
                }
                if (e != null && oldVal.equals(e.val)) {
                    replaced = true;
                    e.val = newVal;
                }
            }
            finally {
                this.writeLock().unlock();
            }
            return replaced;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V replacex(K key, int hash, V oldVal, V newVal) {
            this.writeLock().lock();
            Object replaced = null;
            try {
                HashEntry e = this.getFirst(hash);
                while (!(e == null || e.hash == hash && key.equals(e.key))) {
                    e = e.next;
                }
                if (e != null) {
                    if (oldVal.equals(e.val)) {
                        replaced = oldVal;
                        e.val = newVal;
                    } else {
                        replaced = e.val;
                    }
                }
            }
            finally {
                this.writeLock().unlock();
            }
            return (V)replaced;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V replace(K key, int hash, V newVal) {
            this.writeLock().lock();
            Object oldVal = null;
            try {
                HashEntry e = this.getFirst(hash);
                while (!(e == null || e.hash == hash && key.equals(e.key))) {
                    e = e.next;
                }
                if (e != null) {
                    oldVal = e.val;
                    e.val = newVal;
                }
            }
            finally {
                this.writeLock().unlock();
            }
            return (V)oldVal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        V put(K key, int hash, V val, boolean onlyIfAbsent) {
            block18: {
                this.writeLock().lock();
                added = false;
                try {
                    c = this.cnt;
                    if (c++ > this.threshold) {
                        this.rehash();
                    }
                    tab = this.tbl;
                    idx = hash & tab.length - 1;
                    e = first = tab[idx];
                    while (!(e == null || HashEntry.access$200(e) == hash && key.equals(HashEntry.access$300(e)))) {
                        e = HashEntry.access$400(e);
                    }
                    modified = false;
                    if (e != null) {
                        oldVal = HashEntry.access$100(e);
                        if (!onlyIfAbsent) {
                            HashEntry.access$102(e, val);
                            node = HashEntry.access$500(e);
                            if (node != null && (qEntry = (HashEntry)node.item()) != null && qEntry != e) {
                                HashEntry.access$102(qEntry, val);
                            }
                            modified = true;
                        }
                    } else {
                        oldVal = null;
                        ++this.modCnt;
                        ConcurrentLinkedHashMap.access$600(ConcurrentLinkedHashMap.this).increment();
                        tab[idx] = new HashEntry<K, V>(key, hash, first, val);
                        e = tab[idx];
                        ConcurrentLinkedHashMap.access$700(ConcurrentLinkedHashMap.this).increment();
                        HashEntry.access$802(e, ConcurrentLinkedHashMap.access$700(ConcurrentLinkedHashMap.this).intValue());
                        this.cnt = c;
                        added = true;
                    }
                    if (!Segment.$assertionsDisabled && added && modified) {
                        throw new AssertionError();
                    }
                    if (!added) break block18;
                    switch (1.$SwitchMap$org$jsr166$ConcurrentLinkedHashMap$QueuePolicy[ConcurrentLinkedHashMap.access$000(ConcurrentLinkedHashMap.this).ordinal()]) {
                        case 1: {
                            ConcurrentLinkedHashMap.access$900(ConcurrentLinkedHashMap.this, e, (ConcurrentLinkedDeque8)this.segEntryQ);
                            if (ConcurrentLinkedHashMap.access$1000(ConcurrentLinkedHashMap.this) > 0) {
                                this.checkRemoveEldestEntrySegment(c);
                                ** break;
                            }
lbl44:
                            // 3 sources

                            break;
                        }
                        case 2: {
                            this.segEntryQ.add(e);
                            if (ConcurrentLinkedHashMap.access$1000(ConcurrentLinkedHashMap.this) > 0) {
                                this.checkRemoveEldestEntrySegment(c);
                                ** break;
                            }
lbl51:
                            // 3 sources

                            break;
                        }
                        default: {
                            if (!Segment.$assertionsDisabled && ConcurrentLinkedHashMap.access$000(ConcurrentLinkedHashMap.this) != QueuePolicy.SINGLE_Q) {
                                throw new AssertionError();
                            }
                            ConcurrentLinkedHashMap.access$900(ConcurrentLinkedHashMap.this, e, ConcurrentLinkedHashMap.access$1100(ConcurrentLinkedHashMap.this));
                            break;
                        }
                    }
                }
                finally {
                    this.writeLock().unlock();
                }
            }
            if (ConcurrentLinkedHashMap.access$000(ConcurrentLinkedHashMap.this) == QueuePolicy.SINGLE_Q && added && ConcurrentLinkedHashMap.access$1000(ConcurrentLinkedHashMap.this) > 0) {
                ConcurrentLinkedHashMap.access$1200(ConcurrentLinkedHashMap.this);
            }
            return (V)oldVal;
        }

        private void checkRemoveEldestEntrySegment(int cnt) {
            assert (ConcurrentLinkedHashMap.this.maxCap > 0);
            if (cnt - (ConcurrentLinkedHashMap.this.maxCap / ConcurrentLinkedHashMap.this.segments.length + 1) > 0) {
                HashEntry<K, V> e0 = this.segEntryQ.poll();
                assert (e0 != null);
                this.removeLocked(((HashEntry)e0).key, ((HashEntry)e0).hash, null, false);
            }
        }

        void rehash() {
            HashEntry<K, V>[] oldTbl = this.tbl;
            int oldCap = oldTbl.length;
            if (oldCap >= 0x40000000) {
                return;
            }
            int c = this.cnt;
            HashEntry<K, V>[] newTbl = HashEntry.newArray(oldCap << 1);
            this.threshold = (int)((float)newTbl.length * this.loadFactor);
            int sizeMask = newTbl.length - 1;
            for (int i = 0; i < oldCap; ++i) {
                int k;
                HashEntry e = oldTbl[i];
                if (e == null) continue;
                HashEntry next = e.next;
                int idx = e.hash & sizeMask;
                if (next == null) {
                    newTbl[idx] = e;
                    continue;
                }
                HashEntry lastRun = e;
                int lastIdx = idx;
                HashEntry last = next;
                while (last != null) {
                    k = last.hash & sizeMask;
                    if (k != lastIdx) {
                        lastIdx = k;
                        lastRun = last;
                    }
                    last = last.next;
                }
                newTbl[lastIdx] = lastRun;
                HashEntry p = e;
                while (p != lastRun) {
                    k = p.hash & sizeMask;
                    HashEntry n = newTbl[k];
                    HashEntry<Object, Object> e0 = new HashEntry<Object, Object>(p.key, p.hash, n, p.val, p.node, p.modCnt);
                    newTbl[k] = e0;
                    p = p.next;
                }
            }
            this.cnt = c;
            this.tbl = newTbl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V remove(Object key, int hash, Object val, boolean cleanupQ) {
            this.writeLock().lock();
            try {
                V v = this.removeLocked(key, hash, val, cleanupQ);
                return v;
            }
            finally {
                this.writeLock().unlock();
            }
        }

        V removeLocked(Object key, int hash, Object val, boolean cleanupQ) {
            HashEntry first;
            int c = this.cnt - 1;
            HashEntry<K, V>[] tab = this.tbl;
            int idx = hash & tab.length - 1;
            HashEntry e = first = tab[idx];
            while (!(e == null || e.hash == hash && key.equals(e.key))) {
                e = e.next;
            }
            Object oldVal = null;
            if (e != null) {
                Object v = e.val;
                if (val == null || val.equals(v)) {
                    oldVal = v;
                    ++this.modCnt;
                    ConcurrentLinkedHashMap.this.modCnt.increment();
                    HashEntry<Object, Object> newFirst = e.next;
                    HashEntry p = first;
                    while (p != e) {
                        newFirst = new HashEntry<Object, Object>(p.key, p.hash, newFirst, p.val, p.node, p.modCnt);
                        p = p.next;
                    }
                    tab[idx] = newFirst;
                    this.cnt = c;
                    ConcurrentLinkedHashMap.this.size.decrement();
                }
            }
            if (oldVal != null && cleanupQ) {
                switch (ConcurrentLinkedHashMap.this.qPlc) {
                    case PER_SEGMENT_Q_OPTIMIZED_RMV: {
                        ((ConcurrentLinkedDeque8)this.segEntryQ).unlinkx(e.node);
                        e.node = null;
                        break;
                    }
                    case PER_SEGMENT_Q: {
                        this.segEntryQ.remove(e);
                        break;
                    }
                    default: {
                        assert (ConcurrentLinkedHashMap.this.qPlc == QueuePolicy.SINGLE_Q);
                        ConcurrentLinkedHashMap.this.entryQ.unlinkx(e.node);
                        e.node = null;
                    }
                }
            }
            return (V)oldVal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            if (this.cnt != 0) {
                this.writeLock().lock();
                try {
                    HashEntry<K, V>[] tab = this.tbl;
                    for (int i = 0; i < tab.length; ++i) {
                        tab[i] = null;
                    }
                    ++this.modCnt;
                    this.cnt = 0;
                }
                finally {
                    this.writeLock().unlock();
                }
            }
        }
    }

    public static final class HashEntry<K, V> {
        private final K key;
        private final int hash;
        private volatile V val;
        @GridToStringExclude
        private volatile ConcurrentLinkedDeque8.Node node;
        private volatile int modCnt;
        @GridToStringExclude
        private final HashEntry<K, V> next;

        HashEntry(K key, int hash, HashEntry<K, V> next, V val) {
            this.key = key;
            this.hash = hash;
            this.next = next;
            this.val = val;
        }

        HashEntry(K key, int hash, HashEntry<K, V> next, V val, ConcurrentLinkedDeque8.Node node, int modCnt) {
            this.key = key;
            this.hash = hash;
            this.next = next;
            this.val = val;
            this.node = node;
            this.modCnt = modCnt;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.val;
        }

        static <K, V> HashEntry<K, V>[] newArray(int i) {
            return new HashEntry[i];
        }

        public String toString() {
            return S.toString(HashEntry.class, this, "key", this.key, "val", this.val);
        }

        static /* synthetic */ int access$802(HashEntry x0, int x1) {
            x0.modCnt = x1;
            return x0.modCnt;
        }
    }
}

