/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cache.query.index.AbstractIndex;
import org.apache.ignite.internal.cache.query.index.Index;
import org.apache.ignite.internal.cache.query.index.IndexDefinition;
import org.apache.ignite.internal.cache.query.index.IndexFactory;
import org.apache.ignite.internal.cache.query.index.IndexName;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRow;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRowCache;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRowCacheRegistry;
import org.apache.ignite.internal.cache.query.index.sorted.defragmentation.IndexingDefragmentation;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndex;
import org.apache.ignite.internal.cache.query.index.sorted.inline.JavaObjectKeySerializer;
import org.apache.ignite.internal.cache.query.index.sorted.inline.io.AbstractInlineInnerIO;
import org.apache.ignite.internal.cache.query.index.sorted.inline.io.AbstractInlineLeafIO;
import org.apache.ignite.internal.cache.query.index.sorted.inline.io.InnerIO;
import org.apache.ignite.internal.cache.query.index.sorted.inline.io.LeafIO;
import org.apache.ignite.internal.cache.query.index.sorted.inline.io.MvccInnerIO;
import org.apache.ignite.internal.cache.query.index.sorted.inline.io.MvccLeafIO;
import org.apache.ignite.internal.managers.indexing.IndexesRebuildTask;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheContextInfo;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.RootPage;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointTimeoutLock;
import org.apache.ignite.internal.processors.cache.persistence.defragmentation.LinkMap;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryEx;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseList;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.schema.IndexRebuildCancelToken;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitor;
import org.apache.ignite.internal.util.GridAtomicLong;
import org.apache.ignite.internal.util.collection.IntMap;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.thread.IgniteThreadPoolExecutor;
import org.jetbrains.annotations.Nullable;

public class IndexProcessor
extends GridProcessorAdapter {
    public static Class<? extends IndexesRebuildTask> idxRebuildCls;
    private final IndexesRebuildTask idxRebuild;
    public static JavaObjectKeySerializer serializer;
    private final IndexRowCacheRegistry idxRowCacheRegistry = new IndexRowCacheRegistry();
    private final Map<String, Map<String, Index>> cacheToIdx = new ConcurrentHashMap<String, Map<String, Index>>();
    private final Map<UUID, IndexDefinition> idxDefs = new ConcurrentHashMap<UUID, IndexDefinition>();
    private final ReentrantReadWriteLock ddlLock = new ReentrantReadWriteLock();

    public IndexProcessor(GridKernalContext ctx) throws IgniteCheckedException {
        super(ctx);
        if (idxRebuildCls != null) {
            this.idxRebuild = U.newInstance(idxRebuildCls);
            idxRebuildCls = null;
        } else {
            this.idxRebuild = new IndexesRebuildTask();
        }
        serializer = new JavaObjectKeySerializer(ctx.config());
    }

    public void store(GridCacheContext<?, ?> cctx, CacheDataRow newRow, @Nullable CacheDataRow prevRow, boolean prevRowAvailable) throws IgniteSpiException {
        try {
            this.updateIndexes(cctx.name(), newRow, prevRow, prevRowAvailable);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteSpiException("Failed to store row in cache", e);
        }
    }

    public void store(Collection<? extends Index> idxs, CacheDataRow newRow, @Nullable CacheDataRow prevRow, boolean prevRowAvailable) throws IgniteSpiException {
        IgniteCheckedException err = null;
        this.ddlLock.readLock().lock();
        try {
            for (Index index : idxs) {
                err = this.updateIndex(index, newRow, prevRow, prevRowAvailable, err);
            }
            if (err != null) {
                throw err;
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteSpiException("Failed to store row in index", e);
        }
        finally {
            this.ddlLock.readLock().unlock();
        }
    }

    public void remove(String cacheName, @Nullable CacheDataRow prevRow) throws IgniteSpiException {
        try {
            this.updateIndexes(cacheName, null, prevRow, true);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteSpiException("Failed to remove row in cache", e);
        }
    }

    public Index createIndexDynamically(GridCacheContext cctx, IndexFactory factory, IndexDefinition definition, SchemaIndexCacheVisitor cacheVisitor) {
        Index idx = this.createIndex(cctx, factory, definition);
        cacheVisitor.visit(row -> {
            if (idx.canHandle(row)) {
                idx.onUpdate(null, row, false);
            }
        });
        return idx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Index createIndex(GridCacheContext<?, ?> cctx, IndexFactory factory, IndexDefinition definition) {
        this.ddlLock.writeLock().lock();
        try {
            String cacheName = definition.idxName().cacheName();
            this.cacheToIdx.putIfAbsent(cacheName, new ConcurrentHashMap());
            String uniqIdxName = definition.idxName().fullName();
            assert (this.cacheToIdx.get(cacheName).get(uniqIdxName) == null) : "Duplicated index name " + uniqIdxName;
            Index idx = factory.createIndex(cctx, definition);
            this.cacheToIdx.get(cacheName).put(uniqIdxName, idx);
            this.idxDefs.put(idx.id(), definition);
            Index index = idx;
            return index;
        }
        finally {
            this.ddlLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIndex(GridCacheContext<?, ?> cctx, IndexName idxName, boolean softDelete) {
        this.ddlLock.writeLock().lock();
        try {
            String cacheName = idxName.cacheName();
            Map<String, Index> idxs = this.cacheToIdx.get(cacheName);
            assert (idxs != null) : "Try remove index for non registered cache " + cacheName;
            Index idx = idxs.remove(idxName.fullName());
            if (idx != null) {
                idx.destroy(softDelete);
                this.idxDefs.remove(idx.id());
            }
        }
        finally {
            this.ddlLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIndexes(String cacheName, CacheDataRow newRow, CacheDataRow prevRow, boolean prevRowAvailable) throws IgniteCheckedException {
        IgniteCheckedException err = null;
        this.ddlLock.readLock().lock();
        try {
            Map<String, Index> indexes = this.cacheToIdx.get(cacheName);
            if (F.isEmpty(indexes)) {
                return;
            }
            for (Index idx : indexes.values()) {
                err = this.updateIndex(idx, newRow, prevRow, prevRowAvailable, err);
            }
        }
        finally {
            this.ddlLock.readLock().unlock();
        }
        if (err != null) {
            throw err;
        }
    }

    public IndexRowCache rowCacheCleaner(int grpId) {
        return this.idxRowCacheRegistry.forGroup(grpId);
    }

    public IndexRowCacheRegistry idxRowCacheRegistry() {
        return this.idxRowCacheRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markRebuildIndexesForCache(GridCacheContext<?, ?> cctx, boolean val) {
        this.ddlLock.readLock().lock();
        try {
            if (!this.cacheToIdx.containsKey(cctx.name())) {
                return;
            }
            Collection<Index> idxs = this.cacheToIdx.get(cctx.name()).values();
            for (Index idx : idxs) {
                if (!(idx instanceof AbstractIndex)) continue;
                ((AbstractIndex)idx).markIndexRebuild(val);
            }
        }
        finally {
            this.ddlLock.readLock().unlock();
        }
    }

    @Nullable
    public IgniteInternalFuture<?> rebuildIndexesForCache(GridCacheContext<?, ?> cctx, boolean force, IndexRebuildCancelToken cancelTok) {
        return this.idxRebuild.rebuild(cctx, force, cancelTok);
    }

    public IndexesRebuildTask idxRebuild() {
        return this.idxRebuild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Index> indexes(GridCacheContext<?, ?> cctx) {
        this.ddlLock.readLock().lock();
        try {
            Map<String, Index> idxs = this.cacheToIdx.get(cctx.name());
            if (idxs == null) {
                List<Index> list = Collections.emptyList();
                return list;
            }
            Collection<Index> collection = idxs.values();
            return collection;
        }
        finally {
            this.ddlLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Index index(IndexName idxName) {
        this.ddlLock.readLock().lock();
        try {
            Map<String, Index> idxs = this.cacheToIdx.get(idxName.cacheName());
            if (idxs == null) {
                Index index = null;
                return index;
            }
            Index index = idxs.get(idxName.fullName());
            return index;
        }
        finally {
            this.ddlLock.readLock().unlock();
        }
    }

    public IndexDefinition indexDefinition(UUID idxId) {
        return this.idxDefs.get(idxId);
    }

    public void unregisterCache(GridCacheContextInfo cacheInfo) {
        this.idxRowCacheRegistry.onCacheUnregistered(cacheInfo);
        this.idxRebuild.stopRebuild(cacheInfo, this.log);
    }

    private IgniteCheckedException updateIndex(Index idx, CacheDataRow row, CacheDataRow prevRow, boolean prevRowAvailable, IgniteCheckedException prevErr) throws IgniteCheckedException {
        try {
            if (row != null && !idx.canHandle(row)) {
                return prevErr;
            }
            if (prevRow != null && !idx.canHandle(prevRow)) {
                return prevErr;
            }
            idx.onUpdate(prevRow, row, prevRowAvailable);
            return prevErr;
        }
        catch (Throwable t) {
            IgniteSQLException ex = X.cause(t, IgniteSQLException.class);
            if (ex != null && ex.statusCode() == 5006) {
                if (prevErr != null) {
                    prevErr.addSuppressed(t);
                    return prevErr;
                }
                return new IgniteCheckedException("Error on add row to index.", t);
            }
            throw t;
        }
    }

    public void destroyOrphanIndex(GridKernalContext ctx, RootPage page, String indexName, int grpId, PageMemory pageMemory, GridAtomicLong removeId, ReuseList reuseList, boolean mvccEnabled) throws IgniteCheckedException {
        assert (ctx.cache().context().database().checkpointLockIsHeldByThread());
        long metaPageId = page.pageId().pageId();
        int inlineSize = this.inlineSize(page, grpId, pageMemory);
        String grpName = ctx.cache().cacheGroup(grpId).cacheOrGroupName();
        BPlusTree<IndexRow, IndexRow> tree = new BPlusTree<IndexRow, IndexRow>(grpName + "IndexTree##" + indexName, grpId, grpName, pageMemory, ctx.cache().context().wal(), (AtomicLong)removeId, metaPageId, reuseList, AbstractInlineInnerIO.versions(inlineSize, mvccEnabled), AbstractInlineLeafIO.versions(inlineSize, mvccEnabled), 2, ctx.failure(), ctx.cache().context().diagnostic().pageLockTracker()){

            @Override
            protected int compare(BPlusIO io, long pageAddr, int idx, IndexRow row) {
                throw new AssertionError();
            }

            @Override
            public IndexRow getRow(BPlusIO io, long pageAddr, int idx, Object x) {
                throw new AssertionError();
            }
        };
        tree.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int inlineSize(RootPage page, int grpId, PageMemory pageMemory) throws IgniteCheckedException {
        long metaPageId = page.pageId().pageId();
        long metaPage = pageMemory.acquirePage(grpId, metaPageId);
        try {
            int n;
            long pageAddr = pageMemory.readLock(grpId, metaPageId, metaPage);
            assert (pageAddr != 0L) : "Failed to read lock meta page [metaPageId=" + U.hexLong(metaPageId) + ']';
            try {
                BPlusMetaIO io = BPlusMetaIO.VERSIONS.forPage(pageAddr);
                n = io.getInlineSize(pageAddr);
            }
            catch (Throwable throwable) {
                pageMemory.readUnlock(grpId, metaPageId, metaPage);
                throw throwable;
            }
            pageMemory.readUnlock(grpId, metaPageId, metaPage);
            return n;
        }
        finally {
            pageMemory.releasePage(grpId, metaPageId, metaPage);
        }
    }

    public void defragment(CacheGroupContext grpCtx, CacheGroupContext newCtx, PageMemoryEx partPageMem, IntMap<LinkMap> mappingByPart, CheckpointTimeoutLock cpLock, Runnable cancellationChecker, IgniteThreadPoolExecutor defragmentationThreadPool) throws IgniteCheckedException {
        new IndexingDefragmentation(this).defragment(grpCtx, newCtx, partPageMem, mappingByPart, cpLock, cancellationChecker, defragmentationThreadPool, this.log);
    }

    public List<InlineIndex> treeIndexes(GridCacheContext cctx, boolean createdOnly) {
        Collection<Index> idxs = this.indexes(cctx);
        ArrayList<InlineIndex> treeIdxs = new ArrayList<InlineIndex>();
        for (Index idx : idxs) {
            if (!(idx instanceof InlineIndex)) continue;
            InlineIndex idx0 = (InlineIndex)idx;
            if (createdOnly && !idx0.created()) continue;
            treeIdxs.add(idx0);
        }
        return treeIdxs;
    }

    public IgniteLogger logger() {
        return this.log;
    }

    static {
        PageIO.registerH2(InnerIO.VERSIONS, LeafIO.VERSIONS, MvccInnerIO.VERSIONS, MvccLeafIO.VERSIONS);
        AbstractInlineInnerIO.register();
        AbstractInlineLeafIO.register();
    }
}

