/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.marshaller.optimized;

import java.io.Externalizable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.internal.binary.GridBinaryMarshaller;
import org.apache.ignite.internal.marshaller.optimized.OptimizedFieldType;
import org.apache.ignite.internal.marshaller.optimized.OptimizedMarshallerIdMapper;
import org.apache.ignite.internal.marshaller.optimized.OptimizedMarshallerUtils;
import org.apache.ignite.internal.marshaller.optimized.OptimizedObjectInputStream;
import org.apache.ignite.internal.marshaller.optimized.OptimizedObjectOutputStream;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.SerializableTransient;
import org.apache.ignite.internal.util.TransientSerializable;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.marshaller.MarshallerContext;
import org.apache.ignite.marshaller.MarshallerExclusions;
import org.apache.ignite.marshaller.MarshallerUtils;

class OptimizedClassDescriptor {
    private final Class<?> cls;
    private final MarshallerContext ctx;
    private ConcurrentMap<Class, OptimizedClassDescriptor> clsMap;
    private final OptimizedMarshallerIdMapper mapper;
    private final String name;
    private final int typeId;
    private final short checksum;
    private int type;
    private boolean isPrimitive;
    private boolean isEnum;
    private boolean isSerial;
    private boolean excluded;
    private boolean isCls;
    private Object[] enumVals;
    private Constructor<?> constructor;
    private Fields fields;
    private List<Method> writeObjMtds;
    private Method writeReplaceMtd;
    private List<Method> readObjMtds;
    private Method readResolveMtd;
    private long dfltsFieldOff;
    private long loadFactorFieldOff;
    private long accessOrderFieldOff;
    private Class<?>[] proxyIntfs;
    private Method serTransMtd;
    private Method transSerMtd;

    OptimizedClassDescriptor(Class<?> cls, int typeId, ConcurrentMap<Class, OptimizedClassDescriptor> clsMap, MarshallerContext ctx, OptimizedMarshallerIdMapper mapper) throws IOException {
        this(cls, typeId, clsMap, ctx, mapper, MarshallerExclusions.isExcluded(cls));
    }

    OptimizedClassDescriptor(Class<?> cls, int typeId, ConcurrentMap<Class, OptimizedClassDescriptor> clsMap, MarshallerContext ctx, OptimizedMarshallerIdMapper mapper, boolean excluded) throws IOException {
        this.cls = cls;
        this.typeId = typeId;
        this.clsMap = clsMap;
        this.ctx = ctx;
        this.mapper = mapper;
        this.name = cls.getName();
        this.excluded = excluded;
        if (!excluded) {
            if (cls == Byte.TYPE || cls == Byte.class) {
                this.type = 1;
                this.isPrimitive = true;
            } else if (cls == Short.TYPE || cls == Short.class) {
                this.type = 2;
                this.isPrimitive = true;
            } else if (cls == Integer.TYPE || cls == Integer.class) {
                this.type = 3;
                this.isPrimitive = true;
            } else if (cls == Long.TYPE || cls == Long.class) {
                this.type = 4;
                this.isPrimitive = true;
            } else if (cls == Float.TYPE || cls == Float.class) {
                this.type = 5;
                this.isPrimitive = true;
            } else if (cls == Double.TYPE || cls == Double.class) {
                this.type = 6;
                this.isPrimitive = true;
            } else if (cls == Character.TYPE || cls == Character.class) {
                this.type = 7;
                this.isPrimitive = true;
            } else if (cls == Boolean.TYPE || cls == Boolean.class) {
                this.type = 8;
                this.isPrimitive = true;
            } else if (cls == byte[].class) {
                this.type = 9;
            } else if (cls == short[].class) {
                this.type = 10;
            } else if (cls == int[].class) {
                this.type = 11;
            } else if (cls == long[].class) {
                this.type = 12;
            } else if (cls == float[].class) {
                this.type = 13;
            } else if (cls == double[].class) {
                this.type = 14;
            } else if (cls == char[].class) {
                this.type = 15;
            } else if (cls == boolean[].class) {
                this.type = 16;
            } else if (cls.isArray()) {
                this.type = 17;
            } else if (cls == String.class) {
                this.type = 18;
            } else if (cls.isEnum()) {
                this.type = 100;
                this.isEnum = true;
                this.enumVals = cls.getEnumConstants();
            } else {
                Class<?> parent = cls.getSuperclass();
                if (parent != null && parent.isEnum()) {
                    this.type = 100;
                    this.isEnum = true;
                    this.enumVals = parent.getEnumConstants();
                } else if (cls == UUID.class) {
                    this.type = 19;
                } else {
                    if (cls == Properties.class) {
                        this.type = 20;
                        try {
                            this.dfltsFieldOff = GridUnsafe.objectFieldOffset(Properties.class.getDeclaredField("defaults"));
                        }
                        catch (NoSuchFieldException e) {
                            throw new IOException(e);
                        }
                    }
                    if (cls == ArrayList.class) {
                        this.type = 21;
                    } else {
                        if (cls == HashMap.class) {
                            this.type = 22;
                            try {
                                this.loadFactorFieldOff = GridUnsafe.objectFieldOffset(HashMap.class.getDeclaredField("loadFactor"));
                            }
                            catch (NoSuchFieldException e) {
                                throw new IOException(e);
                            }
                        }
                        if (cls == HashSet.class) {
                            this.type = 23;
                            try {
                                this.loadFactorFieldOff = GridUnsafe.objectFieldOffset(HashMap.class.getDeclaredField("loadFactor"));
                            }
                            catch (NoSuchFieldException e) {
                                throw new IOException(e);
                            }
                        }
                        if (cls == LinkedList.class) {
                            this.type = 24;
                        } else {
                            if (cls == LinkedHashMap.class) {
                                this.type = 25;
                                try {
                                    this.loadFactorFieldOff = GridUnsafe.objectFieldOffset(HashMap.class.getDeclaredField("loadFactor"));
                                    this.accessOrderFieldOff = GridUnsafe.objectFieldOffset(LinkedHashMap.class.getDeclaredField("accessOrder"));
                                }
                                catch (NoSuchFieldException e) {
                                    throw new IOException(e);
                                }
                            }
                            if (cls == LinkedHashSet.class) {
                                this.type = 26;
                                try {
                                    this.loadFactorFieldOff = GridUnsafe.objectFieldOffset(HashMap.class.getDeclaredField("loadFactor"));
                                }
                                catch (NoSuchFieldException e) {
                                    throw new IOException(e);
                                }
                            }
                            if (cls == Date.class) {
                                this.type = 27;
                            } else if (cls == Class.class) {
                                this.type = 28;
                                this.isCls = true;
                            } else if (Proxy.class.isAssignableFrom(cls)) {
                                this.type = 29;
                                this.proxyIntfs = cls.getInterfaces();
                            } else {
                                Class<?> c;
                                for (c = cls; !(this.writeReplaceMtd != null && this.readResolveMtd != null || c == null || c.equals(Object.class)); c = c.getSuperclass()) {
                                    if (this.writeReplaceMtd == null) {
                                        try {
                                            this.writeReplaceMtd = c.getDeclaredMethod("writeReplace", new Class[0]);
                                            if (!(Modifier.isStatic(this.writeReplaceMtd.getModifiers()) || Modifier.isPrivate(this.writeReplaceMtd.getModifiers()) && c != cls || !this.writeReplaceMtd.getReturnType().equals(Object.class))) {
                                                this.writeReplaceMtd.setAccessible(true);
                                            } else {
                                                this.writeReplaceMtd = null;
                                            }
                                        }
                                        catch (NoSuchMethodException noSuchMethodException) {
                                            // empty catch block
                                        }
                                    }
                                    if (this.readResolveMtd != null) continue;
                                    try {
                                        this.readResolveMtd = c.getDeclaredMethod("readResolve", new Class[0]);
                                        if (!(Modifier.isStatic(this.readResolveMtd.getModifiers()) || Modifier.isPrivate(this.readResolveMtd.getModifiers()) && c != cls || !this.readResolveMtd.getReturnType().equals(Object.class))) {
                                            this.readResolveMtd.setAccessible(true);
                                            continue;
                                        }
                                        this.readResolveMtd = null;
                                        continue;
                                    }
                                    catch (NoSuchMethodException noSuchMethodException) {
                                        // empty catch block
                                    }
                                }
                                if (Externalizable.class.isAssignableFrom(cls)) {
                                    this.type = 101;
                                    try {
                                        this.constructor = !Modifier.isStatic(cls.getModifiers()) && cls.getDeclaringClass() != null ? cls.getDeclaredConstructor(cls.getDeclaringClass()) : cls.getDeclaredConstructor(new Class[0]);
                                        this.constructor.setAccessible(true);
                                    }
                                    catch (NoSuchMethodException e) {
                                        throw new IOException("Externalizable class doesn't have default constructor: " + cls, e);
                                    }
                                }
                                this.type = 102;
                                this.isSerial = Serializable.class.isAssignableFrom(cls);
                                this.writeObjMtds = new ArrayList<Method>();
                                this.readObjMtds = new ArrayList<Method>();
                                ArrayList<ClassFields> fields = new ArrayList<ClassFields>();
                                for (c = cls; c != null && !c.equals(Object.class); c = c.getSuperclass()) {
                                    int mod;
                                    int mod2;
                                    Method mtd;
                                    try {
                                        mtd = c.getDeclaredMethod("writeObject", ObjectOutputStream.class);
                                        mod2 = mtd.getModifiers();
                                        if (!Modifier.isStatic(mod2) && Modifier.isPrivate(mod2) && mtd.getReturnType() == Void.TYPE) {
                                            mtd.setAccessible(true);
                                        } else {
                                            mtd = null;
                                        }
                                    }
                                    catch (NoSuchMethodException ignored) {
                                        mtd = null;
                                    }
                                    this.writeObjMtds.add(mtd);
                                    try {
                                        mtd = c.getDeclaredMethod("readObject", ObjectInputStream.class);
                                        mod2 = mtd.getModifiers();
                                        if (!Modifier.isStatic(mod2) && Modifier.isPrivate(mod2) && mtd.getReturnType() == Void.TYPE) {
                                            mtd.setAccessible(true);
                                        } else {
                                            mtd = null;
                                        }
                                    }
                                    catch (NoSuchMethodException ignored) {
                                        mtd = null;
                                    }
                                    this.readObjMtds.add(mtd);
                                    SerializableTransient serTransAn = c.getAnnotation(SerializableTransient.class);
                                    TransientSerializable transSerAn = c.getAnnotation(TransientSerializable.class);
                                    if (serTransAn != null) {
                                        try {
                                            this.serTransMtd = c.getDeclaredMethod(serTransAn.methodName(), IgniteProductVersion.class);
                                            mod = this.serTransMtd.getModifiers();
                                            if (Modifier.isStatic(mod) && Modifier.isPrivate(mod) && this.serTransMtd.getReturnType() == String[].class) {
                                                this.serTransMtd.setAccessible(true);
                                            } else {
                                                this.serTransMtd = null;
                                            }
                                        }
                                        catch (NoSuchMethodException ignored) {
                                            this.serTransMtd = null;
                                        }
                                    }
                                    if (transSerAn != null) {
                                        try {
                                            this.transSerMtd = c.getDeclaredMethod(transSerAn.methodName(), IgniteProductVersion.class);
                                            mod = this.transSerMtd.getModifiers();
                                            if (Modifier.isStatic(mod) && Modifier.isPrivate(mod) && this.transSerMtd.getReturnType() == String[].class) {
                                                this.transSerMtd.setAccessible(true);
                                            } else {
                                                this.transSerMtd = null;
                                            }
                                        }
                                        catch (NoSuchMethodException ignored) {
                                            this.transSerMtd = null;
                                        }
                                    }
                                    Field[] clsFields0 = c.getDeclaredFields();
                                    HashMap<String, Field> fieldNames = new HashMap<String, Field>();
                                    for (Field f : clsFields0) {
                                        fieldNames.put(f.getName(), f);
                                    }
                                    ArrayList<FieldInfo> clsFields = new ArrayList<FieldInfo>(clsFields0.length);
                                    boolean hasSerialPersistentFields = false;
                                    try {
                                        Field serFieldsDesc = c.getDeclaredField("serialPersistentFields");
                                        int mod3 = serFieldsDesc.getModifiers();
                                        if (serFieldsDesc.getType() == ObjectStreamField[].class && Modifier.isPrivate(mod3) && Modifier.isStatic(mod3) && Modifier.isFinal(mod3)) {
                                            hasSerialPersistentFields = true;
                                            serFieldsDesc.setAccessible(true);
                                            ObjectStreamField[] serFields = (ObjectStreamField[])serFieldsDesc.get(null);
                                            for (int i = 0; i < serFields.length; ++i) {
                                                FieldInfo fieldInfo;
                                                ObjectStreamField serField = serFields[i];
                                                if (!fieldNames.containsKey(serField.getName())) {
                                                    fieldInfo = new FieldInfo(null, serField.getName(), -1L, this.fieldType(serField.getType()));
                                                } else {
                                                    Field f = (Field)fieldNames.get(serField.getName());
                                                    fieldInfo = new FieldInfo(f, serField.getName(), GridUnsafe.objectFieldOffset(f), this.fieldType(serField.getType()));
                                                }
                                                clsFields.add(fieldInfo);
                                            }
                                        }
                                    }
                                    catch (NoSuchFieldException serFieldsDesc) {
                                    }
                                    catch (IllegalAccessException e) {
                                        throw new IOException("Failed to get value of 'serialPersistentFields' field in class: " + cls.getName(), e);
                                    }
                                    if (!hasSerialPersistentFields) {
                                        for (int i = 0; i < clsFields0.length; ++i) {
                                            Field f = clsFields0[i];
                                            int mod4 = f.getModifiers();
                                            if (Modifier.isStatic(mod4) || Modifier.isTransient(mod4)) continue;
                                            FieldInfo fieldInfo = new FieldInfo(f, f.getName(), GridUnsafe.objectFieldOffset(f), this.fieldType(f.getType()));
                                            clsFields.add(fieldInfo);
                                        }
                                    }
                                    Collections.sort(clsFields, new Comparator<FieldInfo>(){

                                        @Override
                                        public int compare(FieldInfo t1, FieldInfo t2) {
                                            return t1.name().compareTo(t2.name());
                                        }
                                    });
                                    fields.add(new ClassFields(clsFields));
                                }
                                Collections.reverse(this.writeObjMtds);
                                Collections.reverse(this.readObjMtds);
                                Collections.reverse(fields);
                                this.fields = new Fields(fields);
                            }
                        }
                    }
                }
            }
        }
        this.checksum = OptimizedMarshallerUtils.computeSerialVersionUid(cls, this.fields != null ? this.fields.ownFields() : null);
    }

    boolean excluded() {
        return this.excluded;
    }

    Class<?> describedClass() {
        return this.cls;
    }

    boolean isPrimitive() {
        return this.isPrimitive;
    }

    boolean isEnum() {
        return this.isEnum;
    }

    boolean isClass() {
        return this.isCls;
    }

    boolean isProxy() {
        return this.type == 29;
    }

    Object replace(Object obj) throws IOException {
        if (this.writeReplaceMtd != null) {
            try {
                return this.writeReplaceMtd.invoke(obj, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IOException(e);
            }
        }
        return obj;
    }

    void write(OptimizedObjectOutputStream out, Object obj) throws IOException {
        out.write(this.type);
        switch (this.type) {
            case 1: {
                out.writeByte(((Byte)obj).byteValue());
                break;
            }
            case 2: {
                out.writeShort(((Short)obj).shortValue());
                break;
            }
            case 3: {
                out.writeInt((Integer)obj);
                break;
            }
            case 4: {
                out.writeLong((Long)obj);
                break;
            }
            case 5: {
                out.writeFloat(((Float)obj).floatValue());
                break;
            }
            case 6: {
                out.writeDouble((Double)obj);
                break;
            }
            case 7: {
                out.writeChar(((Character)obj).charValue());
                break;
            }
            case 8: {
                out.writeBoolean((Boolean)obj);
                break;
            }
            case 9: {
                out.writeByteArray((byte[])obj);
                break;
            }
            case 10: {
                out.writeShortArray((short[])obj);
                break;
            }
            case 11: {
                out.writeIntArray((int[])obj);
                break;
            }
            case 12: {
                out.writeLongArray((long[])obj);
                break;
            }
            case 13: {
                out.writeFloatArray((float[])obj);
                break;
            }
            case 14: {
                out.writeDoubleArray((double[])obj);
                break;
            }
            case 15: {
                out.writeCharArray((char[])obj);
                break;
            }
            case 16: {
                out.writeBooleanArray((boolean[])obj);
                break;
            }
            case 17: {
                OptimizedClassDescriptor compDesc = OptimizedMarshallerUtils.classDescriptor(this.clsMap, obj.getClass().getComponentType(), GridBinaryMarshaller.USE_CACHE.get(), this.ctx, this.mapper);
                compDesc.writeTypeData(out);
                out.writeArray((Object[])obj);
                break;
            }
            case 18: {
                out.writeString((String)obj);
                break;
            }
            case 19: {
                out.writeUuid((UUID)obj);
                break;
            }
            case 20: {
                out.writeProperties((Properties)obj, this.dfltsFieldOff);
                break;
            }
            case 21: {
                out.writeArrayList((ArrayList)obj);
                break;
            }
            case 22: {
                out.writeHashMap((HashMap)obj, this.loadFactorFieldOff, false);
                break;
            }
            case 23: {
                out.writeHashSet((HashSet)obj, OptimizedMarshallerUtils.HASH_SET_MAP_OFF, this.loadFactorFieldOff);
                break;
            }
            case 24: {
                out.writeLinkedList((LinkedList)obj);
                break;
            }
            case 25: {
                out.writeLinkedHashMap((LinkedHashMap)obj, this.loadFactorFieldOff, this.accessOrderFieldOff, false);
                break;
            }
            case 26: {
                out.writeLinkedHashSet((LinkedHashSet)obj, OptimizedMarshallerUtils.HASH_SET_MAP_OFF, this.loadFactorFieldOff);
                break;
            }
            case 27: {
                out.writeDate((Date)obj);
                break;
            }
            case 28: {
                OptimizedClassDescriptor clsDesc = OptimizedMarshallerUtils.classDescriptor(this.clsMap, (Class)obj, GridBinaryMarshaller.USE_CACHE.get(), this.ctx, this.mapper);
                clsDesc.writeTypeData(out);
                break;
            }
            case 29: {
                out.writeInt(this.proxyIntfs.length);
                for (Class<?> intf : this.proxyIntfs) {
                    OptimizedClassDescriptor intfDesc = OptimizedMarshallerUtils.classDescriptor(this.clsMap, intf, GridBinaryMarshaller.USE_CACHE.get(), this.ctx, this.mapper);
                    intfDesc.writeTypeData(out);
                }
                InvocationHandler ih = Proxy.getInvocationHandler(obj);
                assert (ih != null);
                out.writeObject(ih);
                break;
            }
            case 100: {
                this.writeTypeData(out);
                out.writeInt(((Enum)obj).ordinal());
                break;
            }
            case 101: {
                this.writeTypeData(out);
                out.writeShort(this.checksum);
                out.writeExternalizable(obj);
                break;
            }
            case 102: {
                if (out.requireSerializable() && !this.isSerial) {
                    throw new NotSerializableException("Must implement java.io.Serializable or set OptimizedMarshaller.setRequireSerializable() to false (note that performance may degrade if object is not Serializable): " + this.name);
                }
                this.writeTypeData(out);
                out.writeShort(this.checksum);
                out.writeSerializable(obj, this.writeObjMtds, this.fields(obj.getClass(), MarshallerUtils.jobReceiverVersion()));
                break;
            }
            default: {
                throw new IllegalStateException("Invalid class type: " + this.type);
            }
        }
    }

    private Fields fields(Class<?> cls, IgniteProductVersion ver) {
        if (ver == null || this.serTransMtd == null && this.transSerMtd == null) {
            return this.fields;
        }
        try {
            String[] serFields;
            String[] transFields = this.serTransMtd == null ? null : (String[])this.serTransMtd.invoke(null, ver);
            String[] stringArray = serFields = this.transSerMtd == null ? null : (String[])this.transSerMtd.invoke(null, ver);
            if (F.isEmpty(transFields) && F.isEmpty(serFields)) {
                return this.fields;
            }
            TreeMap<String, FieldInfo> clsFields = new TreeMap<String, FieldInfo>();
            for (FieldInfo field : ((ClassFields)this.fields.fields.get(0)).fields) {
                clsFields.put(field.fieldName, field);
            }
            if (!F.isEmpty(transFields)) {
                for (int i = 0; i < transFields.length; ++i) {
                    String fieldName = transFields[i];
                    Field f = cls.getDeclaredField(fieldName);
                    FieldInfo fieldInfo = new FieldInfo(f, f.getName(), GridUnsafe.objectFieldOffset(f), this.fieldType(f.getType()));
                    clsFields.put(fieldName, fieldInfo);
                }
            }
            if (!F.isEmpty(serFields)) {
                for (int i = 0; i < serFields.length; ++i) {
                    clsFields.remove(serFields[i]);
                }
            }
            ArrayList<ClassFields> fields = new ArrayList<ClassFields>(1);
            fields.add(new ClassFields(new ArrayList<FieldInfo>(clsFields.values())));
            return new Fields(fields);
        }
        catch (Exception ignored) {
            return this.fields;
        }
    }

    void writeTypeData(OptimizedObjectOutputStream out) throws IOException {
        out.writeInt(this.typeId);
        if (this.typeId == 0) {
            out.writeUTF(this.name);
        }
    }

    Object read(OptimizedObjectInputStream in) throws ClassNotFoundException, IOException {
        switch (this.type) {
            case 100: {
                return this.enumVals[in.readInt()];
            }
            case 101: {
                this.verifyChecksum(in.readShort());
                return in.readExternalizable(this.constructor, this.readResolveMtd);
            }
            case 102: {
                this.verifyChecksum(in.readShort());
                return in.readSerializable(this.cls, this.readObjMtds, this.readResolveMtd, this.fields(this.cls, MarshallerUtils.jobSenderVersion()));
            }
        }
        assert (false) : "Unexpected type: " + this.type;
        return null;
    }

    private void verifyChecksum(short checksum) throws ClassNotFoundException, IOException {
        if (checksum != this.checksum) {
            throw new ClassNotFoundException("Optimized stream class checksum mismatch (is same version of marshalled class present on all nodes?) [expected=" + this.checksum + ", actual=" + checksum + ", cls=" + this.cls + ']');
        }
    }

    private OptimizedFieldType fieldType(Class<?> cls) {
        OptimizedFieldType type = cls == Byte.TYPE ? OptimizedFieldType.BYTE : (cls == Short.TYPE ? OptimizedFieldType.SHORT : (cls == Integer.TYPE ? OptimizedFieldType.INT : (cls == Long.TYPE ? OptimizedFieldType.LONG : (cls == Float.TYPE ? OptimizedFieldType.FLOAT : (cls == Double.TYPE ? OptimizedFieldType.DOUBLE : (cls == Character.TYPE ? OptimizedFieldType.CHAR : (cls == Boolean.TYPE ? OptimizedFieldType.BOOLEAN : OptimizedFieldType.OTHER)))))));
        return type;
    }

    static class Fields {
        private final List<ClassFields> fields;
        private final List<Field> ownFields;

        Fields(List<ClassFields> fields) {
            this.fields = fields;
            if (fields.isEmpty()) {
                this.ownFields = null;
            } else {
                this.ownFields = new ArrayList<Field>(fields.size());
                for (FieldInfo f : fields.get(fields.size() - 1).fields()) {
                    if (f.field() == null) continue;
                    this.ownFields.add(f.field);
                }
            }
        }

        List<Field> ownFields() {
            return this.ownFields;
        }

        ClassFields fields(int i) {
            return this.fields.get(i);
        }
    }

    static class ClassFields {
        private final List<FieldInfo> fields;
        private final Map<String, Integer> nameToIndex;

        ClassFields(List<FieldInfo> fields) {
            this.fields = fields;
            this.nameToIndex = U.newHashMap(fields.size());
            for (int i = 0; i < fields.size(); ++i) {
                this.nameToIndex.put(fields.get(i).name(), i);
            }
        }

        List<FieldInfo> fields() {
            return this.fields;
        }

        int size() {
            return this.fields.size();
        }

        FieldInfo get(int i) {
            return this.fields.get(i);
        }

        int getIndex(String name) {
            assert (this.nameToIndex.containsKey(name));
            return this.nameToIndex.get(name);
        }
    }

    static class FieldInfo {
        private final Field field;
        private final long fieldOffs;
        private final OptimizedFieldType fieldType;
        private final String fieldName;

        FieldInfo(Field field, String name, long offset, OptimizedFieldType type) {
            this.field = field;
            this.fieldOffs = offset;
            this.fieldType = type;
            this.fieldName = name;
        }

        Field field() {
            return this.field;
        }

        long offset() {
            return this.fieldOffs;
        }

        OptimizedFieldType type() {
            return this.fieldType;
        }

        String name() {
            return this.fieldName;
        }
    }
}

