/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheIdMessage;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridNearTxQueryEnlistRequest
extends GridCacheIdMessage {
    private static final long serialVersionUID = 0L;
    private long threadId;
    private IgniteUuid futId;
    private boolean clientFirst;
    private int miniId;
    private AffinityTopologyVersion topVer;
    private GridCacheVersion lockVer;
    private MvccSnapshot mvccSnapshot;
    private int[] cacheIds;
    private int[] parts;
    private String schema;
    private String qry;
    @GridDirectTransient
    private Object[] params;
    private byte[] paramsBytes;
    private int flags;
    private long timeout;
    private long txTimeout;
    private int taskNameHash;
    private int pageSize;

    public GridNearTxQueryEnlistRequest() {
    }

    public GridNearTxQueryEnlistRequest(int cacheId, long threadId, IgniteUuid futId, int miniId, AffinityTopologyVersion topVer, GridCacheVersion lockVer, MvccSnapshot mvccSnapshot, int[] cacheIds, int[] parts, String schema, String qry, Object[] params, int flags, int pageSize, long timeout, long txTimeout, int taskNameHash, boolean clientFirst) {
        this.cacheIds = cacheIds;
        this.parts = parts;
        this.schema = schema;
        this.qry = qry;
        this.params = params;
        this.flags = flags;
        this.pageSize = pageSize;
        this.txTimeout = txTimeout;
        this.cacheId = cacheId;
        this.threadId = threadId;
        this.futId = futId;
        this.miniId = miniId;
        this.topVer = topVer;
        this.lockVer = lockVer;
        this.mvccSnapshot = mvccSnapshot;
        this.timeout = timeout;
        this.taskNameHash = taskNameHash;
        this.clientFirst = clientFirst;
    }

    public long threadId() {
        return this.threadId;
    }

    public IgniteUuid futureId() {
        return this.futId;
    }

    public int miniId() {
        return this.miniId;
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public GridCacheVersion version() {
        return this.lockVer;
    }

    public MvccSnapshot mvccSnapshot() {
        return this.mvccSnapshot;
    }

    public int[] cacheIds() {
        return this.cacheIds;
    }

    public int[] partitions() {
        return this.parts;
    }

    public String schemaName() {
        return this.schema;
    }

    public String query() {
        return this.qry;
    }

    public Object[] parameters() {
        return this.params;
    }

    public int flags() {
        return this.flags;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public long timeout() {
        return this.timeout;
    }

    public long txTimeout() {
        return this.txTimeout;
    }

    public int taskNameHash() {
        return this.taskNameHash;
    }

    public boolean firstClientRequest() {
        return this.clientFirst;
    }

    @Override
    public boolean addDeploymentInfo() {
        return false;
    }

    @Override
    public byte fieldsCount() {
        return 21;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        if (this.params != null && this.paramsBytes == null) {
            this.paramsBytes = U.marshal(ctx, (Object)this.params);
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        if (this.paramsBytes != null && this.params == null) {
            this.params = (Object[])U.unmarshal(ctx, this.paramsBytes, ldr);
        }
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 4: {
                if (!writer.writeIntArray("cacheIds", this.cacheIds)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeBoolean("clientFirst", this.clientFirst)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeInt("flags", this.flags)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeIgniteUuid("futId", this.futId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeMessage("lockVer", this.lockVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeInt("miniId", this.miniId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                if (!writer.writeMessage("mvccSnapshot", this.mvccSnapshot)) {
                    return false;
                }
                writer.incrementState();
            }
            case 11: {
                if (!writer.writeInt("pageSize", this.pageSize)) {
                    return false;
                }
                writer.incrementState();
            }
            case 12: {
                if (!writer.writeByteArray("paramsBytes", this.paramsBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 13: {
                if (!writer.writeIntArray("parts", this.parts)) {
                    return false;
                }
                writer.incrementState();
            }
            case 14: {
                if (!writer.writeString("qry", this.qry)) {
                    return false;
                }
                writer.incrementState();
            }
            case 15: {
                if (!writer.writeString("schema", this.schema)) {
                    return false;
                }
                writer.incrementState();
            }
            case 16: {
                if (!writer.writeInt("taskNameHash", this.taskNameHash)) {
                    return false;
                }
                writer.incrementState();
            }
            case 17: {
                if (!writer.writeLong("threadId", this.threadId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 18: {
                if (!writer.writeLong("timeout", this.timeout)) {
                    return false;
                }
                writer.incrementState();
            }
            case 19: {
                if (!writer.writeAffinityTopologyVersion("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 20: {
                if (!writer.writeLong("txTimeout", this.txTimeout)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 4: {
                this.cacheIds = reader.readIntArray("cacheIds");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.clientFirst = reader.readBoolean("clientFirst");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.flags = reader.readInt("flags");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.futId = reader.readIgniteUuid("futId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.lockVer = (GridCacheVersion)reader.readMessage("lockVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.miniId = reader.readInt("miniId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 10: {
                this.mvccSnapshot = (MvccSnapshot)reader.readMessage("mvccSnapshot");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 11: {
                this.pageSize = reader.readInt("pageSize");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 12: {
                this.paramsBytes = reader.readByteArray("paramsBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 13: {
                this.parts = reader.readIntArray("parts");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 14: {
                this.qry = reader.readString("qry");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 15: {
                this.schema = reader.readString("schema");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 16: {
                this.taskNameHash = reader.readInt("taskNameHash");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 17: {
                this.threadId = reader.readLong("threadId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 18: {
                this.timeout = reader.readLong("timeout");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 19: {
                this.topVer = reader.readAffinityTopologyVersion("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 20: {
                this.txTimeout = reader.readLong("txTimeout");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridNearTxQueryEnlistRequest.class);
    }

    @Override
    public short directType() {
        return 151;
    }

    @Override
    public String toString() {
        return S.toString(GridNearTxQueryEnlistRequest.class, this);
    }
}

