/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near.consistency;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheEntryVersion;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.EntryGetResult;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridPartitionedGetFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.consistency.GridNearReadRepairAbstractFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.consistency.IgniteConsistencyViolationException;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.lang.GridClosureException;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;

public class GridNearReadRepairCheckOnlyFuture
extends GridNearReadRepairAbstractFuture {
    private final boolean skipVals;
    private final boolean needVer;
    private final boolean keepCacheObjects;

    public GridNearReadRepairCheckOnlyFuture(GridCacheContext ctx, Collection<KeyCacheObject> keys, boolean readThrough, String taskName, boolean deserializeBinary, boolean recovery, IgniteCacheExpiryPolicy expiryPlc, boolean skipVals, boolean needVer, boolean keepCacheObjects, IgniteInternalTx tx) {
        super(null, ctx, keys, readThrough, taskName, deserializeBinary, recovery, expiryPlc, tx);
        this.skipVals = skipVals;
        this.needVer = needVer;
        this.keepCacheObjects = keepCacheObjects;
    }

    @Override
    protected void reduce() {
        HashMap<KeyCacheObject, EntryGetResult> resMap = new HashMap<KeyCacheObject, EntryGetResult>();
        HashMap<KeyCacheObject, T2<Object, GridCacheVersion>> prevMap = new HashMap<KeyCacheObject, T2<Object, GridCacheVersion>>();
        HashSet<KeyCacheObject> inconsistentKeys = new HashSet<KeyCacheObject>();
        for (GridPartitionedGetFuture fut : this.futs.values()) {
            for (Map.Entry entry : ((Map)fut.result()).entrySet()) {
                KeyCacheObject curKey = (KeyCacheObject)entry.getKey();
                EntryGetResult curRes = (EntryGetResult)entry.getValue();
                Object curVal = this.ctx.unwrapBinaryIfNeeded(curRes.value(), !this.deserializeBinary, false, null);
                T2 prev = (T2)prevMap.get(curKey);
                if (prev != null) {
                    Object prevVal = prev.get1();
                    CacheEntryVersion prevVer = (CacheEntryVersion)prev.get2();
                    if (prevVer.compareTo(curRes.version()) == 0 && prevVal.equals(curVal)) continue;
                    inconsistentKeys.add(curKey);
                    continue;
                }
                resMap.put(curKey, curRes);
                prevMap.put(curKey, new T2<Object, GridCacheVersion>(curVal, curRes.version()));
            }
        }
        if (!inconsistentKeys.isEmpty()) {
            if (REMAP_CNT_UPD.incrementAndGet(this) > MAX_REMAP_CNT) {
                if (!this.ctx.transactional()) {
                    this.recordConsistencyViolation(inconsistentKeys, null);
                }
                this.onDone(new IgniteConsistencyViolationException("Distributed cache consistency violation detected."));
            } else {
                this.remap(this.ctx.affinity().affinityTopologyVersion());
            }
            return;
        }
        this.onDone(resMap);
    }

    public <K, V> IgniteInternalFuture<V> single() {
        return this.chain(fut -> {
            try {
                IgniteBiTuple map = new IgniteBiTuple();
                for (Map.Entry entry : ((Map)fut.get()).entrySet()) {
                    EntryGetResult getRes = (EntryGetResult)entry.getValue();
                    this.ctx.addResult(map, (KeyCacheObject)entry.getKey(), (CacheObject)getRes.value(), this.skipVals, this.keepCacheObjects, this.deserializeBinary, false, getRes, getRes.version(), 0L, 0L, this.needVer, null);
                }
                if (this.skipVals) {
                    Boolean val = map.isEmpty() ? false : (Boolean)F.firstValue(map);
                    return val;
                }
                return F.firstValue(map);
            }
            catch (IgniteCheckedException e) {
                throw new GridClosureException(e);
            }
        });
    }

    public <K, V> IgniteInternalFuture<Map<K, V>> multi() {
        return this.chain(fut -> {
            try {
                HashMap map = U.newHashMap(this.keys.size());
                for (Map.Entry entry : ((Map)fut.get()).entrySet()) {
                    EntryGetResult getRes = (EntryGetResult)entry.getValue();
                    this.ctx.addResult(map, (KeyCacheObject)entry.getKey(), (CacheObject)getRes.value(), this.skipVals, this.keepCacheObjects, this.deserializeBinary, false, getRes, getRes.version(), 0L, 0L, this.needVer, null);
                }
                return map;
            }
            catch (Exception e) {
                throw new GridClosureException(e);
            }
        });
    }
}

