/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.defragmentation;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageLockTrackerManager;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusInnerIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusLeafIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.IOVersions;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;

public class LinkMap {
    public static final int META_PAGE_IDX = 2;
    public static final IOVersions<? extends BPlusLeafIO<LinkMapping>> LEAF_IO_VERSIONS = new IOVersions((PageIO[])new LinkMappingLeafIO[]{new LinkMappingLeafIO()});
    public static final IOVersions<? extends BPlusInnerIO<LinkMapping>> INNER_IO_VERSIONS = new IOVersions((PageIO[])new LinkMappingInnerIO[]{new LinkMappingInnerIO()});
    private final LinkTree tree;

    public LinkMap(CacheGroupContext ctx, PageMemory pageMem, long metaPageId, boolean initNew) throws IgniteCheckedException {
        this(ctx.groupId(), ctx.name(), pageMem, metaPageId, initNew, ctx.shared().diagnostic().pageLockTracker());
    }

    public LinkMap(int grpId, String grpName, PageMemory pageMem, long metaPageId, boolean initNew, PageLockTrackerManager pageLockTrackerManager) throws IgniteCheckedException {
        this.tree = new LinkTree(grpId, grpName, pageMem, metaPageId, pageLockTrackerManager, initNew);
    }

    public void put(long oldLink, long newLink) throws IgniteCheckedException {
        this.tree.put(new LinkMapping(oldLink, newLink));
    }

    public long get(long oldLink) throws IgniteCheckedException {
        LinkMapping get = new LinkMapping(oldLink, 0L);
        LinkMapping found = (LinkMapping)this.tree.findOne(get);
        return found.getNewLink();
    }

    public void close() {
        this.tree.close();
    }

    private static class LinkMappingLeafIO
    extends BPlusLeafIO<LinkMapping> {
        LinkMappingLeafIO() {
            super(35, 1, 16);
        }

        @Override
        public void storeByOffset(long pageAddr, int off, LinkMapping row) {
            PageUtils.putLong(pageAddr, off, row.getOldLink());
            PageUtils.putLong(pageAddr, off + 8, row.getNewLink());
        }

        @Override
        public void store(long dst, int dstIdx, BPlusIO<LinkMapping> srcIo, long src, int srcIdx) throws IgniteCheckedException {
            assert (srcIo == this);
            this.storeByOffset(dst, this.offset(dstIdx), srcIo.getLookupRow(null, src, srcIdx));
        }

        @Override
        public LinkMapping getLookupRow(BPlusTree<LinkMapping, ?> tree, long pageAddr, int idx) {
            long oldLink = PageUtils.getLong(pageAddr, this.offset(idx));
            long newLink = PageUtils.getLong(pageAddr, this.offset(idx) + 8);
            return new LinkMapping(oldLink, newLink);
        }
    }

    private static class LinkMappingInnerIO
    extends BPlusInnerIO<LinkMapping> {
        LinkMappingInnerIO() {
            super(34, 1, true, 16);
        }

        @Override
        public void storeByOffset(long pageAddr, int off, LinkMapping row) {
            PageUtils.putLong(pageAddr, off, row.getOldLink());
            PageUtils.putLong(pageAddr, off + 8, row.getNewLink());
        }

        @Override
        public void store(long dst, int dstIdx, BPlusIO<LinkMapping> srcIo, long src, int srcIdx) throws IgniteCheckedException {
            assert (srcIo == this);
            this.storeByOffset(dst, this.offset(dstIdx), srcIo.getLookupRow(null, src, srcIdx));
        }

        @Override
        public LinkMapping getLookupRow(BPlusTree<LinkMapping, ?> tree, long pageAddr, int idx) {
            long oldLink = PageUtils.getLong(pageAddr, this.offset(idx));
            long newLink = PageUtils.getLong(pageAddr, this.offset(idx) + 8);
            return new LinkMapping(oldLink, newLink);
        }
    }

    private static class LinkMapping {
        private final long oldLink;
        private final long newLink;

        LinkMapping(long oldLink, long newLink) {
            this.oldLink = oldLink;
            this.newLink = newLink;
        }

        public long getOldLink() {
            return this.oldLink;
        }

        public long getNewLink() {
            return this.newLink;
        }
    }

    private static class LinkTree
    extends BPlusTree<LinkMapping, LinkMapping> {
        LinkTree(int cacheGrpId, String cacheGrpName, PageMemory pageMem, long metaPageId, PageLockTrackerManager pageLockTrackerManager, boolean initNew) throws IgniteCheckedException {
            super("link-map", cacheGrpId, cacheGrpName, pageMem, null, new AtomicLong(), metaPageId, null, INNER_IO_VERSIONS, LEAF_IO_VERSIONS, (byte)4, null, pageLockTrackerManager);
            PageIO.registerTest(this.latestInnerIO(), this.latestLeafIO());
            this.initTree(initNew);
        }

        @Override
        protected int compare(BPlusIO<LinkMapping> io, long pageAddr, int idx, LinkMapping row) throws IgniteCheckedException {
            LinkMapping lookupRow = io.getLookupRow(this, pageAddr, idx);
            return Long.compare(lookupRow.getOldLink(), row.getOldLink());
        }

        @Override
        public LinkMapping getRow(BPlusIO<LinkMapping> io, long pageAddr, int idx, Object x) throws IgniteCheckedException {
            return io.getLookupRow(this, pageAddr, idx);
        }

        @Override
        protected long allocatePageNoReuse() throws IgniteCheckedException {
            return this.pageMem.allocatePage(this.grpId, PageIdUtils.partId(this.metaPageId), (byte)1);
        }
    }
}

