/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.AbstractSnapshotFutureTask;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteSnapshotManager;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotMetadata;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotSender;
import org.apache.ignite.internal.util.typedef.F;
import org.jetbrains.annotations.Nullable;

public class SnapshotResponseRemoteFutureTask
extends AbstractSnapshotFutureTask<Void> {
    public SnapshotResponseRemoteFutureTask(GridCacheSharedContext<?, ?> cctx, UUID srcNodeId, String snpName, File tmpWorkDir, FileIOFactory ioFactory, SnapshotSender snpSndr, Map<Integer, Set<Integer>> parts) {
        super(cctx, srcNodeId, snpName, tmpWorkDir, ioFactory, snpSndr, parts);
    }

    @Override
    public boolean start() {
        if (F.isEmpty(this.parts)) {
            return false;
        }
        try {
            ArrayList<GroupPartitionId> handled = new ArrayList<GroupPartitionId>();
            for (Map.Entry e : this.parts.entrySet()) {
                Optional.ofNullable(e.getValue()).orElse(Collections.emptySet()).forEach(p -> handled.add(new GroupPartitionId((Integer)e.getKey(), (int)p)));
            }
            this.snpSndr.init(handled.size());
            File snpDir = this.cctx.snapshotMgr().snapshotLocalDir(this.snpName);
            ArrayList futs = new ArrayList();
            List<SnapshotMetadata> metas = this.cctx.snapshotMgr().readSnapshotMetadatas(this.snpName);
            for (SnapshotMetadata meta : metas) {
                Map<Integer, Set<Integer>> parts0 = meta.partitions();
                if (F.isEmpty(parts0)) continue;
                handled.removeIf(gp -> {
                    if (Optional.ofNullable(parts0.get(gp.getGroupId())).orElse(Collections.emptySet()).contains(gp.getPartitionId())) {
                        futs.add(CompletableFuture.runAsync(() -> {
                            if (this.err.get() != null) {
                                return;
                            }
                            File cacheDir = FilePageStoreManager.cacheDirectory(new File(snpDir, IgniteSnapshotManager.databaseRelativePath(meta.folderName())), gp.getGroupId());
                            if (cacheDir == null) {
                                throw new IgniteException("Cache directory not found [snpName=" + this.snpName + ", meta=" + meta + ", pair=" + gp + ']');
                            }
                            File snpPart = FilePageStoreManager.getPartitionFile(cacheDir.getParentFile(), cacheDir.getName(), gp.getPartitionId());
                            if (!snpPart.exists()) {
                                throw new IgniteException("Snapshot partition file not found [cacheDir=" + cacheDir + ", pair=" + gp + ']');
                            }
                            this.snpSndr.sendPart(snpPart, cacheDir.getName(), (GroupPartitionId)gp, snpPart.length());
                        }, this.snpSndr.executor()).whenComplete((r, t) -> this.err.compareAndSet(null, t)));
                        return true;
                    }
                    return false;
                });
            }
            if (!handled.isEmpty()) {
                this.err.compareAndSet(null, new IgniteException("Snapshot partitions missed on local node [snpName=" + this.snpName + ", missed=" + handled + ']'));
            }
            int size = futs.size();
            CompletableFuture.allOf(futs.toArray(new CompletableFuture[size])).whenComplete((r, t) -> {
                Throwable th = Optional.ofNullable(this.err.get()).orElse(t);
                if (th == null && this.log.isInfoEnabled()) {
                    this.log.info("Snapshot partitions have been sent to the remote node [snpName=" + this.snpName + ", rmtNodeId=" + this.srcNodeId + ']');
                }
                this.close(th);
            });
            return true;
        }
        catch (Throwable t2) {
            if (this.err.compareAndSet(null, t2)) {
                this.close(t2);
            }
            return false;
        }
    }

    @Override
    public void acceptException(Throwable th) {
        if (this.err.compareAndSet(null, th)) {
            this.close(th);
        }
    }

    private void close(@Nullable Throwable th) {
        if (th == null) {
            this.snpSndr.close(null);
            this.onDone((Void)null);
        } else {
            this.snpSndr.close(th);
            this.onDone(th);
        }
    }
}

