/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.tree;

import java.util.Arrays;
import org.apache.ignite.internal.processors.cache.persistence.AbstractCorruptedPersistenceException;
import org.apache.ignite.internal.util.GridStringBuilder;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.jetbrains.annotations.Nullable;

public class CorruptedTreeException
extends AbstractCorruptedPersistenceException {
    private static final long serialVersionUID = 0L;

    public CorruptedTreeException(String msg, @Nullable Throwable cause, int grpId, String grpName, long ... pageIds) {
        this(msg, null, null, grpName, cause, CorruptedTreeException.toPagesArray(grpId, pageIds));
    }

    public CorruptedTreeException(String msg, @Nullable Throwable cause, int grpId, String grpName, String cacheName, String indexName, long ... pageIds) {
        this(msg, cacheName, indexName, grpName, cause, CorruptedTreeException.toPagesArray(grpId, pageIds));
    }

    public CorruptedTreeException(String msg, String cacheName, String indexName, String grpName, @Nullable Throwable cause, T2<Integer, Long> ... pages) {
        super(CorruptedTreeException.getMsg(msg, cacheName, indexName, grpName, pages), cause, pages);
    }

    private static String getMsg(String msg, String cacheName, String indexName, String grpName, T2<Integer, Long> ... pages) {
        GridStringBuilder stringBuilder = new GridStringBuilder("B+Tree is corrupted [").a("pages(groupId, pageId)=").a(Arrays.toString(pages));
        if (cacheName != null) {
            stringBuilder.a(", cacheId=").a(CU.cacheId(cacheName)).a(", cacheName=").a(cacheName);
        }
        if (indexName != null) {
            stringBuilder.a(", indexName=").a(indexName);
        }
        if (grpName != null) {
            stringBuilder.a(", groupName=").a(grpName);
        }
        stringBuilder.a(", msg=").a(msg).a("]");
        return stringBuilder.toString();
    }
}

