/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.tree.mvcc.data;

import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.persistence.CacheSearchRow;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.IOVersions;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.tree.AbstractDataInnerIO;
import org.apache.ignite.internal.processors.cache.tree.mvcc.data.MvccDataRow;
import org.apache.ignite.lang.IgniteInClosure;

public final class MvccDataInnerIO
extends AbstractDataInnerIO {
    public static final IOVersions<MvccDataInnerIO> VERSIONS = new IOVersions((PageIO[])new MvccDataInnerIO[]{new MvccDataInnerIO(1)});

    private MvccDataInnerIO(int ver) {
        super(24, ver, true, 32);
    }

    @Override
    public void visit(long pageAddr, IgniteInClosure<CacheSearchRow> c) {
        int cnt = this.getCount(pageAddr);
        for (int i = 0; i < cnt; ++i) {
            c.apply(new MvccDataRow(this.getLink(pageAddr, i)));
        }
    }

    @Override
    protected boolean storeMvccVersion() {
        return true;
    }

    @Override
    public long getMvccCoordinatorVersion(long pageAddr, int idx) {
        return PageUtils.getLong(pageAddr, this.offset(idx) + 12);
    }

    @Override
    public long getMvccCounter(long pageAddr, int idx) {
        return PageUtils.getLong(pageAddr, this.offset(idx) + 20);
    }

    @Override
    public int getMvccOperationCounter(long pageAddr, int idx) {
        return PageUtils.getInt(pageAddr, this.offset(idx) + 28);
    }
}

