/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc;

import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.metric.GridMetricManager;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.IntMetricImpl;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;

public class ClientListenerMetrics {
    public static final String METRIC_REJECTED_TIMEOUT = "RejectedSessionsTimeout";
    public static final String METRIC_REJECTED_AUTHENTICATION = "RejectedSessionsAuthenticationFailed";
    public static final String METRIC_REJECTED_TOTAL = "RejectedSessionsTotal";
    public static final String METRIC_ACEPTED = "AcceptedSessions";
    public static final String METRIC_ACTIVE = "ActiveSessions";
    private final IntMetricImpl rejectedTimeout;
    private final IntMetricImpl rejectedAuth;
    private final IntMetricImpl rejectedTotal;
    private final IntMetricImpl[] accepted;
    private final IntMetricImpl[] active;

    public ClientListenerMetrics(GridKernalContext ctx) {
        MetricRegistry mreg = ctx.metric().registry(GridMetricManager.CLIENT_CONNECTOR_METRICS);
        this.rejectedTimeout = mreg.intMetric(METRIC_REJECTED_TIMEOUT, "TCP sessions count that were rejected due to handshake timeout.");
        this.rejectedAuth = mreg.intMetric(METRIC_REJECTED_AUTHENTICATION, "TCP sessions count that were rejected due to failed authentication.");
        this.rejectedTotal = mreg.intMetric(METRIC_REJECTED_TOTAL, "Total number of rejected TCP connections.");
        byte[] supportedClients = new byte[]{0, 1, 2};
        this.accepted = new IntMetricImpl[supportedClients.length];
        this.active = new IntMetricImpl[supportedClients.length];
        for (byte clientType : supportedClients) {
            String clientLabel = this.clientTypeLabel(clientType);
            String labelAccepted = MetricUtils.metricName(clientLabel, METRIC_ACEPTED);
            this.accepted[clientType] = mreg.intMetric(labelAccepted, "Number of successfully established sessions for the client type.");
            String labelActive = MetricUtils.metricName(clientLabel, METRIC_ACTIVE);
            this.active[clientType] = mreg.intMetric(labelActive, "Number of active sessions for the client type.");
        }
    }

    public void onHandshakeTimeout() {
        this.rejectedTimeout.increment();
        this.rejectedTotal.increment();
    }

    public void onFailedAuth() {
        this.rejectedAuth.increment();
        this.rejectedTotal.increment();
    }

    public void onGeneralReject() {
        this.rejectedTotal.increment();
    }

    public void onHandshakeAccept(byte clientType) {
        this.accepted[clientType].increment();
        this.active[clientType].increment();
    }

    public void onDisconnect(byte clientType) {
        this.active[clientType].add(-1);
    }

    private String clientTypeLabel(byte clientType) {
        switch (clientType) {
            case 0: {
                return "odbc";
            }
            case 1: {
                return "jdbc";
            }
            case 2: {
                return "thin";
            }
        }
        return "unknown";
    }
}

