/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ignite.compute;

import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.ignite.AbstractIgniteEndpoint;
import org.apache.camel.component.ignite.ClusterGroupExpression;
import org.apache.camel.component.ignite.compute.IgniteComputeComponent;
import org.apache.camel.component.ignite.compute.IgniteComputeExecutionType;
import org.apache.camel.component.ignite.compute.IgniteComputeProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCompute;

@UriEndpoint(firstVersion="2.17.0", scheme="ignite-compute", title="Ignite Compute", syntax="ignite-compute:endpointId", category={Category.COMPUTE}, producerOnly=true)
public class IgniteComputeEndpoint
extends AbstractIgniteEndpoint {
    @UriPath
    @Metadata(required=true)
    private String endpointId;
    @UriParam(label="producer")
    private ClusterGroupExpression clusterGroupExpression;
    @UriParam(label="producer")
    @Metadata(required=true)
    private IgniteComputeExecutionType executionType;
    @UriParam(label="producer")
    private String taskName;
    @UriParam(label="producer")
    private String computeName;
    @UriParam(label="producer")
    private Long timeoutMillis;

    public IgniteComputeEndpoint(String uri, String remaining, Map<String, Object> parameters, IgniteComputeComponent igniteComponent) throws ClassNotFoundException {
        super(uri, igniteComponent);
    }

    @Override
    public Producer createProducer() throws Exception {
        return new IgniteComputeProducer(this);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("The Ignite Compute endpoint does not support consumers.");
    }

    public IgniteCompute createIgniteCompute() {
        IgniteCompute compute;
        Ignite ignite = this.ignite();
        IgniteCompute igniteCompute = compute = this.clusterGroupExpression == null ? ignite.compute() : ignite.compute(this.clusterGroupExpression.getClusterGroup(ignite));
        if (this.computeName != null) {
            compute = compute.withName(this.computeName);
        }
        if (this.timeoutMillis != null) {
            compute = compute.withTimeout(this.timeoutMillis);
        }
        return compute;
    }

    public String getEndpointId() {
        return this.endpointId;
    }

    public void setEndpointId(String endpointId) {
        this.endpointId = endpointId;
    }

    public ClusterGroupExpression getClusterGroupExpression() {
        return this.clusterGroupExpression;
    }

    public void setClusterGroupExpression(ClusterGroupExpression clusterGroupExpression) {
        this.clusterGroupExpression = clusterGroupExpression;
    }

    public IgniteComputeExecutionType getExecutionType() {
        return this.executionType;
    }

    public void setExecutionType(IgniteComputeExecutionType executionType) {
        this.executionType = executionType;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getComputeName() {
        return this.computeName;
    }

    public void setComputeName(String computeName) {
        this.computeName = computeName;
    }

    public Long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public void setTimeoutMillis(Long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }
}

