/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ignite.messaging;

import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.ignite.AbstractIgniteEndpoint;
import org.apache.camel.component.ignite.ClusterGroupExpression;
import org.apache.camel.component.ignite.messaging.IgniteMessagingComponent;
import org.apache.camel.component.ignite.messaging.IgniteMessagingConsumer;
import org.apache.camel.component.ignite.messaging.IgniteMessagingProducer;
import org.apache.camel.component.ignite.messaging.IgniteMessagingSendMode;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteMessaging;

@UriEndpoint(firstVersion="2.17.0", scheme="ignite-messaging", title="Ignite Messaging", syntax="ignite-messaging:topic", category={Category.MESSAGING})
public class IgniteMessagingEndpoint
extends AbstractIgniteEndpoint {
    @UriPath
    @Metadata(required=true)
    private String topic;
    @UriParam(label="consumer,producer")
    private ClusterGroupExpression clusterGroupExpression;
    @UriParam(label="producer", defaultValue="UNORDERED")
    private IgniteMessagingSendMode sendMode = IgniteMessagingSendMode.UNORDERED;
    @UriParam(label="producer")
    private Long timeout;

    public IgniteMessagingEndpoint(String endpointUri, String remaining, Map<String, Object> parameters, IgniteMessagingComponent igniteComponent) {
        super(endpointUri, igniteComponent);
        this.topic = remaining;
    }

    @Override
    public Producer createProducer() throws Exception {
        if (this.topic == null) {
            throw new IllegalStateException("Cannot initialize an Ignite Messaging Producer with a null topic.");
        }
        if (this.sendMode == IgniteMessagingSendMode.ORDERED && this.timeout == null) {
            throw new IllegalStateException("Cannot initialize an Ignite Messaging Producer in ORDERED send mode without a timeout.");
        }
        IgniteMessaging messaging = this.createIgniteMessaging();
        return new IgniteMessagingProducer(this, this.igniteComponent().getIgnite(), messaging);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        if (this.topic == null) {
            throw new IllegalStateException("Cannot initialize an Ignite Messaging Consumer with a null topic.");
        }
        IgniteMessaging messaging = this.createIgniteMessaging();
        IgniteMessagingConsumer consumer = new IgniteMessagingConsumer(this, processor, messaging);
        this.configureConsumer(consumer);
        return consumer;
    }

    private IgniteMessaging createIgniteMessaging() {
        Ignite ignite = this.ignite();
        IgniteMessaging messaging = this.clusterGroupExpression == null ? ignite.message() : ignite.message(this.clusterGroupExpression.getClusterGroup(ignite));
        return messaging;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public ClusterGroupExpression getClusterGroupExpression() {
        return this.clusterGroupExpression;
    }

    public void setClusterGroupExpression(ClusterGroupExpression clusterGroupExpression) {
        this.clusterGroupExpression = clusterGroupExpression;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public IgniteMessagingSendMode getSendMode() {
        return this.sendMode;
    }

    public void setSendMode(IgniteMessagingSendMode sendMode) {
        this.sendMode = sendMode;
    }
}

