/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.cache.configuration.Factory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.client.ClientAuthenticationException;
import org.apache.ignite.client.ClientAuthorizationException;
import org.apache.ignite.client.ClientConnectionException;
import org.apache.ignite.client.ClientException;
import org.apache.ignite.client.SslMode;
import org.apache.ignite.client.SslProtocol;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.binary.BinaryCachingMetadataHandler;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinaryPrimitives;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.binary.streams.BinaryHeapInputStream;
import org.apache.ignite.internal.binary.streams.BinaryHeapOutputStream;
import org.apache.ignite.internal.binary.streams.BinaryOutputStream;
import org.apache.ignite.internal.client.thin.ClientChannel;
import org.apache.ignite.internal.client.thin.ClientChannelConfiguration;
import org.apache.ignite.internal.client.thin.ClientError;
import org.apache.ignite.internal.client.thin.ClientOperation;
import org.apache.ignite.internal.client.thin.ClientProtocolError;
import org.apache.ignite.internal.client.thin.ClientServerError;
import org.apache.ignite.internal.client.thin.ClientUtils;
import org.apache.ignite.internal.client.thin.NotificationListener;
import org.apache.ignite.internal.client.thin.PayloadInputChannel;
import org.apache.ignite.internal.client.thin.PayloadOutputChannel;
import org.apache.ignite.internal.client.thin.ProtocolBitmaskFeature;
import org.apache.ignite.internal.client.thin.ProtocolContext;
import org.apache.ignite.internal.client.thin.ProtocolVersion;
import org.apache.ignite.internal.client.thin.ProtocolVersionFeature;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

class TcpClientChannel
implements ClientChannel {
    private static final ProtocolVersion DEFAULT_VERSION = ProtocolVersion.LATEST_VER;
    static final String RECEIVER_THREAD_PREFIX = "thin-client-channel#";
    private static final Collection<ProtocolVersion> supportedVers = Arrays.asList(ProtocolVersion.V1_7_0, ProtocolVersion.V1_6_0, ProtocolVersion.V1_5_0, ProtocolVersion.V1_4_0, ProtocolVersion.V1_3_0, ProtocolVersion.V1_2_0, ProtocolVersion.V1_1_0, ProtocolVersion.V1_0_0);
    private ProtocolContext protocolCtx;
    private UUID srvNodeId;
    private AffinityTopologyVersion srvTopVer;
    private final Socket sock;
    private final OutputStream out;
    private final ByteCountingDataInput dataInput;
    private final AtomicLong reqId = new AtomicLong(1L);
    private final Lock sndLock = new ReentrantLock();
    private final Map<Long, ClientRequestFuture> pendingReqs = new ConcurrentHashMap<Long, ClientRequestFuture>();
    private final Collection<Consumer<ClientChannel>> topChangeLsnrs = new CopyOnWriteArrayList<Consumer<ClientChannel>>();
    private final Collection<NotificationListener> notificationLsnrs = new CopyOnWriteArrayList<NotificationListener>();
    private final AtomicBoolean closed = new AtomicBoolean();
    private Thread receiverThread;
    private final int timeout;

    TcpClientChannel(ClientChannelConfiguration cfg) throws ClientConnectionException, ClientAuthenticationException, ClientProtocolError {
        TcpClientChannel.validateConfiguration(cfg);
        this.timeout = cfg.getTimeout();
        try {
            this.sock = TcpClientChannel.createSocket(cfg);
            this.out = this.sock.getOutputStream();
            this.dataInput = new ByteCountingDataInput(this.sock.getInputStream());
            this.handshake(DEFAULT_VERSION, cfg.getUserName(), cfg.getUserPassword(), cfg.getUserAttributes());
            if (this.timeout > 0) {
                this.sock.setSoTimeout(0);
            }
        }
        catch (IOException e) {
            throw this.handleIOError("addr=" + cfg.getAddress(), e);
        }
    }

    @Override
    public void close() {
        this.close(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(Throwable cause) {
        if (this.closed.compareAndSet(false, true)) {
            U.closeQuiet(this.dataInput);
            U.closeQuiet(this.out);
            U.closeQuiet(this.sock);
            this.sndLock.lock();
            try {
                for (ClientRequestFuture pendingReq : this.pendingReqs.values()) {
                    pendingReq.onDone(new ClientConnectionException("Channel is closed", cause));
                }
                if (this.receiverThread != null) {
                    this.receiverThread.interrupt();
                }
            }
            finally {
                this.sndLock.unlock();
            }
        }
    }

    @Override
    public <T> T service(ClientOperation op, Consumer<PayloadOutputChannel> payloadWriter, Function<PayloadInputChannel, T> payloadReader) throws ClientConnectionException, ClientAuthorizationException, ClientServerError, ClientException {
        long id = this.send(op, payloadWriter);
        return this.receive(id, payloadReader);
    }

    private long send(ClientOperation op, Consumer<PayloadOutputChannel> payloadWriter) throws ClientException, ClientConnectionException {
        long id = this.reqId.getAndIncrement();
        this.sndLock.lock();
        try (PayloadOutputChannel payloadCh = new PayloadOutputChannel(this);){
            if (this.closed()) {
                throw new ClientConnectionException("Channel is closed");
            }
            this.initReceiverThread();
            this.pendingReqs.put(id, new ClientRequestFuture());
            BinaryOutputStream req = payloadCh.out();
            req.writeInt(0);
            req.writeShort(op.code());
            req.writeLong(id);
            if (payloadWriter != null) {
                payloadWriter.accept(payloadCh);
            }
            req.writeInt(0, req.position() - 4);
            this.write(req.array(), req.position());
        }
        catch (Throwable t) {
            this.pendingReqs.remove(id);
            throw t;
        }
        finally {
            this.sndLock.unlock();
        }
        return id;
    }

    private <T> T receive(long reqId, Function<PayloadInputChannel, T> payloadReader) throws ClientServerError, ClientException, ClientConnectionException, ClientAuthorizationException {
        ClientRequestFuture pendingReq = this.pendingReqs.get(reqId);
        assert (pendingReq != null) : "Pending request future not found for request " + reqId;
        try {
            byte[] payload;
            byte[] byArray = payload = this.timeout > 0 ? (byte[])pendingReq.get(this.timeout) : (byte[])pendingReq.get();
            if (payload == null || payloadReader == null) {
                T t = null;
                return t;
            }
            T t = payloadReader.apply(new PayloadInputChannel(this, payload));
            return t;
        }
        catch (IgniteCheckedException e) {
            if (e.getCause() instanceof ClientError) {
                throw (ClientError)e.getCause();
            }
            if (e.getCause() instanceof ClientException) {
                throw (ClientException)e.getCause();
            }
            throw new ClientException(e.getMessage(), e);
        }
        finally {
            this.pendingReqs.remove(reqId);
        }
    }

    private void initReceiverThread() {
        if (this.receiverThread == null) {
            Socket sock = this.sock;
            String sockInfo = sock == null ? null : sock.getInetAddress().getHostName() + ":" + sock.getPort();
            this.receiverThread = new Thread(() -> {
                try {
                    while (!this.closed()) {
                        this.processNextMessage();
                    }
                }
                catch (Throwable e) {
                    this.close(e);
                }
            }, RECEIVER_THREAD_PREFIX + sockInfo);
            this.receiverThread.setDaemon(true);
            this.receiverThread.start();
        }
    }

    private void processNextMessage() throws ClientProtocolError, ClientConnectionException {
        int msgSize = this.dataInput.readInt();
        if (msgSize <= 0) {
            throw new ClientProtocolError(String.format("Invalid message size: %s", msgSize));
        }
        long bytesReadOnStartMsg = this.dataInput.totalBytesRead();
        long resId = this.dataInput.readLong();
        int status = 0;
        ClientOperation notificationOp = null;
        if (this.protocolCtx.isFeatureSupported(ProtocolVersionFeature.PARTITION_AWARENESS)) {
            short notificationCode;
            short flags = this.dataInput.readShort();
            if ((flags & 2) != 0) {
                long topVer = this.dataInput.readLong();
                int minorTopVer = this.dataInput.readInt();
                this.srvTopVer = new AffinityTopologyVersion(topVer, minorTopVer);
                for (Consumer<ClientChannel> lsnr : this.topChangeLsnrs) {
                    lsnr.accept(this);
                }
            }
            if (!((flags & 4) == 0 || (notificationOp = ClientOperation.fromCode(notificationCode = this.dataInput.readShort())) != null && notificationOp.isNotification())) {
                throw new ClientProtocolError(String.format("Unexpected notification code [%d]", notificationCode));
            }
            if ((flags & 1) != 0) {
                status = this.dataInput.readInt();
            }
        } else {
            status = this.dataInput.readInt();
        }
        int hdrSize = (int)(this.dataInput.totalBytesRead() - bytesReadOnStartMsg);
        byte[] res = null;
        RuntimeException err = null;
        if (status == 0) {
            if (msgSize > hdrSize) {
                res = this.dataInput.read(msgSize - hdrSize);
            }
        } else if (status == 1012) {
            err = new ClientAuthorizationException();
        } else {
            BinaryHeapInputStream resIn = new BinaryHeapInputStream(this.dataInput.read(msgSize - hdrSize));
            String errMsg = ClientUtils.createBinaryReader(null, resIn).readString();
            err = new ClientServerError(errMsg, status, resId);
        }
        if (notificationOp == null) {
            ClientRequestFuture pendingReq = this.pendingReqs.get(resId);
            if (pendingReq == null) {
                throw new ClientProtocolError(String.format("Unexpected response ID [%s]", resId));
            }
            pendingReq.onDone(res, err);
        } else {
            for (NotificationListener lsnr : this.notificationLsnrs) {
                lsnr.acceptNotification(this, notificationOp, resId, res, err);
            }
        }
    }

    @Override
    public ProtocolContext protocolCtx() {
        return this.protocolCtx;
    }

    @Override
    public UUID serverNodeId() {
        return this.srvNodeId;
    }

    @Override
    public AffinityTopologyVersion serverTopologyVersion() {
        return this.srvTopVer;
    }

    @Override
    public void addTopologyChangeListener(Consumer<ClientChannel> lsnr) {
        this.topChangeLsnrs.add(lsnr);
    }

    @Override
    public void addNotificationListener(NotificationListener lsnr) {
        this.notificationLsnrs.add(lsnr);
    }

    @Override
    public boolean closed() {
        return this.closed.get();
    }

    private static void validateConfiguration(ClientChannelConfiguration cfg) {
        String error = null;
        InetSocketAddress addr = cfg.getAddress();
        if (addr == null) {
            error = "At least one Ignite server node must be specified in the Ignite client configuration";
        } else if (addr.getPort() < 1024 || addr.getPort() > 49151) {
            error = String.format("Ignite client port %s is out of valid ports range 1024...49151", addr.getPort());
        }
        if (error != null) {
            throw new IllegalArgumentException(error);
        }
    }

    private static Socket createSocket(ClientChannelConfiguration cfg) throws IOException {
        Socket sock = cfg.getSslMode() == SslMode.REQUIRED ? new ClientSslSocketFactory(cfg).create() : new Socket(cfg.getAddress().getHostName(), cfg.getAddress().getPort());
        sock.setTcpNoDelay(cfg.isTcpNoDelay());
        if (cfg.getTimeout() > 0) {
            sock.setSoTimeout(cfg.getTimeout());
        }
        if (cfg.getSendBufferSize() > 0) {
            sock.setSendBufferSize(cfg.getSendBufferSize());
        }
        if (cfg.getReceiveBufferSize() > 0) {
            sock.setReceiveBufferSize(cfg.getReceiveBufferSize());
        }
        return sock;
    }

    private void handshake(ProtocolVersion ver, String user, String pwd, Map<String, String> userAttrs) throws ClientConnectionException, ClientAuthenticationException, ClientProtocolError {
        this.handshakeReq(ver, user, pwd, userAttrs);
        this.handshakeRes(ver, user, pwd, userAttrs);
    }

    private void handshakeReq(ProtocolVersion proposedVer, String user, String pwd, Map<String, String> userAttrs) throws ClientConnectionException {
        BinaryContext ctx = new BinaryContext(BinaryCachingMetadataHandler.create(), new IgniteConfiguration(), null);
        try (BinaryWriterExImpl writer = new BinaryWriterExImpl(ctx, new BinaryHeapOutputStream(32), null, null);){
            boolean authSupported;
            ProtocolContext protocolCtx = this.protocolContextFromVersion(proposedVer);
            writer.writeInt(0);
            writer.writeByte((byte)1);
            writer.writeShort(proposedVer.major());
            writer.writeShort(proposedVer.minor());
            writer.writeShort(proposedVer.patch());
            writer.writeByte((byte)2);
            if (protocolCtx.isFeatureSupported(ProtocolVersionFeature.BITMAP_FEATURES)) {
                byte[] features = ProtocolBitmaskFeature.featuresAsBytes(protocolCtx.features());
                writer.writeByteArray(features);
            }
            if (protocolCtx.isFeatureSupported(ProtocolBitmaskFeature.USER_ATTRIBUTES)) {
                writer.writeMap(userAttrs);
            }
            if ((authSupported = protocolCtx.isFeatureSupported(ProtocolVersionFeature.AUTHORIZATION)) && user != null && !user.isEmpty()) {
                writer.writeString(user);
                writer.writeString(pwd);
            }
            writer.out().writeInt(0, writer.out().position() - 4);
            this.write(writer.array(), writer.out().position());
        }
    }

    private ProtocolContext protocolContextFromVersion(ProtocolVersion ver) {
        EnumSet<ProtocolBitmaskFeature> features = null;
        if (ProtocolContext.isFeatureSupported(ver, ProtocolVersionFeature.BITMAP_FEATURES)) {
            features = ProtocolBitmaskFeature.allFeaturesAsEnumSet();
        }
        return new ProtocolContext(ver, features);
    }

    private void handshakeRes(ProtocolVersion proposedVer, String user, String pwd, Map<String, String> userAttrs) throws ClientConnectionException, ClientAuthenticationException, ClientProtocolError {
        int resSize = this.dataInput.readInt();
        if (resSize <= 0) {
            throw new ClientProtocolError(String.format("Invalid handshake response size: %s", resSize));
        }
        BinaryHeapInputStream res = new BinaryHeapInputStream(this.dataInput.read(resSize));
        try (BinaryReaderExImpl reader = ClientUtils.createBinaryReader(null, res);){
            boolean success = res.readBoolean();
            if (success) {
                byte[] features = new byte[]{};
                if (ProtocolContext.isFeatureSupported(proposedVer, ProtocolVersionFeature.BITMAP_FEATURES)) {
                    features = reader.readByteArray();
                }
                this.protocolCtx = new ProtocolContext(proposedVer, ProtocolBitmaskFeature.enumSet(features));
                if (this.protocolCtx.isFeatureSupported(ProtocolVersionFeature.PARTITION_AWARENESS)) {
                    this.srvNodeId = reader.readUuid();
                }
            } else {
                ProtocolVersion srvVer = new ProtocolVersion(res.readShort(), res.readShort(), res.readShort());
                String err = reader.readString();
                int errCode = 1;
                if (res.remaining() > 0) {
                    errCode = reader.readInt();
                }
                if (errCode == 2000) {
                    throw new ClientAuthenticationException(err);
                }
                if (proposedVer.equals(srvVer)) {
                    throw new ClientProtocolError(err);
                }
                if (!supportedVers.contains(srvVer) || !ProtocolContext.isFeatureSupported(srvVer, ProtocolVersionFeature.AUTHORIZATION) && !F.isEmpty(user)) {
                    throw new ClientProtocolError(String.format("Protocol version mismatch: client %s / server %s. Server details: %s", proposedVer, srvVer, err));
                }
                this.handshake(srvVer, user, pwd, userAttrs);
            }
        }
        catch (IOException e) {
            throw this.handleIOError(e);
        }
    }

    private void write(byte[] bytes, int len) throws ClientConnectionException {
        try {
            this.out.write(bytes, 0, len);
            this.out.flush();
        }
        catch (IOException e) {
            throw this.handleIOError(e);
        }
    }

    private ClientException handleIOError(@Nullable IOException ex) {
        return this.handleIOError("sock=" + this.sock, ex);
    }

    private ClientException handleIOError(String chInfo, @Nullable IOException ex) {
        return new ClientConnectionException("Ignite cluster is unavailable [" + chInfo + ']', ex);
    }

    private static class ClientSslSocketFactory {
        private static final TrustManager ignoreErrorsTrustMgr = new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) {
            }
        };
        private final ClientChannelConfiguration cfg;

        ClientSslSocketFactory(ClientChannelConfiguration cfg) {
            this.cfg = cfg;
        }

        SSLSocket create() throws IOException {
            InetSocketAddress addr = this.cfg.getAddress();
            SSLSocket sock = (SSLSocket)ClientSslSocketFactory.getSslSocketFactory(this.cfg).createSocket(addr.getHostName(), addr.getPort());
            sock.setUseClientMode(true);
            sock.startHandshake();
            return sock;
        }

        private static SSLSocketFactory getSslSocketFactory(ClientChannelConfiguration cfg) {
            TrustManager[] trustManagerArray;
            Factory<SSLContext> sslCtxFactory = cfg.getSslContextFactory();
            if (sslCtxFactory != null) {
                try {
                    return sslCtxFactory.create().getSocketFactory();
                }
                catch (Exception e) {
                    throw new ClientError("SSL Context Factory failed", e);
                }
            }
            BiFunction<String, String, String> or = (val, dflt) -> val == null || val.isEmpty() ? dflt : val;
            String keyStore = or.apply(cfg.getSslClientCertificateKeyStorePath(), System.getProperty("javax.net.ssl.keyStore"));
            String keyStoreType = or.apply(cfg.getSslClientCertificateKeyStoreType(), or.apply(System.getProperty("javax.net.ssl.keyStoreType"), "JKS"));
            String keyStorePwd = or.apply(cfg.getSslClientCertificateKeyStorePassword(), System.getProperty("javax.net.ssl.keyStorePassword"));
            String trustStore = or.apply(cfg.getSslTrustCertificateKeyStorePath(), System.getProperty("javax.net.ssl.trustStore"));
            String trustStoreType = or.apply(cfg.getSslTrustCertificateKeyStoreType(), or.apply(System.getProperty("javax.net.ssl.trustStoreType"), "JKS"));
            String trustStorePwd = or.apply(cfg.getSslTrustCertificateKeyStorePassword(), System.getProperty("javax.net.ssl.trustStorePassword"));
            String algorithm = or.apply(cfg.getSslKeyAlgorithm(), "SunX509");
            String proto = ClientSslSocketFactory.toString(cfg.getSslProtocol());
            if (Stream.of(keyStore, keyStorePwd, keyStoreType, trustStore, trustStorePwd, trustStoreType).allMatch(s -> s == null || s.isEmpty())) {
                try {
                    return SSLContext.getDefault().getSocketFactory();
                }
                catch (NoSuchAlgorithmException e) {
                    throw new ClientError("Default SSL context cryptographic algorithm is not available", e);
                }
            }
            KeyManager[] keyManagers = ClientSslSocketFactory.getKeyManagers(algorithm, keyStore, keyStoreType, keyStorePwd);
            if (cfg.isSslTrustAll()) {
                TrustManager[] trustManagerArray2 = new TrustManager[1];
                trustManagerArray = trustManagerArray2;
                trustManagerArray2[0] = ignoreErrorsTrustMgr;
            } else {
                trustManagerArray = ClientSslSocketFactory.getTrustManagers(algorithm, trustStore, trustStoreType, trustStorePwd);
            }
            TrustManager[] trustManagers = trustManagerArray;
            try {
                SSLContext sslCtx = SSLContext.getInstance(proto);
                sslCtx.init(keyManagers, trustManagers, null);
                return sslCtx.getSocketFactory();
            }
            catch (NoSuchAlgorithmException e) {
                throw new ClientError("SSL context cryptographic algorithm is not available", e);
            }
            catch (KeyManagementException e) {
                throw new ClientError("Failed to create SSL Context", e);
            }
        }

        private static String toString(SslProtocol proto) {
            switch (proto) {
                case TLSv1_1: {
                    return "TLSv1.1";
                }
                case TLSv1_2: {
                    return "TLSv1.2";
                }
            }
            return proto.toString();
        }

        private static KeyManager[] getKeyManagers(String algorithm, String keyStore, String keyStoreType, String keyStorePwd) {
            KeyManagerFactory keyMgrFactory;
            try {
                keyMgrFactory = KeyManagerFactory.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new ClientError("Key manager cryptographic algorithm is not available", e);
            }
            Predicate<String> empty = s -> s == null || s.isEmpty();
            if (!empty.test(keyStore) && !empty.test(keyStoreType)) {
                char[] pwd = keyStorePwd == null ? new char[]{} : keyStorePwd.toCharArray();
                KeyStore store = ClientSslSocketFactory.loadKeyStore("Client", keyStore, keyStoreType, pwd);
                try {
                    keyMgrFactory.init(store, pwd);
                }
                catch (UnrecoverableKeyException e) {
                    throw new ClientError("Could not recover key store key", e);
                }
                catch (KeyStoreException e) {
                    throw new ClientError(String.format("Client key store provider of type [%s] is not available", keyStoreType), e);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new ClientError("Client key store integrity check algorithm is not available", e);
                }
            }
            return keyMgrFactory.getKeyManagers();
        }

        private static TrustManager[] getTrustManagers(String algorithm, String trustStore, String trustStoreType, String trustStorePwd) {
            TrustManagerFactory trustMgrFactory;
            try {
                trustMgrFactory = TrustManagerFactory.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new ClientError("Trust manager cryptographic algorithm is not available", e);
            }
            Predicate<String> empty = s -> s == null || s.isEmpty();
            if (!empty.test(trustStore) && !empty.test(trustStoreType)) {
                char[] pwd = trustStorePwd == null ? new char[]{} : trustStorePwd.toCharArray();
                KeyStore store = ClientSslSocketFactory.loadKeyStore("Trust", trustStore, trustStoreType, pwd);
                try {
                    trustMgrFactory.init(store);
                }
                catch (KeyStoreException e) {
                    throw new ClientError(String.format("Trust key store provider of type [%s] is not available", trustStoreType), e);
                }
            }
            return trustMgrFactory.getTrustManagers();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static KeyStore loadKeyStore(String lb, String path, String type, char[] pwd) {
            KeyStore store;
            try {
                store = KeyStore.getInstance(type);
            }
            catch (KeyStoreException e) {
                throw new ClientError(String.format("%s key store provider of type [%s] is not available", lb, type), e);
            }
            try (FileInputStream in = new FileInputStream(new File(path));){
                store.load(in, pwd);
                KeyStore keyStore = store;
                return keyStore;
            }
            catch (FileNotFoundException e) {
                throw new ClientError(String.format("%s key store file [%s] does not exist", lb, path), e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new ClientError(String.format("%s key store integrity check algorithm is not available", lb), e);
            }
            catch (CertificateException e) {
                throw new ClientError(String.format("Could not load certificate from %s key store", lb), e);
            }
            catch (IOException e) {
                throw new ClientError(String.format("Could not read %s key store", lb), e);
            }
        }
    }

    private static class ClientRequestFuture
    extends GridFutureAdapter<byte[]> {
        private ClientRequestFuture() {
        }
    }

    private class ByteCountingDataInput
    implements AutoCloseable {
        private final InputStream in;
        private long totalBytesRead;
        private final byte[] tmpBuf = new byte[8];

        public ByteCountingDataInput(InputStream in) {
            this.in = in;
        }

        private void read(byte[] bytes, int len) throws ClientConnectionException {
            int readBytesNum;
            int bytesNum;
            for (readBytesNum = 0; readBytesNum < len; readBytesNum += bytesNum) {
                try {
                    bytesNum = this.in.read(bytes, readBytesNum, len - readBytesNum);
                }
                catch (IOException e) {
                    throw TcpClientChannel.this.handleIOError(e);
                }
                if (bytesNum >= 0) continue;
                throw TcpClientChannel.this.handleIOError(null);
            }
            this.totalBytesRead += (long)readBytesNum;
        }

        public byte[] read(int len) throws ClientConnectionException {
            byte[] bytes = new byte[len];
            this.read(bytes, len);
            return bytes;
        }

        public long readLong() throws ClientConnectionException {
            this.read(this.tmpBuf, 8);
            return BinaryPrimitives.readLong(this.tmpBuf, 0);
        }

        public int readInt() throws ClientConnectionException {
            this.read(this.tmpBuf, 4);
            return BinaryPrimitives.readInt(this.tmpBuf, 0);
        }

        public short readShort() throws ClientConnectionException {
            this.read(this.tmpBuf, 2);
            return BinaryPrimitives.readShort(this.tmpBuf, 0);
        }

        public long totalBytesRead() {
            return this.totalBytesRead;
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }
    }
}

