/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import org.apache.ignite.Ignite;
import org.apache.ignite.cache.CacheInterceptorEntry;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public class CacheLazyEntry<K, V>
extends CacheInterceptorEntry<K, V> {
    protected GridCacheContext cctx;
    protected KeyCacheObject keyObj;
    protected CacheObject valObj;
    @GridToStringInclude(sensitive=true)
    protected K key;
    @GridToStringInclude(sensitive=true)
    protected V val;
    private boolean keepBinary;
    private Long updateCntr;

    public CacheLazyEntry(GridCacheContext cctx, KeyCacheObject keyObj, CacheObject valObj, boolean keepBinary) {
        this.cctx = cctx;
        this.keyObj = keyObj;
        this.valObj = valObj;
        this.keepBinary = keepBinary;
    }

    public CacheLazyEntry(GridCacheContext cctx, KeyCacheObject keyObj, V val, boolean keepBinary) {
        this.cctx = cctx;
        this.keyObj = keyObj;
        this.val = val;
        this.keepBinary = keepBinary;
    }

    public CacheLazyEntry(GridCacheContext ctx, KeyCacheObject keyObj, K key, CacheObject valObj, V val, boolean keepBinary, Long updateCntr) {
        this.cctx = ctx;
        this.keyObj = keyObj;
        this.key = key;
        this.valObj = valObj;
        this.val = val;
        this.keepBinary = keepBinary;
        this.updateCntr = updateCntr;
    }

    public CacheLazyEntry(GridCacheContext ctx, KeyCacheObject keyObj, K key, CacheObject valObj, V val, boolean keepBinary) {
        this.cctx = ctx;
        this.keyObj = keyObj;
        this.key = key;
        this.valObj = valObj;
        this.val = val;
        this.keepBinary = keepBinary;
    }

    @Override
    public K getKey() {
        if (this.key == null) {
            this.key = this.cctx.unwrapBinaryIfNeeded(this.keyObj, this.keepBinary);
        }
        return this.key;
    }

    @Override
    public V getValue() {
        return this.getValue(this.keepBinary);
    }

    public V getValue(boolean keepBinary) {
        if (this.val == null) {
            this.val = this.cctx.unwrapBinaryIfNeeded(this.valObj, keepBinary, true);
        }
        return this.val;
    }

    public V value() {
        return this.val;
    }

    public K key() {
        return this.key;
    }

    public boolean keepBinary() {
        return this.keepBinary;
    }

    @Override
    public long getPartitionUpdateCounter() {
        return this.updateCntr == null ? 0L : this.updateCntr;
    }

    public void updateCounter(long updateCntr) {
        this.updateCntr = updateCntr;
    }

    @Override
    public <T> T unwrap(Class<T> cls) {
        if (cls.isAssignableFrom(Ignite.class)) {
            return (T)this.cctx.kernalContext().grid();
        }
        if (cls.isAssignableFrom(GridCacheContext.class)) {
            return (T)this.cctx;
        }
        if (cls.isAssignableFrom(this.getClass())) {
            return cls.cast(this);
        }
        throw new IllegalArgumentException("Unwrapping to class is not supported: " + cls);
    }

    public String toString() {
        return S.toString(CacheLazyEntry.class, this);
    }
}

