/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.datastructures;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.cache.Cache;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.event.EventType;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteSet;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.CacheEntryEventSerializableFilter;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridClosureCallMode;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheAffinityManager;
import org.apache.ignite.internal.processors.cache.GridCacheGateway;
import org.apache.ignite.internal.processors.cache.GridCacheManagerAdapter;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.datastructures.DataStructuresProcessor;
import org.apache.ignite.internal.processors.datastructures.GridAtomicCacheQueueImpl;
import org.apache.ignite.internal.processors.datastructures.GridCacheQueueHeader;
import org.apache.ignite.internal.processors.datastructures.GridCacheQueueHeaderKey;
import org.apache.ignite.internal.processors.datastructures.GridCacheQueueProxy;
import org.apache.ignite.internal.processors.datastructures.GridCacheSetHeader;
import org.apache.ignite.internal.processors.datastructures.GridCacheSetHeaderKey;
import org.apache.ignite.internal.processors.datastructures.GridCacheSetImpl;
import org.apache.ignite.internal.processors.datastructures.GridCacheSetProxy;
import org.apache.ignite.internal.processors.datastructures.GridTransactionalCacheQueueImpl;
import org.apache.ignite.internal.processors.datastructures.SetItemKey;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CacheDataStructuresManager
extends GridCacheManagerAdapter {
    private static final Collection<Class<?>> KNOWN_CLS = new HashSet();
    private final ConcurrentMap<IgniteUuid, GridCacheSetProxy> setsMap;
    private final ConcurrentMap<IgniteUuid, GridCacheQueueProxy> queuesMap;
    private IgniteInternalCache<GridCacheQueueHeaderKey, GridCacheQueueHeader> queueHdrView;
    private UUID queueQryId;
    private final AtomicBoolean queueQryGuard = new AtomicBoolean();
    private final GridSpinBusyLock busyLock = new GridSpinBusyLock();
    private final CountDownLatch initLatch = new CountDownLatch(1);
    private boolean initFlag;

    public CacheDataStructuresManager() {
        this.queuesMap = new ConcurrentHashMap<IgniteUuid, GridCacheQueueProxy>(10);
        this.setsMap = new ConcurrentHashMap<IgniteUuid, GridCacheSetProxy>(10);
    }

    @Override
    protected void onKernalStart0() throws IgniteCheckedException {
        try {
            this.queueHdrView = this.cctx.cache();
            this.initFlag = true;
        }
        finally {
            this.initLatch.countDown();
        }
    }

    @Override
    protected void onKernalStop0(boolean cancel) {
        this.busyLock.block();
        if (this.queueQryId != null) {
            this.cctx.continuousQueries().cancelInternalQuery(this.queueQryId);
        }
        for (GridCacheQueueProxy q : this.queuesMap.values()) {
            q.delegate().onKernalStop();
        }
    }

    @Override
    public void onDisconnected(IgniteFuture reconnectFut) {
        super.onDisconnected(reconnectFut);
        for (Map.Entry e : this.queuesMap.entrySet()) {
            GridCacheQueueProxy queue = (GridCacheQueueProxy)e.getValue();
            queue.delegate().onClientDisconnected();
        }
    }

    public void onRemoved(GridCacheSetProxy set) {
        this.setsMap.remove(set.delegate().id(), set);
    }

    public void onReconnected(boolean clusterRestarted) throws IgniteCheckedException {
        for (Map.Entry e : this.setsMap.entrySet()) {
            GridCacheSetProxy set = (GridCacheSetProxy)e.getValue();
            if (clusterRestarted) {
                set.blockOnRemove();
                this.setsMap.remove(e.getKey(), set);
                continue;
            }
            set.needCheckNotRemoved();
        }
        for (Map.Entry e : this.queuesMap.entrySet()) {
            GridCacheQueueProxy queue = (GridCacheQueueProxy)e.getValue();
            if (!clusterRestarted) continue;
            queue.delegate().onRemoved(false);
            this.queuesMap.remove(e.getKey(), queue);
        }
    }

    private void waitInitialization() throws IgniteCheckedException {
        if (this.initLatch.getCount() > 0L) {
            U.await(this.initLatch);
        }
        if (!this.initFlag) {
            throw new IgniteCheckedException("DataStructures manager was not properly initialized.");
        }
    }

    @Nullable
    public <T> GridCacheQueueProxy<T> queue(String name, int cap, boolean colloc, boolean create) throws IgniteCheckedException {
        this.waitInitialization();
        return this.queue0(name, cap, colloc, create);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> GridCacheQueueProxy<T> queue0(String name, int cap, boolean colloc, boolean create) throws IgniteCheckedException {
        this.cctx.gate().enter();
        try {
            GridCacheQueueProxy queue;
            GridCacheQueueHeader old;
            GridCacheQueueHeader hdr;
            GridCacheQueueHeaderKey key = new GridCacheQueueHeaderKey(name);
            if (create) {
                hdr = new GridCacheQueueHeader(IgniteUuid.randomUuid(), cap, colloc, 0L, 0L, null);
                old = this.queueHdrView.withNoRetries().getAndPutIfAbsent(key, hdr);
                if (old != null) {
                    if (old.capacity() != cap || old.collocated() != colloc) {
                        throw new IgniteCheckedException("Failed to create queue, queue with the same name but different configuration already exists [name=" + name + ']');
                    }
                    hdr = old;
                }
            } else {
                hdr = this.queueHdrView.get(key);
            }
            if (hdr == null) {
                old = null;
                return old;
            }
            if (this.queueQryGuard.compareAndSet(false, true)) {
                this.queueQryId = this.cctx.continuousQueries().executeInternalQuery(new CacheEntryUpdatedListener<Object, Object>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onUpdated(Iterable<CacheEntryEvent<?, ?>> evts) {
                        if (!CacheDataStructuresManager.this.busyLock.enterBusy()) {
                            return;
                        }
                        try {
                            for (CacheEntryEvent<?, ?> e : evts) {
                                GridCacheQueueHeaderKey key = (GridCacheQueueHeaderKey)e.getKey();
                                GridCacheQueueHeader hdr = (GridCacheQueueHeader)e.getValue();
                                for (GridCacheQueueProxy queue : CacheDataStructuresManager.this.queuesMap.values()) {
                                    if (!queue.name().equals(key.queueName())) continue;
                                    if (e.getEventType() == EventType.REMOVED) {
                                        GridCacheQueueHeader oldHdr = (GridCacheQueueHeader)e.getOldValue();
                                        assert (oldHdr != null);
                                        if (!oldHdr.id().equals(queue.delegate().id())) continue;
                                        queue.delegate().onRemoved(false);
                                        CacheDataStructuresManager.this.queuesMap.remove(queue.delegate().id());
                                        continue;
                                    }
                                    queue.delegate().onHeaderChanged(hdr);
                                }
                            }
                        }
                        finally {
                            CacheDataStructuresManager.this.busyLock.leaveBusy();
                        }
                    }
                }, new QueueHeaderPredicate(), this.cctx.isLocal() || this.cctx.isReplicated() && this.cctx.affinityNode(), true, false, false);
            }
            if ((queue = (GridCacheQueueProxy)this.queuesMap.get(hdr.id())) == null) {
                queue = new GridCacheQueueProxy(this.cctx, this.cctx.atomic() ? new GridAtomicCacheQueueImpl(name, hdr, this.cctx) : new GridTransactionalCacheQueueImpl(name, hdr, this.cctx));
                GridCacheQueueProxy old2 = this.queuesMap.putIfAbsent(hdr.id(), queue);
                if (old2 != null) {
                    queue = old2;
                }
            }
            GridCacheQueueProxy gridCacheQueueProxy = queue;
            return gridCacheQueueProxy;
        }
        finally {
            this.cctx.gate().leave();
        }
    }

    @Nullable
    public <T> IgniteSet<T> set(String name, boolean colloc, boolean create, boolean separated) throws IgniteCheckedException {
        return this.set0(name, colloc, create, separated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private <T> IgniteSet<T> set0(String name, boolean collocated, boolean create, boolean separated) throws IgniteCheckedException {
        this.cctx.gate().enter();
        try {
            GridCacheSetHeader old;
            GridCacheSetHeader hdr;
            GridCacheSetHeaderKey key = new GridCacheSetHeaderKey(name);
            IgniteInternalCache<GridCacheSetHeaderKey, GridCacheSetHeader> cache = this.cctx.cache().withNoRetries();
            if (create) {
                hdr = new GridCacheSetHeader(IgniteUuid.randomUuid(), collocated, separated);
                old = cache.getAndPutIfAbsent(key, hdr);
                if (old != null) {
                    hdr = old;
                }
            } else {
                hdr = (GridCacheSetHeader)cache.get(key);
            }
            if (hdr == null) {
                old = null;
                return old;
            }
            GridCacheSetProxy set = (GridCacheSetProxy)this.setsMap.get(hdr.id());
            if (set == null) {
                set = new GridCacheSetProxy(this.cctx, new GridCacheSetImpl(this.cctx, name, hdr));
                GridCacheSetProxy old2 = this.setsMap.putIfAbsent(hdr.id(), set);
                if (old2 != null) {
                    set = old2;
                }
            }
            GridCacheSetProxy gridCacheSetProxy = set;
            return gridCacheSetProxy;
        }
        finally {
            this.cctx.gate().leave();
        }
    }

    public boolean knownType(Object obj) {
        return obj == null || KNOWN_CLS.contains(obj.getClass());
    }

    private void removeSetData(IgniteUuid setId, AffinityTopologyVersion topVer) throws IgniteCheckedException {
        boolean loc = this.cctx.isLocal();
        GridCacheAffinityManager aff = this.cctx.affinity();
        if (!loc) {
            aff.affinityReadyFuture(topVer).get();
            this.cctx.preloader().syncFuture().get();
        }
        GridCacheAdapter cache = this.cctx.cache();
        int BATCH_SIZE = 100;
        ArrayList<SetItemKey> keys = new ArrayList<SetItemKey>(100);
        for (Cache.Entry entry : cache.localEntries(new CachePeekMode[]{CachePeekMode.PRIMARY})) {
            Object obj = entry.getKey();
            if (!(obj instanceof SetItemKey) || !setId.equals(((SetItemKey)obj).setId())) continue;
            keys.add((SetItemKey)obj);
            if (keys.size() != 100) continue;
            this.retryRemoveAll(cache, keys);
            keys.clear();
        }
        if (!keys.isEmpty()) {
            this.retryRemoveAll(cache, keys);
        }
    }

    public void removeSetData(IgniteUuid id, boolean separated) throws IgniteCheckedException {
        assert (id != null);
        if (!this.cctx.isLocal()) {
            while (true) {
                AffinityTopologyVersion topVer;
                block12: {
                    topVer = (AffinityTopologyVersion)this.cctx.topologyVersionFuture().get();
                    Collection<ClusterNode> nodes = F.view(this.cctx.discovery().nodes(topVer), node -> !node.isDaemon());
                    try {
                        this.cctx.closures().callAsyncNoFailover(GridClosureCallMode.BROADCAST, new BlockSetCallable(this.cctx.name(), id), nodes, true, 0L, false).get();
                        if (!separated) break block12;
                        break;
                    }
                    catch (IgniteCheckedException e) {
                        if (e.hasCause(ClusterTopologyCheckedException.class)) {
                            if (!this.log.isDebugEnabled()) continue;
                            this.log.debug("RemoveSetData job failed, will retry: " + e);
                            continue;
                        }
                        if (!this.pingNodes(nodes)) {
                            if (!this.log.isDebugEnabled()) continue;
                            this.log.debug("RemoveSetData job failed and set data node left, will retry: " + e);
                            continue;
                        }
                        throw e;
                    }
                }
                Collection<ClusterNode> affNodes = CU.affinityNodes(this.cctx, topVer);
                try {
                    this.cctx.closures().callAsyncNoFailover(GridClosureCallMode.BROADCAST, new RemoveSetDataCallable(this.cctx.name(), id, topVer), affNodes, true, 0L, false).get();
                }
                catch (IgniteCheckedException e) {
                    if (e.hasCause(ClusterTopologyCheckedException.class)) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("RemoveSetData job failed, will retry: " + e);
                        continue;
                    }
                    if (!this.pingNodes(affNodes)) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("RemoveSetData job failed and set data node left, will retry: " + e);
                        continue;
                    }
                    throw e;
                }
                if (topVer.equals(this.cctx.topologyVersionFuture().get())) break;
            }
        } else {
            this.blockSet(id);
            this.cctx.dataStructures().removeSetData(id, AffinityTopologyVersion.ZERO);
        }
    }

    private boolean pingNodes(Collection<ClusterNode> nodes) throws IgniteCheckedException {
        for (ClusterNode node : nodes) {
            if (this.cctx.discovery().pingNode(node.id())) continue;
            return false;
        }
        return true;
    }

    private void blockSet(IgniteUuid setId) {
        GridCacheSetProxy set = (GridCacheSetProxy)this.setsMap.remove(setId);
        if (set != null) {
            set.blockOnRemove();
        }
    }

    private void retryRemoveAll(final IgniteInternalCache cache, final Collection<SetItemKey> keys) throws IgniteCheckedException {
        DataStructuresProcessor.retry(this.log, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                cache.removeAll(keys);
                return null;
            }
        });
    }

    static {
        KNOWN_CLS.add(String.class);
        KNOWN_CLS.add(Boolean.class);
        KNOWN_CLS.add(Byte.class);
        KNOWN_CLS.add(Short.class);
        KNOWN_CLS.add(Character.class);
        KNOWN_CLS.add(Integer.class);
        KNOWN_CLS.add(Long.class);
        KNOWN_CLS.add(Float.class);
        KNOWN_CLS.add(Double.class);
        KNOWN_CLS.add(String.class);
        KNOWN_CLS.add(UUID.class);
        KNOWN_CLS.add(IgniteUuid.class);
        KNOWN_CLS.add(BigDecimal.class);
        KNOWN_CLS.add(BinaryObject.class);
    }

    @GridInternal
    private static class RemoveSetDataCallable
    implements Callable<Void>,
    Externalizable {
        private static final long serialVersionUID = 5053205121218843148L;
        @IgniteInstanceResource
        private Ignite ignite;
        private String cacheName;
        private IgniteUuid setId;
        private AffinityTopologyVersion topVer;

        public RemoveSetDataCallable() {
        }

        private RemoveSetDataCallable(String cacheName, IgniteUuid setId, @NotNull AffinityTopologyVersion topVer) {
            this.cacheName = cacheName;
            this.setId = setId;
            this.topVer = topVer;
        }

        @Override
        public Void call() throws IgniteCheckedException {
            assert (this.ignite != null);
            GridCacheAdapter cache = ((IgniteKernal)this.ignite).context().cache().internalCache(this.cacheName);
            assert (cache != null);
            GridCacheGateway gate = cache.context().gate();
            gate.enter();
            try {
                cache.context().dataStructures().removeSetData(this.setId, this.topVer);
            }
            finally {
                gate.leave();
            }
            return null;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            U.writeString(out, this.cacheName);
            U.writeIgniteUuid(out, this.setId);
            out.writeObject(this.topVer);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.cacheName = U.readString(in);
            this.setId = U.readIgniteUuid(in);
            this.topVer = (AffinityTopologyVersion)in.readObject();
        }

        public String toString() {
            return "RemoveSetCallable [setId=" + this.setId + ']';
        }
    }

    @GridInternal
    private static class BlockSetCallable
    implements Callable<Void>,
    Externalizable {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        private Ignite ignite;
        private String cacheName;
        private IgniteUuid setId;

        public BlockSetCallable() {
        }

        private BlockSetCallable(String cacheName, IgniteUuid setId) {
            this.cacheName = cacheName;
            this.setId = setId;
        }

        @Override
        public Void call() throws IgniteCheckedException {
            assert (this.ignite != null);
            GridCacheAdapter cache = ((IgniteKernal)this.ignite).context().cache().internalCache(this.cacheName);
            if (cache != null) {
                cache.context().dataStructures().blockSet(this.setId);
            }
            return null;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            U.writeIgniteUuid(out, this.setId);
            U.writeString(out, this.cacheName);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.setId = U.readIgniteUuid(in);
            this.cacheName = U.readString(in);
        }

        public String toString() {
            return "BlockSetCallable [setId=" + this.setId + ']';
        }
    }

    private static class QueueHeaderPredicate<K, V>
    implements CacheEntryEventSerializableFilter<K, V>,
    Externalizable {
        private static final long serialVersionUID = 0L;

        @Override
        public boolean evaluate(CacheEntryEvent<? extends K, ? extends V> e) {
            return e.getKey() instanceof GridCacheQueueHeaderKey;
        }

        @Override
        public void writeExternal(ObjectOutput out) {
        }

        @Override
        public void readExternal(ObjectInput in) {
        }
    }
}

