/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.pagemem;

import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.util.GridUnsafe;

class PageHeader {
    public static final long PAGE_MARKER = 1L;
    private static final long DIRTY_FLAG = 0x100000000000000L;
    private static final int RELATIVE_PTR_OFFSET = 8;
    private static final int PAGE_ID_OFFSET = 16;
    private static final int PAGE_CACHE_ID_OFFSET = 24;
    private static final int PAGE_PIN_CNT_OFFSET = 28;
    private static final int PAGE_TMP_BUF_OFFSET = 40;

    PageHeader() {
    }

    public static void initNew(long absPtr, long relative) {
        PageHeader.relative(absPtr, relative);
        PageHeader.tempBufferPointer(absPtr, 0xFFFFFFFFFFFFFFL);
        GridUnsafe.putLong(absPtr, 1L);
        GridUnsafe.putInt(absPtr + 28L, 0);
    }

    public static boolean dirty(long absPtr) {
        return PageHeader.flag(absPtr, 0x100000000000000L);
    }

    public static boolean dirty(long absPtr, boolean dirty) {
        return PageHeader.flag(absPtr, 0x100000000000000L, dirty);
    }

    private static boolean flag(long absPtr, long flag) {
        assert ((flag & 0xFFFFFFFFFFFFFFL) == 0L);
        assert (Long.bitCount(flag) == 1);
        long relPtrWithFlags = GridUnsafe.getLong(absPtr + 8L);
        return (relPtrWithFlags & flag) != 0L;
    }

    private static boolean flag(long absPtr, long flag, boolean set) {
        boolean was;
        assert ((flag & 0xFFFFFFFFFFFFFFL) == 0L);
        assert (Long.bitCount(flag) == 1);
        long relPtrWithFlags = GridUnsafe.getLong(absPtr + 8L);
        boolean bl = was = (relPtrWithFlags & flag) != 0L;
        relPtrWithFlags = set ? (relPtrWithFlags |= flag) : (relPtrWithFlags &= flag ^ 0xFFFFFFFFFFFFFFFFL);
        GridUnsafe.putLong(absPtr + 8L, relPtrWithFlags);
        return was;
    }

    public static boolean isAcquired(long absPtr) {
        return GridUnsafe.getInt(absPtr + 28L) > 0;
    }

    public static void acquirePage(long absPtr) {
        GridUnsafe.incrementAndGetInt(absPtr + 28L);
    }

    public static int releasePage(long absPtr) {
        return GridUnsafe.decrementAndGetInt(absPtr + 28L);
    }

    public static int pinCount(long absPtr) {
        return GridUnsafe.getIntVolatile(null, absPtr);
    }

    public static long readRelative(long absPtr) {
        return GridUnsafe.getLong(absPtr + 8L) & 0xFFFFFFFFFFFFFFL;
    }

    public static void relative(long absPtr, long relPtr) {
        GridUnsafe.putLong(absPtr + 8L, relPtr & 0xFFFFFFFFFFFFFFL);
    }

    public static void writeTimestamp(long absPtr, long tstamp) {
        GridUnsafe.putLongVolatile(null, absPtr, (tstamp >>= 8) << 8 | 1L);
    }

    public static long readTimestamp(long absPtr) {
        long markerAndTs = GridUnsafe.getLong(absPtr);
        return markerAndTs & 0xFFFFFFFFFFFFFF00L;
    }

    public static void tempBufferPointer(long absPtr, long tmpRelPtr) {
        GridUnsafe.putLong(absPtr + 40L, tmpRelPtr);
    }

    public static long tempBufferPointer(long absPtr) {
        return GridUnsafe.getLong(absPtr + 40L);
    }

    public static long readPageId(long absPtr) {
        return GridUnsafe.getLong(absPtr + 16L);
    }

    private static void pageId(long absPtr, long pageId) {
        GridUnsafe.putLong(absPtr + 16L, pageId);
    }

    private static int readPageGroupId(long absPtr) {
        return GridUnsafe.getInt(absPtr + 24L);
    }

    private static void pageGroupId(long absPtr, int grpId) {
        GridUnsafe.putInt(absPtr + 24L, grpId);
    }

    public static FullPageId fullPageId(long absPtr) {
        return new FullPageId(PageHeader.readPageId(absPtr), PageHeader.readPageGroupId(absPtr));
    }

    public static void fullPageId(long absPtr, FullPageId fullPageId) {
        PageHeader.pageId(absPtr, fullPageId.pageId());
        PageHeader.pageGroupId(absPtr, fullPageId.groupId());
    }
}

