/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.ignite.internal.processors.cache.CacheObjectUtils;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridQueryCacheObjectsIterator
implements Iterator<List<?>>,
AutoCloseable {
    private final Iterator<List<?>> iter;
    private final CacheObjectValueContext cacheObjValCtx;
    private final boolean keepBinary;

    public GridQueryCacheObjectsIterator(Iterator<List<?>> iter, CacheObjectValueContext cacheObjValCtx, boolean keepBinary) {
        this.iter = iter;
        this.cacheObjValCtx = cacheObjValCtx;
        this.keepBinary = keepBinary;
    }

    @Override
    public void close() throws Exception {
        if (this.iter instanceof AutoCloseable) {
            U.closeQuiet((AutoCloseable)((Object)this.iter));
        }
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public List<?> next() {
        return (List)CacheObjectUtils.unwrapBinariesIfNeeded(this.cacheObjValCtx, (Collection<Object>)this.iter.next(), this.keepBinary);
    }

    @Override
    public void remove() {
        this.iter.remove();
    }
}

