/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.configuration.ExecutorConfiguration;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;

public class VisorExecutorConfiguration
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String name;
    private int size;

    public static List<VisorExecutorConfiguration> list(ExecutorConfiguration[] cfgs) {
        ArrayList<VisorExecutorConfiguration> res = new ArrayList<VisorExecutorConfiguration>();
        if (!F.isEmpty(cfgs)) {
            for (ExecutorConfiguration cfg : cfgs) {
                res.add(new VisorExecutorConfiguration(cfg));
            }
        }
        return res;
    }

    public VisorExecutorConfiguration() {
    }

    public VisorExecutorConfiguration(ExecutorConfiguration src) {
        this.name = src.getName();
        this.size = src.getSize();
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.size;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.name);
        out.writeInt(this.size);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = U.readString(in);
        this.size = in.readInt();
    }

    public String toString() {
        return S.toString(VisorExecutorConfiguration.class, this);
    }
}

