/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ssl;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import javax.cache.configuration.Factory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.ssl.SSLContextWrapper;

public class SslContextFactory
implements Factory<SSLContext> {
    private static final long serialVersionUID = 0L;
    public static final String DFLT_STORE_TYPE = "JKS";
    public static final String DFLT_SSL_PROTOCOL = "TLS";
    public static final String DFLT_KEY_ALGORITHM = "SunX509";
    private String proto = "TLS";
    private String keyAlgorithm = "SunX509";
    private String keyStoreType = "JKS";
    private String keyStoreFilePath;
    private char[] keyStorePwd;
    private String trustStoreType = "JKS";
    private String trustStoreFilePath;
    private char[] trustStorePwd;
    private TrustManager[] trustMgrs;
    private String[] cipherSuites;
    private String[] protocols;
    private final AtomicReference<SSLContext> sslCtx = new AtomicReference();

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        A.notNull(keyStoreType, "keyStoreType");
        this.keyStoreType = keyStoreType;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        A.notNull(trustStoreType, "trustStoreType");
        this.trustStoreType = trustStoreType;
    }

    public String getProtocol() {
        return this.proto;
    }

    public void setProtocol(String proto) {
        A.notNull(proto, "proto");
        this.proto = proto;
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public void setKeyAlgorithm(String keyAlgorithm) {
        A.notNull(keyAlgorithm, "keyAlgorithm");
        this.keyAlgorithm = keyAlgorithm;
    }

    public String getKeyStoreFilePath() {
        return this.keyStoreFilePath;
    }

    public void setKeyStoreFilePath(String keyStoreFilePath) {
        A.notNull(keyStoreFilePath, "keyStoreFilePath");
        this.keyStoreFilePath = keyStoreFilePath;
    }

    public char[] getKeyStorePassword() {
        return this.keyStorePwd;
    }

    public void setKeyStorePassword(char[] keyStorePwd) {
        A.notNull(keyStorePwd, "keyStorePwd");
        this.keyStorePwd = keyStorePwd;
    }

    public String getTrustStoreFilePath() {
        return this.trustStoreFilePath;
    }

    public void setTrustStoreFilePath(String trustStoreFilePath) {
        this.trustStoreFilePath = trustStoreFilePath;
    }

    public char[] getTrustStorePassword() {
        return this.trustStorePwd;
    }

    public void setTrustStorePassword(char[] trustStorePwd) {
        this.trustStorePwd = trustStorePwd;
    }

    public TrustManager[] getTrustManagers() {
        return this.trustMgrs;
    }

    public void setTrustManagers(TrustManager ... trustMgrs) {
        this.trustMgrs = trustMgrs;
    }

    public static TrustManager getDisabledTrustManager() {
        return new DisabledX509TrustManager();
    }

    public void setCipherSuites(String ... cipherSuites) {
        this.cipherSuites = cipherSuites;
    }

    public String[] getCipherSuites() {
        return this.cipherSuites;
    }

    public String[] getProtocols() {
        return this.protocols;
    }

    public void setProtocols(String ... protocols) {
        this.protocols = protocols;
    }

    private SSLContext createSslContext() throws SSLException {
        KeyManager[] keyMgrs;
        this.checkParameters();
        try {
            KeyManagerFactory keyMgrFactory = KeyManagerFactory.getInstance(this.keyAlgorithm);
            KeyStore keyStore = this.loadKeyStore(this.keyStoreType, this.keyStoreFilePath, this.keyStorePwd);
            keyMgrFactory.init(keyStore, this.keyStorePwd);
            keyMgrs = keyMgrFactory.getKeyManagers();
        }
        catch (NoSuchAlgorithmException e) {
            throw new SSLException("Unsupported keystore algorithm: " + this.keyAlgorithm, e);
        }
        catch (GeneralSecurityException e) {
            throw new SSLException("Failed to initialize key store (security exception occurred) [type=" + this.keyStoreType + ", keyStorePath=" + this.keyStoreFilePath + ']', e);
        }
        TrustManager[] trustMgrs = this.trustMgrs;
        if (trustMgrs == null) {
            try {
                TrustManagerFactory trustMgrFactory = TrustManagerFactory.getInstance(this.keyAlgorithm);
                KeyStore trustStore = this.loadKeyStore(this.trustStoreType, this.trustStoreFilePath, this.trustStorePwd);
                trustMgrFactory.init(trustStore);
                trustMgrs = trustMgrFactory.getTrustManagers();
            }
            catch (NoSuchAlgorithmException e) {
                throw new SSLException("Unsupported keystore algorithm: " + this.keyAlgorithm, e);
            }
            catch (GeneralSecurityException e) {
                throw new SSLException("Failed to initialize key store (security exception occurred) [type=" + this.keyStoreType + ", keyStorePath=" + this.keyStoreFilePath + ']', e);
            }
        }
        try {
            SSLContext ctx = SSLContext.getInstance(this.proto);
            if (this.cipherSuites != null || this.protocols != null) {
                SSLParameters sslParameters = new SSLParameters();
                if (this.cipherSuites != null) {
                    sslParameters.setCipherSuites(this.cipherSuites);
                }
                if (this.protocols != null) {
                    sslParameters.setProtocols(this.protocols);
                }
                ctx = new SSLContextWrapper(ctx, sslParameters);
            }
            ctx.init(keyMgrs, trustMgrs, null);
            return ctx;
        }
        catch (NoSuchAlgorithmException e) {
            throw new SSLException("Unsupported SSL protocol: " + this.proto, e);
        }
        catch (KeyManagementException e) {
            throw new SSLException("Failed to initialized SSL context.", e);
        }
    }

    private String parameters() {
        StringBuilder buf = new StringBuilder("[keyStoreType=").append(this.keyStoreType);
        buf.append(", proto=").append(this.proto).append(", keyStoreFile=").append(this.keyStoreFilePath);
        if (this.trustMgrs != null) {
            buf.append(", trustMgrs=").append(Arrays.toString(this.trustMgrs));
        } else {
            buf.append(", trustStoreFile=").append(this.trustStoreFilePath);
        }
        buf.append(']');
        return buf.toString();
    }

    private void checkParameters() throws SSLException {
        assert (this.keyStoreType != null);
        assert (this.proto != null);
        this.checkNullParameter(this.keyStoreFilePath, "keyStoreFilePath");
        this.checkNullParameter(this.keyStorePwd, "keyStorePwd");
        if (this.trustMgrs == null) {
            if (this.trustStoreFilePath == null) {
                throw new SSLException("Failed to initialize SSL context (either trustStoreFilePath or trustManagers must be provided)");
            }
            this.checkNullParameter(this.trustStorePwd, "trustStorePwd");
        }
    }

    private void checkNullParameter(Object param, String name) throws SSLException {
        if (param == null) {
            throw new SSLException("Failed to initialize SSL context (parameter cannot be null): " + name);
        }
    }

    protected InputStream openFileInputStream(String filePath) throws IOException {
        return new FileInputStream(filePath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private KeyStore loadKeyStore(String keyStoreType, String storeFilePath, char[] keyStorePwd) throws SSLException {
        try {
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            try (InputStream input = this.openFileInputStream(storeFilePath);){
                keyStore.load(input, keyStorePwd);
                KeyStore keyStore2 = keyStore;
                return keyStore2;
            }
        }
        catch (GeneralSecurityException e) {
            throw new SSLException("Failed to initialize key store (security exception occurred) [type=" + keyStoreType + ", keyStorePath=" + this.keyStoreFilePath + ']', e);
        }
        catch (FileNotFoundException e) {
            throw new SSLException("Failed to initialize key store (key store file was not found): [path=" + storeFilePath + ", msg=" + e.getMessage() + ']');
        }
        catch (IOException e) {
            throw new SSLException("Failed to initialize key store (I/O error occurred): " + storeFilePath, e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.parameters();
    }

    @Override
    public SSLContext create() {
        SSLContext ctx = this.sslCtx.get();
        if (ctx == null) {
            try {
                ctx = this.createSslContext();
                if (!this.sslCtx.compareAndSet(null, ctx)) {
                    ctx = this.sslCtx.get();
                }
            }
            catch (SSLException e) {
                throw new IgniteException(e);
            }
        }
        return ctx;
    }

    private static class DisabledX509TrustManager
    implements X509TrustManager {
        private static final X509Certificate[] CERTS = new X509Certificate[0];

        private DisabledX509TrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return CERTS;
        }
    }
}

