/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.Set;
import org.infinispan.atomic.Operation;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.FastCopyHashMap;
import org.infinispan.commons.util.Util;

public class ClearOperation<K, V>
extends Operation<K, V> {
    FastCopyHashMap<K, V> originalEntries;

    ClearOperation() {
    }

    ClearOperation(FastCopyHashMap<K, V> originalEntries) {
        this.originalEntries = originalEntries;
    }

    @Override
    public void rollback(Map<K, V> delegate) {
        if (!this.originalEntries.isEmpty()) {
            delegate.putAll(this.originalEntries);
        }
    }

    @Override
    public void replay(Map<K, V> delegate) {
        delegate.clear();
    }

    @Override
    public K keyAffected() {
        return null;
    }

    public String toString() {
        return "ClearOperation";
    }

    public static class Externalizer
    extends AbstractExternalizer<ClearOperation> {
        @Override
        public void writeObject(ObjectOutput output, ClearOperation object) throws IOException {
        }

        @Override
        public ClearOperation readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new ClearOperation();
        }

        @Override
        public Integer getId() {
            return 49;
        }

        @Override
        public Set<Class<? extends ClearOperation>> getTypeClasses() {
            return Util.asSet(ClearOperation.class);
        }
    }
}

