/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.async;

import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.commons.util.concurrent.FutureListener;
import org.infinispan.commons.util.concurrent.NotifyingFuture;

public class NotifyingFutureImpl<T>
implements NotifyingFuture<T> {
    private volatile Future<T> executing;
    private volatile CopyOnWriteArraySet<FutureListener<T>> listeners;

    public void setExecuting(Future<T> executing) {
        this.executing = executing;
    }

    @Override
    public NotifyingFuture<T> attachListener(FutureListener<T> futureListener) {
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArraySet();
        }
        this.listeners.add(futureListener);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        try {
            boolean bl = this.executing.cancel(mayInterruptIfRunning);
            return bl;
        }
        finally {
            this.notifyFutureCompletion();
        }
    }

    public void notifyFutureCompletion() {
        if (this.listeners != null) {
            for (FutureListener<T> listener : this.listeners) {
                listener.futureDone(this);
            }
        }
    }

    @Override
    public boolean isCancelled() {
        return this.executing.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.executing.isDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        return this.executing.get();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.executing.get(timeout, unit);
    }
}

