/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.protocol;

import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.impl.protocol.Codec11;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

public class Codec12
extends Codec11 {
    private static final Log log = LogFactory.getLog(Codec12.class, Log.class);

    @Override
    public HeaderParams writeHeader(Transport transport, HeaderParams params) {
        return this.writeHeader(transport, params, (byte)12);
    }

    @Override
    protected HeaderParams writeHeader(Transport transport, HeaderParams params, byte version) {
        transport.writeByte((short)160);
        transport.writeVLong(params.messageId((long)Codec12.MSG_ID.incrementAndGet()).messageId);
        transport.writeByte(version);
        transport.writeByte(params.opCode);
        transport.writeArray(params.cacheName);
        int flagInt = 0;
        if (params.flags != null) {
            for (Flag flag : params.flags) {
                flagInt = flag.getFlagInt() | flagInt;
            }
        }
        transport.writeVInt(flagInt);
        transport.writeByte(params.clientIntel);
        transport.writeVInt(params.topologyId.get());
        transport.writeByte(params.txMarker);
        this.getLog().tracef("Wrote header for message %d. Operation code: %#04x. Flags: %#x", (Object)params.messageId, (Object)params.opCode, (Object)flagInt);
        return params;
    }

    @Override
    public Log getLog() {
        return log;
    }
}

