/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.concurrent.BaseNotifyingFuture;

public class NotifyingFutureAdaptor<T>
extends BaseNotifyingFuture<T> {
    private static Log log = LogFactory.getLog(NotifyingFutureAdaptor.class);
    private volatile Future<T> actual;

    public void setActual(Future<T> actual) {
        this.actual = actual;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.actual.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.actual.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.actual.isDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        T result = this.actual.get();
        log.tracef("Actual future completed with result %s", (Object)result);
        return result;
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.actual.get(timeout, unit);
    }
}

