/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.ConfigurationUtils;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.configuration.cache.CompatibilityModeConfigurationBuilder;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationChildBuilder;
import org.infinispan.configuration.cache.CustomInterceptorsConfigurationBuilder;
import org.infinispan.configuration.cache.DataContainerConfigurationBuilder;
import org.infinispan.configuration.cache.DeadlockDetectionConfigurationBuilder;
import org.infinispan.configuration.cache.EvictionConfigurationBuilder;
import org.infinispan.configuration.cache.ExpirationConfigurationBuilder;
import org.infinispan.configuration.cache.IndexingConfigurationBuilder;
import org.infinispan.configuration.cache.InvocationBatchingConfigurationBuilder;
import org.infinispan.configuration.cache.JMXStatisticsConfigurationBuilder;
import org.infinispan.configuration.cache.LockingConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.SitesConfigurationBuilder;
import org.infinispan.configuration.cache.StoreAsBinaryConfigurationBuilder;
import org.infinispan.configuration.cache.TransactionConfigurationBuilder;
import org.infinispan.configuration.cache.UnsafeConfigurationBuilder;
import org.infinispan.configuration.cache.VersioningConfigurationBuilder;

public class ConfigurationBuilder
implements ConfigurationChildBuilder {
    private WeakReference<ClassLoader> classLoader;
    private final ClusteringConfigurationBuilder clustering;
    private final CustomInterceptorsConfigurationBuilder customInterceptors;
    private final DataContainerConfigurationBuilder dataContainer;
    private final DeadlockDetectionConfigurationBuilder deadlockDetection;
    private final EvictionConfigurationBuilder eviction;
    private final ExpirationConfigurationBuilder expiration;
    private final IndexingConfigurationBuilder indexing;
    private final InvocationBatchingConfigurationBuilder invocationBatching;
    private final JMXStatisticsConfigurationBuilder jmxStatistics;
    private final PersistenceConfigurationBuilder persistence;
    private final LockingConfigurationBuilder locking;
    private final StoreAsBinaryConfigurationBuilder storeAsBinary;
    private final TransactionConfigurationBuilder transaction;
    private final VersioningConfigurationBuilder versioning;
    private final UnsafeConfigurationBuilder unsafe;
    private final List<Builder<?>> modules = new ArrayList();
    private final SitesConfigurationBuilder sites;
    private final CompatibilityModeConfigurationBuilder compatibility;

    public ConfigurationBuilder() {
        this.clustering = new ClusteringConfigurationBuilder(this);
        this.customInterceptors = new CustomInterceptorsConfigurationBuilder(this);
        this.dataContainer = new DataContainerConfigurationBuilder(this);
        this.deadlockDetection = new DeadlockDetectionConfigurationBuilder(this);
        this.eviction = new EvictionConfigurationBuilder(this);
        this.expiration = new ExpirationConfigurationBuilder(this);
        this.indexing = new IndexingConfigurationBuilder(this);
        this.invocationBatching = new InvocationBatchingConfigurationBuilder(this);
        this.jmxStatistics = new JMXStatisticsConfigurationBuilder(this);
        this.persistence = new PersistenceConfigurationBuilder(this);
        this.locking = new LockingConfigurationBuilder(this);
        this.storeAsBinary = new StoreAsBinaryConfigurationBuilder(this);
        this.transaction = new TransactionConfigurationBuilder(this);
        this.versioning = new VersioningConfigurationBuilder(this);
        this.unsafe = new UnsafeConfigurationBuilder(this);
        this.sites = new SitesConfigurationBuilder(this);
        this.compatibility = new CompatibilityModeConfigurationBuilder(this);
    }

    public ConfigurationBuilder classLoader(ClassLoader cl) {
        this.classLoader = new WeakReference<ClassLoader>(cl);
        return this;
    }

    ClassLoader classLoader() {
        return this.classLoader != null ? (ClassLoader)this.classLoader.get() : null;
    }

    @Override
    public ClusteringConfigurationBuilder clustering() {
        return this.clustering;
    }

    @Override
    public CustomInterceptorsConfigurationBuilder customInterceptors() {
        return this.customInterceptors;
    }

    @Override
    public DataContainerConfigurationBuilder dataContainer() {
        return this.dataContainer;
    }

    @Override
    public DeadlockDetectionConfigurationBuilder deadlockDetection() {
        return this.deadlockDetection;
    }

    @Override
    public EvictionConfigurationBuilder eviction() {
        return this.eviction;
    }

    @Override
    public ExpirationConfigurationBuilder expiration() {
        return this.expiration;
    }

    @Override
    public IndexingConfigurationBuilder indexing() {
        return this.indexing;
    }

    @Override
    public InvocationBatchingConfigurationBuilder invocationBatching() {
        return this.invocationBatching;
    }

    @Override
    public JMXStatisticsConfigurationBuilder jmxStatistics() {
        return this.jmxStatistics;
    }

    @Override
    public StoreAsBinaryConfigurationBuilder storeAsBinary() {
        return this.storeAsBinary;
    }

    @Override
    public PersistenceConfigurationBuilder persistence() {
        return this.persistence;
    }

    @Override
    public LockingConfigurationBuilder locking() {
        return this.locking;
    }

    @Override
    public TransactionConfigurationBuilder transaction() {
        return this.transaction;
    }

    @Override
    public VersioningConfigurationBuilder versioning() {
        return this.versioning;
    }

    @Override
    public UnsafeConfigurationBuilder unsafe() {
        return this.unsafe;
    }

    @Override
    public SitesConfigurationBuilder sites() {
        return this.sites;
    }

    @Override
    public CompatibilityModeConfigurationBuilder compatibility() {
        return this.compatibility;
    }

    public List<Builder<?>> modules() {
        return this.modules;
    }

    public ConfigurationBuilder clearModules() {
        this.modules.clear();
        return this;
    }

    public <T extends Builder<?>> T addModule(Class<T> klass) {
        try {
            Constructor<T> constructor = klass.getDeclaredConstructor(ConfigurationBuilder.class);
            Builder builder = (Builder)constructor.newInstance(this);
            this.modules.add(builder);
            return (T)builder;
        }
        catch (Exception e) {
            throw new CacheConfigurationException("Could not instantiate module configuration builder '" + klass.getName() + "'", e);
        }
    }

    public void validate() {
        for (Builder builder : Arrays.asList(this.clustering, this.customInterceptors, this.dataContainer, this.deadlockDetection, this.eviction, this.expiration, this.indexing, this.invocationBatching, this.jmxStatistics, this.persistence, this.locking, this.storeAsBinary, this.transaction, this.versioning, this.unsafe, this.sites, this.compatibility)) {
            builder.validate();
        }
        for (Builder builder : this.modules) {
            builder.validate();
        }
    }

    @Override
    public Configuration build() {
        return this.build(true);
    }

    public Configuration build(boolean validate) {
        if (validate) {
            this.validate();
        }
        LinkedList modulesConfig = new LinkedList();
        for (Builder<?> module : this.modules) {
            modulesConfig.add(module.create());
        }
        return new Configuration(this.clustering.create(), this.customInterceptors.create(), this.dataContainer.create(), this.deadlockDetection.create(), this.eviction.create(), this.expiration.create(), this.indexing.create(), this.invocationBatching.create(), this.jmxStatistics.create(), this.persistence.create(), this.locking.create(), this.storeAsBinary.create(), this.transaction.create(), this.unsafe.create(), this.versioning.create(), this.sites.create(), this.compatibility.create(), modulesConfig, this.classLoader == null ? null : (ClassLoader)this.classLoader.get());
    }

    public ConfigurationBuilder read(Configuration template) {
        this.classLoader = new WeakReference<ClassLoader>(template.classLoader());
        this.clustering.read(template.clustering());
        this.customInterceptors.read(template.customInterceptors());
        this.dataContainer.read(template.dataContainer());
        this.deadlockDetection.read(template.deadlockDetection());
        this.eviction.read(template.eviction());
        this.expiration.read(template.expiration());
        this.indexing.read(template.indexing());
        this.invocationBatching.read(template.invocationBatching());
        this.jmxStatistics.read(template.jmxStatistics());
        this.persistence.read(template.persistence());
        this.locking.read(template.locking());
        this.storeAsBinary.read(template.storeAsBinary());
        this.transaction.read(template.transaction());
        this.unsafe.read(template.unsafe());
        this.sites.read(template.sites());
        this.versioning.read(template.versioning());
        this.compatibility.read(template.compatibility());
        for (Object c : template.modules().values()) {
            Builder<?> builder = this.addModule(ConfigurationUtils.builderFor(c));
            builder.read(c);
        }
        return this;
    }

    public String toString() {
        return "ConfigurationBuilder{classLoader=" + this.classLoader + ", clustering=" + this.clustering + ", customInterceptors=" + this.customInterceptors + ", dataContainer=" + this.dataContainer + ", deadlockDetection=" + this.deadlockDetection + ", eviction=" + this.eviction + ", expiration=" + this.expiration + ", indexing=" + this.indexing + ", invocationBatching=" + this.invocationBatching + ", jmxStatistics=" + this.jmxStatistics + ", persistence=" + this.persistence + ", locking=" + this.locking + ", modules=" + this.modules + ", storeAsBinary=" + this.storeAsBinary + ", transaction=" + this.transaction + ", versioning=" + this.versioning + ", unsafe=" + this.unsafe + ", sites=" + this.sites + ", compatibility=" + this.compatibility + '}';
    }
}

