/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.ExecutorFactoryConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationChildBuilder;
import org.infinispan.configuration.global.GlobalJmxStatisticsConfigurationBuilder;
import org.infinispan.configuration.global.ScheduledExecutorFactoryConfigurationBuilder;
import org.infinispan.configuration.global.SerializationConfigurationBuilder;
import org.infinispan.configuration.global.ShutdownConfigurationBuilder;
import org.infinispan.configuration.global.SiteConfigurationBuilder;
import org.infinispan.configuration.global.TransportConfigurationBuilder;

public class GlobalConfigurationBuilder
implements GlobalConfigurationChildBuilder {
    private WeakReference<ClassLoader> cl;
    private final TransportConfigurationBuilder transport;
    private final GlobalJmxStatisticsConfigurationBuilder globalJmxStatistics;
    private final SerializationConfigurationBuilder serialization;
    private final ExecutorFactoryConfigurationBuilder asyncTransportExecutor;
    private final ExecutorFactoryConfigurationBuilder asyncListenerExecutor;
    private final ExecutorFactoryConfigurationBuilder persistenceExecutor;
    private final ExecutorFactoryConfigurationBuilder remoteCommandsExecutor;
    private final ExecutorFactoryConfigurationBuilder totalOrderExecutor;
    private final ScheduledExecutorFactoryConfigurationBuilder evictionScheduledExecutor;
    private final ScheduledExecutorFactoryConfigurationBuilder replicationQueueScheduledExecutor;
    private final ShutdownConfigurationBuilder shutdown;
    private final List<Builder<?>> modules = new ArrayList();
    private final SiteConfigurationBuilder site;

    public GlobalConfigurationBuilder() {
        this.cl = new WeakReference<ClassLoader>(Thread.currentThread().getContextClassLoader());
        this.transport = new TransportConfigurationBuilder(this);
        this.globalJmxStatistics = new GlobalJmxStatisticsConfigurationBuilder(this);
        this.serialization = new SerializationConfigurationBuilder(this);
        this.asyncListenerExecutor = new ExecutorFactoryConfigurationBuilder(this);
        this.persistenceExecutor = new ExecutorFactoryConfigurationBuilder(this);
        this.asyncTransportExecutor = new ExecutorFactoryConfigurationBuilder(this);
        this.remoteCommandsExecutor = new ExecutorFactoryConfigurationBuilder(this);
        this.evictionScheduledExecutor = new ScheduledExecutorFactoryConfigurationBuilder(this);
        this.replicationQueueScheduledExecutor = new ScheduledExecutorFactoryConfigurationBuilder(this);
        this.shutdown = new ShutdownConfigurationBuilder(this);
        this.site = new SiteConfigurationBuilder(this);
        this.totalOrderExecutor = new ExecutorFactoryConfigurationBuilder(this);
    }

    public GlobalConfigurationBuilder clusteredDefault() {
        this.transport().defaultTransport().clearProperties().asyncTransportExecutor().addProperty("threadNamePrefix", "asyncTransportThread");
        return this;
    }

    public GlobalConfigurationBuilder nonClusteredDefault() {
        this.transport().transport(null).clearProperties();
        return this;
    }

    protected ClassLoader getClassLoader() {
        return (ClassLoader)this.cl.get();
    }

    public GlobalConfigurationBuilder classLoader(ClassLoader cl) {
        this.cl = new WeakReference<ClassLoader>(cl);
        return this;
    }

    @Override
    public TransportConfigurationBuilder transport() {
        return this.transport;
    }

    @Override
    public GlobalJmxStatisticsConfigurationBuilder globalJmxStatistics() {
        return this.globalJmxStatistics;
    }

    @Override
    public SerializationConfigurationBuilder serialization() {
        return this.serialization;
    }

    @Override
    public ExecutorFactoryConfigurationBuilder asyncTransportExecutor() {
        return this.asyncTransportExecutor;
    }

    @Override
    public ExecutorFactoryConfigurationBuilder asyncListenerExecutor() {
        return this.asyncListenerExecutor;
    }

    @Override
    public ExecutorFactoryConfigurationBuilder persistenceExecutor() {
        return this.persistenceExecutor;
    }

    @Override
    public ExecutorFactoryConfigurationBuilder remoteCommandsExecutor() {
        return this.remoteCommandsExecutor;
    }

    @Override
    public ScheduledExecutorFactoryConfigurationBuilder evictionScheduledExecutor() {
        return this.evictionScheduledExecutor;
    }

    @Override
    public ScheduledExecutorFactoryConfigurationBuilder replicationQueueScheduledExecutor() {
        return this.replicationQueueScheduledExecutor;
    }

    @Override
    public ShutdownConfigurationBuilder shutdown() {
        return this.shutdown;
    }

    public List<Builder<?>> modules() {
        return this.modules;
    }

    public GlobalConfigurationBuilder clearModules() {
        this.modules.clear();
        return this;
    }

    @Override
    public SiteConfigurationBuilder site() {
        return this.site;
    }

    public <T extends Builder<?>> T addModule(Class<T> klass) {
        try {
            Constructor<T> constructor = klass.getDeclaredConstructor(GlobalConfigurationBuilder.class);
            Builder builder = (Builder)constructor.newInstance(this);
            this.modules.add(builder);
            return (T)builder;
        }
        catch (Exception e) {
            throw new CacheConfigurationException("Could not instantiate module configuration builder '" + klass.getName() + "'", e);
        }
    }

    public ExecutorFactoryConfigurationBuilder totalOrderExecutor() {
        return this.totalOrderExecutor;
    }

    public void validate() {
        for (AbstractGlobalConfigurationBuilder abstractGlobalConfigurationBuilder : Arrays.asList(this.asyncListenerExecutor, this.persistenceExecutor, this.asyncTransportExecutor, this.remoteCommandsExecutor, this.evictionScheduledExecutor, this.replicationQueueScheduledExecutor, this.globalJmxStatistics, this.transport, this.serialization, this.shutdown, this.site, this.totalOrderExecutor)) {
            abstractGlobalConfigurationBuilder.validate();
        }
        for (Builder builder : this.modules) {
            builder.validate();
        }
    }

    @Override
    public GlobalConfiguration build() {
        this.validate();
        LinkedList modulesConfig = new LinkedList();
        for (Builder<?> module : this.modules) {
            modulesConfig.add(module.create());
        }
        return new GlobalConfiguration(this.asyncListenerExecutor.create(), this.asyncTransportExecutor.create(), this.remoteCommandsExecutor.create(), this.evictionScheduledExecutor.create(), this.replicationQueueScheduledExecutor.create(), this.globalJmxStatistics.create(), this.transport.create(), this.serialization.create(), this.shutdown.create(), modulesConfig, this.site.create(), (ClassLoader)this.cl.get(), this.totalOrderExecutor.create(), this.persistenceExecutor.create());
    }

    public GlobalConfigurationBuilder read(GlobalConfiguration template) {
        this.cl = new WeakReference<ClassLoader>(template.classLoader());
        for (Object c : template.modules().values()) {
            BuiltBy builtBy = c.getClass().getAnnotation(BuiltBy.class);
            Builder builder = this.addModule(builtBy.value());
            builder.read(c);
        }
        this.asyncListenerExecutor.read(template.asyncListenerExecutor());
        this.persistenceExecutor.read(template.asyncListenerExecutor());
        this.asyncTransportExecutor.read(template.asyncTransportExecutor());
        this.remoteCommandsExecutor.read(template.remoteCommandsExecutor());
        this.evictionScheduledExecutor.read(template.evictionScheduledExecutor());
        this.globalJmxStatistics.read(template.globalJmxStatistics());
        this.replicationQueueScheduledExecutor.read(template.replicationQueueScheduledExecutor());
        this.serialization.read(template.serialization());
        this.shutdown.read(template.shutdown());
        this.transport.read(template.transport());
        this.site.read(template.sites());
        this.totalOrderExecutor.read(template.totalOrderExecutor());
        return this;
    }

    public static GlobalConfigurationBuilder defaultClusteredBuilder() {
        GlobalConfigurationBuilder builder = new GlobalConfigurationBuilder();
        builder.transport().defaultTransport().asyncTransportExecutor().addProperty("threadNamePrefix", "asyncTransportThread");
        return builder;
    }

    public String toString() {
        return "GlobalConfigurationBuilder{asyncListenerExecutor=" + this.asyncListenerExecutor + "persistenceExecutor=" + this.persistenceExecutor + ", cl=" + this.cl + ", transport=" + this.transport + ", globalJmxStatistics=" + this.globalJmxStatistics + ", serialization=" + this.serialization + ", asyncTransportExecutor=" + this.asyncTransportExecutor + ", remoteCommandsExecutor=" + this.remoteCommandsExecutor + ", evictionScheduledExecutor=" + this.evictionScheduledExecutor + ", replicationQueueScheduledExecutor=" + this.replicationQueueScheduledExecutor + ", shutdown=" + this.shutdown + ", site=" + this.site + ", totalOrderExecutor=" + this.totalOrderExecutor + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalConfigurationBuilder that = (GlobalConfigurationBuilder)o;
        if (this.asyncListenerExecutor != null ? !this.asyncListenerExecutor.equals(that.asyncListenerExecutor) : that.asyncListenerExecutor != null) {
            return false;
        }
        if (this.persistenceExecutor != null ? !this.persistenceExecutor.equals(that.persistenceExecutor) : that.persistenceExecutor != null) {
            return false;
        }
        if (this.asyncTransportExecutor != null ? !this.asyncTransportExecutor.equals(that.asyncTransportExecutor) : that.asyncTransportExecutor != null) {
            return false;
        }
        if (this.remoteCommandsExecutor != null ? !this.remoteCommandsExecutor.equals(that.remoteCommandsExecutor) : that.remoteCommandsExecutor != null) {
            return false;
        }
        if (this.cl != null ? !this.cl.equals(that.cl) : that.cl != null) {
            return false;
        }
        if (this.evictionScheduledExecutor != null ? !this.evictionScheduledExecutor.equals(that.evictionScheduledExecutor) : that.evictionScheduledExecutor != null) {
            return false;
        }
        if (this.globalJmxStatistics != null ? !this.globalJmxStatistics.equals(that.globalJmxStatistics) : that.globalJmxStatistics != null) {
            return false;
        }
        if (this.replicationQueueScheduledExecutor != null ? !this.replicationQueueScheduledExecutor.equals(that.replicationQueueScheduledExecutor) : that.replicationQueueScheduledExecutor != null) {
            return false;
        }
        if (this.serialization != null ? !this.serialization.equals(that.serialization) : that.serialization != null) {
            return false;
        }
        if (this.shutdown != null ? !this.shutdown.equals(that.shutdown) : that.shutdown != null) {
            return false;
        }
        if (this.site != null ? !this.site.equals(that.site) : that.site != null) {
            return false;
        }
        if (this.transport != null ? !this.transport.equals(that.transport) : that.transport != null) {
            return false;
        }
        return !(this.totalOrderExecutor == null ? that.totalOrderExecutor != null : !this.totalOrderExecutor.equals(that.totalOrderExecutor()));
    }

    public int hashCode() {
        int result = this.cl != null ? this.cl.hashCode() : 0;
        result = 31 * result + (this.transport != null ? this.transport.hashCode() : 0);
        result = 31 * result + (this.globalJmxStatistics != null ? this.globalJmxStatistics.hashCode() : 0);
        result = 31 * result + (this.serialization != null ? this.serialization.hashCode() : 0);
        result = 31 * result + (this.asyncTransportExecutor != null ? this.asyncTransportExecutor.hashCode() : 0);
        result = 31 * result + (this.asyncListenerExecutor != null ? this.asyncListenerExecutor.hashCode() : 0);
        result = 31 * result + (this.remoteCommandsExecutor != null ? this.remoteCommandsExecutor.hashCode() : 0);
        result = 31 * result + (this.evictionScheduledExecutor != null ? this.evictionScheduledExecutor.hashCode() : 0);
        result = 31 * result + (this.replicationQueueScheduledExecutor != null ? this.replicationQueueScheduledExecutor.hashCode() : 0);
        result = 31 * result + (this.shutdown != null ? this.shutdown.hashCode() : 0);
        result = 31 * result + (this.site != null ? this.site.hashCode() : 0);
        result = 31 * result + (this.totalOrderExecutor != null ? this.totalOrderExecutor().hashCode() : 0);
        return result;
    }
}

