/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TransportConfigurationBuilder
extends AbstractGlobalConfigurationBuilder<TransportConfiguration> {
    private static final Log log = LogFactory.getLog(TransportConfigurationBuilder.class);
    public static final String DEFAULT_TRANSPORT = "org.infinispan.remoting.transport.jgroups.JGroupsTransport";
    private String clusterName = "ISPN";
    private String machineId;
    private String rackId;
    private String siteId;
    private long distributedSyncTimeout = TimeUnit.MINUTES.toMillis(4L);
    private Transport transport;
    private String nodeName;
    private Properties properties = new Properties();

    TransportConfigurationBuilder(GlobalConfigurationBuilder globalConfig) {
        super(globalConfig);
    }

    public TransportConfigurationBuilder clusterName(String clusterName) {
        this.clusterName = clusterName;
        return this;
    }

    public TransportConfigurationBuilder machineId(String machineId) {
        this.machineId = machineId;
        return this;
    }

    public TransportConfigurationBuilder rackId(String rackId) {
        this.rackId = rackId;
        return this;
    }

    public TransportConfigurationBuilder siteId(String siteId) {
        this.siteId = siteId;
        return this;
    }

    public TransportConfigurationBuilder distributedSyncTimeout(long distributedSyncTimeout) {
        this.distributedSyncTimeout = distributedSyncTimeout;
        return this;
    }

    public TransportConfigurationBuilder distributedSyncTimeout(long distributedSyncTimeout, TimeUnit unit) {
        return this.distributedSyncTimeout(unit.toMillis(distributedSyncTimeout));
    }

    public TransportConfigurationBuilder transport(Transport transport) {
        this.transport = transport;
        return this;
    }

    public TransportConfigurationBuilder nodeName(String nodeName) {
        this.nodeName = nodeName;
        return this;
    }

    public TransportConfigurationBuilder withProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public TransportConfigurationBuilder clearProperties() {
        this.properties = new Properties();
        return this;
    }

    public TransportConfigurationBuilder addProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public TransportConfigurationBuilder removeProperty(String key) {
        this.properties.remove(key);
        return this;
    }

    @Deprecated
    public TransportConfigurationBuilder strictPeerToPeer(Boolean ignored) {
        log.strictPeerToPeerDeprecated();
        return this;
    }

    @Override
    void validate() {
        if (this.clusterName == null) {
            throw new CacheConfigurationException("Transport clusterName cannot be null");
        }
    }

    @Override
    TransportConfiguration create() {
        return new TransportConfiguration(this.clusterName, this.machineId, this.rackId, this.siteId, this.distributedSyncTimeout, this.transport, this.nodeName, TypedProperties.toTypedProperties(this.properties));
    }

    public TransportConfigurationBuilder defaultTransport() {
        Transport transport = (Transport)Util.getInstance(DEFAULT_TRANSPORT, this.getGlobalConfig().getClassLoader());
        this.transport(transport);
        return this;
    }

    protected TransportConfigurationBuilder read(TransportConfiguration template) {
        this.clusterName = template.clusterName();
        this.distributedSyncTimeout = template.distributedSyncTimeout();
        this.machineId = template.machineId();
        this.nodeName = template.nodeName();
        this.properties = template.properties();
        this.rackId = template.rackId();
        this.siteId = template.siteId();
        this.transport = template.transport();
        return this;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public String toString() {
        return "TransportConfigurationBuilder{clusterName='" + this.clusterName + '\'' + ", machineId='" + this.machineId + '\'' + ", rackId='" + this.rackId + '\'' + ", siteId='" + this.siteId + '\'' + ", distributedSyncTimeout=" + this.distributedSyncTimeout + ", transport=" + this.transport + ", nodeName='" + this.nodeName + '\'' + ", properties=" + this.properties + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransportConfigurationBuilder that = (TransportConfigurationBuilder)o;
        if (this.distributedSyncTimeout != that.distributedSyncTimeout) {
            return false;
        }
        if (this.clusterName != null ? !this.clusterName.equals(that.clusterName) : that.clusterName != null) {
            return false;
        }
        if (this.machineId != null ? !this.machineId.equals(that.machineId) : that.machineId != null) {
            return false;
        }
        if (this.nodeName != null ? !this.nodeName.equals(that.nodeName) : that.nodeName != null) {
            return false;
        }
        if (this.properties != null ? !this.properties.equals(that.properties) : that.properties != null) {
            return false;
        }
        if (this.rackId != null ? !this.rackId.equals(that.rackId) : that.rackId != null) {
            return false;
        }
        if (this.siteId != null ? !this.siteId.equals(that.siteId) : that.siteId != null) {
            return false;
        }
        return !(this.transport != null ? !this.transport.equals(that.transport) : that.transport != null);
    }

    public int hashCode() {
        int result = this.clusterName != null ? this.clusterName.hashCode() : 0;
        result = 31 * result + (this.machineId != null ? this.machineId.hashCode() : 0);
        result = 31 * result + (this.rackId != null ? this.rackId.hashCode() : 0);
        result = 31 * result + (this.siteId != null ? this.siteId.hashCode() : 0);
        result = 31 * result + (int)(this.distributedSyncTimeout ^ this.distributedSyncTimeout >>> 32);
        result = 31 * result + (this.transport != null ? this.transport.hashCode() : 0);
        result = 31 * result + (this.nodeName != null ? this.nodeName.hashCode() : 0);
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        return result;
    }
}

