/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import org.infinispan.atomic.AtomicHashMap;
import org.infinispan.commons.util.Util;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.container.entries.StateChangingEntry;
import org.infinispan.metadata.Metadata;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ReadCommittedEntry
implements MVCCEntry {
    private static final Log log = LogFactory.getLog(ReadCommittedEntry.class);
    private static final boolean trace = log.isTraceEnabled();
    protected Object key;
    protected Object value;
    protected Object oldValue;
    protected byte flags = 0;
    protected Metadata metadata;

    public ReadCommittedEntry(Object key, Object value, Metadata metadata) {
        this.setValid(true);
        this.key = key;
        this.value = value;
        this.metadata = metadata;
    }

    @Override
    public byte getStateFlags() {
        return this.flags;
    }

    @Override
    public void copyStateFlagsFrom(StateChangingEntry other) {
        this.flags = other.getStateFlags();
    }

    protected final boolean isFlagSet(Flags flag) {
        return (this.flags & flag.mask) != 0;
    }

    protected final void setFlag(Flags flag) {
        this.flags = (byte)(this.flags | flag.mask);
    }

    protected final void unsetFlag(Flags flag) {
        this.flags = (byte)(this.flags & ~flag.mask);
    }

    @Override
    public final long getLifespan() {
        return this.metadata.lifespan();
    }

    @Override
    public final long getMaxIdle() {
        return this.metadata.maxIdle();
    }

    @Override
    public final Object getKey() {
        return this.key;
    }

    @Override
    public final Object getValue() {
        return this.value;
    }

    @Override
    public final Object setValue(Object value) {
        Object oldValue = this.value;
        this.value = value;
        return oldValue;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public void copyForUpdate(DataContainer container) {
        if (this.isFlagSet(Flags.COPIED)) {
            return;
        }
        this.setFlag(Flags.COPIED);
        if (!this.isCreated()) {
            this.oldValue = this.value;
        }
    }

    @Override
    public final void commit(DataContainer container, Metadata providedMetadata) {
        if (this.isChanged() || this.isLoaded()) {
            if (trace) {
                log.tracef("Updating entry (key=%s removed=%s valid=%s changed=%s created=%s loaded=%s value=%s metadata=%s, providedMetadata=%s)", Util.toStr(this.getKey()), this.isRemoved(), this.isValid(), this.isChanged(), this.isCreated(), this.isLoaded(), Util.toStr(this.value), this.getMetadata(), providedMetadata);
            }
            if (this.value instanceof AtomicHashMap) {
                AtomicHashMap ahm = (AtomicHashMap)this.value;
                if (this.isRemoved() && !this.isEvicted()) {
                    ahm.markRemoved(true);
                }
            }
            if (this.isRemoved()) {
                container.remove(this.key);
            } else if (this.value != null) {
                container.put(this.key, this.value, providedMetadata == null ? this.metadata : providedMetadata);
            }
            this.reset();
        }
    }

    private void reset() {
        this.oldValue = null;
        this.flags = 0;
        this.setValid(true);
    }

    @Override
    public final void rollback() {
        if (this.isChanged()) {
            this.value = this.oldValue;
            this.reset();
        }
    }

    @Override
    public final boolean isChanged() {
        return this.isFlagSet(Flags.CHANGED);
    }

    @Override
    public final void setChanged(boolean changed) {
        this.setFlag(changed, Flags.CHANGED);
    }

    @Override
    public void setSkipRemoteGet(boolean skipRemoteGet) {
    }

    @Override
    public boolean skipRemoteGet() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.isFlagSet(Flags.VALID);
    }

    @Override
    public final void setValid(boolean valid) {
        this.setFlag(valid, Flags.VALID);
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public final boolean isCreated() {
        return this.isFlagSet(Flags.CREATED);
    }

    @Override
    public final void setCreated(boolean created) {
        this.setFlag(created, Flags.CREATED);
    }

    @Override
    public boolean isRemoved() {
        return this.isFlagSet(Flags.REMOVED);
    }

    @Override
    public boolean isEvicted() {
        return this.isFlagSet(Flags.EVICTED);
    }

    @Override
    public final void setRemoved(boolean removed) {
        this.setFlag(removed, Flags.REMOVED);
    }

    @Override
    public void setEvicted(boolean evicted) {
        this.setFlag(evicted, Flags.EVICTED);
    }

    @Override
    public boolean isLoaded() {
        return this.isFlagSet(Flags.LOADED);
    }

    @Override
    public void setLoaded(boolean loaded) {
        this.setFlag(loaded, Flags.LOADED);
    }

    protected final void setFlag(boolean enable, Flags flag) {
        if (enable) {
            this.setFlag(flag);
        } else {
            this.unsetFlag(flag);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + Util.hexIdHashCode(this) + "){" + "key=" + Util.toStr(this.key) + ", value=" + Util.toStr(this.value) + ", oldValue=" + Util.toStr(this.oldValue) + ", isCreated=" + this.isCreated() + ", isChanged=" + this.isChanged() + ", isRemoved=" + this.isRemoved() + ", isValid=" + this.isValid() + ", skipRemoteGet=" + this.skipRemoteGet() + ", metadata=" + this.metadata + '}';
    }

    @Override
    public boolean undelete(boolean doUndelete) {
        if (this.isRemoved() && doUndelete) {
            if (trace) {
                log.trace("Entry is deleted in current scope.  Un-deleting.");
            }
            this.setRemoved(false);
            this.setValid(true);
            this.setValue((Object)null);
            return true;
        }
        return false;
    }

    protected static enum Flags {
        CHANGED(1),
        CREATED(2),
        REMOVED(4),
        VALID(8),
        EVICTED(16),
        LOADED(32),
        SKIP_REMOTE_GET(64),
        COPIED(128);

        final byte mask;

        private Flags(int mask) {
            this.mask = (byte)mask;
        }
    }
}

