/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Immutables;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.remoting.transport.Address;

@Immutable
public class DefaultConsistentHash
implements ConsistentHash {
    private final Hash hashFunction;
    private final int numOwners;
    private final int numSegments;
    private final List<Address> members;
    private Map<Address, Float> capacityFactors;
    private final List<Address>[] segmentOwners;
    private final int segmentSize;

    public DefaultConsistentHash(Hash hashFunction, int numOwners, int numSegments, List<Address> members, Map<Address, Float> capacityFactors, List<Address>[] segmentOwners) {
        if (numSegments < 1) {
            throw new IllegalArgumentException("The number of segments must be strictly positive");
        }
        if (numOwners < 1) {
            throw new IllegalArgumentException("The number of owners must be strictly positive");
        }
        this.numOwners = numOwners;
        this.numSegments = numSegments;
        this.hashFunction = hashFunction;
        this.members = new ArrayList<Address>(members);
        this.capacityFactors = capacityFactors != null ? new HashMap<Address, Float>(capacityFactors) : null;
        this.segmentOwners = new List[numSegments];
        for (int i = 0; i < numSegments; ++i) {
            if (segmentOwners[i] == null || segmentOwners[i].isEmpty()) {
                throw new IllegalArgumentException("Segment owner list cannot be null or empty");
            }
            this.segmentOwners[i] = Immutables.immutableListCopy(segmentOwners[i]);
        }
        this.segmentSize = (int)Math.ceil(2.1474836E9f / (float)numSegments);
    }

    @Override
    public Hash getHashFunction() {
        return this.hashFunction;
    }

    @Override
    public int getNumSegments() {
        return this.numSegments;
    }

    @Override
    public Set<Integer> getSegmentsForOwner(Address owner) {
        if (owner == null) {
            throw new IllegalArgumentException("owner cannot be null");
        }
        if (!this.members.contains(owner)) {
            throw new IllegalArgumentException("Node " + owner + " is not a member");
        }
        HashSet<Integer> segments = new HashSet<Integer>();
        for (int segment = 0; segment < this.segmentOwners.length; ++segment) {
            if (!this.segmentOwners[segment].contains(owner)) continue;
            segments.add(segment);
        }
        return segments;
    }

    @Override
    public int getSegment(Object key) {
        return this.getNormalizedHash(key) / this.segmentSize;
    }

    public int getNormalizedHash(Object key) {
        return this.hashFunction.hash(key) & Integer.MAX_VALUE;
    }

    public List<Integer> getSegmentEndHashes() {
        ArrayList<Integer> hashes = new ArrayList<Integer>(this.numSegments);
        for (int i = 0; i < this.numSegments; ++i) {
            hashes.add((i + 1) % this.numSegments * this.segmentSize);
        }
        return hashes;
    }

    @Override
    public List<Address> locateOwnersForSegment(int segmentId) {
        return this.segmentOwners[segmentId];
    }

    @Override
    public Address locatePrimaryOwnerForSegment(int segmentId) {
        return this.segmentOwners[segmentId].get(0);
    }

    @Override
    public List<Address> getMembers() {
        return this.members;
    }

    @Override
    public int getNumOwners() {
        return this.numOwners;
    }

    @Override
    public Address locatePrimaryOwner(Object key) {
        return this.locatePrimaryOwnerForSegment(this.getSegment(key));
    }

    @Override
    public List<Address> locateOwners(Object key) {
        return this.locateOwnersForSegment(this.getSegment(key));
    }

    @Override
    public Set<Address> locateAllOwners(Collection<Object> keys) {
        HashSet<Integer> segments = new HashSet<Integer>();
        for (Object key : keys) {
            segments.add(this.getSegment(key));
        }
        HashSet<Address> ownersUnion = new HashSet<Address>();
        for (Integer segment : segments) {
            ownersUnion.addAll(this.segmentOwners[segment]);
        }
        return ownersUnion;
    }

    @Override
    public boolean isKeyLocalToNode(Address nodeAddress, Object key) {
        int segment = this.getSegment(key);
        for (Address a : this.segmentOwners[segment]) {
            if (!a.equals(nodeAddress)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = this.hashFunction.hashCode();
        result = 31 * result + this.numOwners;
        result = 31 * result + this.numSegments;
        result = 31 * result + this.members.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultConsistentHash that = (DefaultConsistentHash)o;
        if (this.numOwners != that.numOwners) {
            return false;
        }
        if (this.numSegments != that.numSegments) {
            return false;
        }
        if (!this.hashFunction.equals(that.hashFunction)) {
            return false;
        }
        if (!this.members.equals(that.members)) {
            return false;
        }
        for (int i = 0; i < this.numSegments; ++i) {
            if (this.segmentOwners[i].equals(that.segmentOwners[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultConsistentHash{");
        sb.append("numSegments=").append(this.numSegments);
        sb.append(", numOwners=").append(this.numOwners);
        sb.append(", members=").append(this.members);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public String getRoutingTableAsString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.numSegments; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(i).append(":");
            for (int j = 0; j < this.segmentOwners[i].size(); ++j) {
                sb.append(' ').append(this.members.indexOf(this.segmentOwners[i].get(j)));
            }
        }
        return sb.toString();
    }

    public DefaultConsistentHash union(DefaultConsistentHash dch2) {
        if (!this.hashFunction.equals(dch2.getHashFunction())) {
            throw new IllegalArgumentException("The consistent hash objects must have the same hash function");
        }
        if (this.numSegments != dch2.getNumSegments()) {
            throw new IllegalArgumentException("The consistent hash objects must have the same number of segments");
        }
        if (this.numOwners != dch2.getNumOwners()) {
            throw new IllegalArgumentException("The consistent hash objects must have the same number of owners");
        }
        ArrayList<Address> unionMembers = new ArrayList<Address>(this.members);
        this.mergeLists(unionMembers, dch2.getMembers());
        List[] unionSegmentOwners = new List[this.numSegments];
        for (int i = 0; i < this.numSegments; ++i) {
            unionSegmentOwners[i] = new ArrayList<Address>(this.locateOwnersForSegment(i));
            this.mergeLists(unionSegmentOwners[i], dch2.locateOwnersForSegment(i));
        }
        HashMap<Address, Float> unionCapacityFactors = null;
        if (this.capacityFactors != null || dch2.capacityFactors != null) {
            unionCapacityFactors = new HashMap<Address, Float>();
            if (this.capacityFactors != null) {
                unionCapacityFactors.putAll(this.capacityFactors);
            } else {
                for (Address node : this.members) {
                    unionCapacityFactors.put(node, Float.valueOf(1.0f));
                }
            }
            if (dch2.capacityFactors != null) {
                unionCapacityFactors.putAll(dch2.capacityFactors);
            } else {
                for (Address node : dch2.members) {
                    unionCapacityFactors.put(node, Float.valueOf(1.0f));
                }
            }
        }
        return new DefaultConsistentHash(this.hashFunction, this.numOwners, this.numSegments, unionMembers, unionCapacityFactors, unionSegmentOwners);
    }

    private void mergeLists(List<Address> dest, List<Address> src) {
        for (Address node : src) {
            if (dest.contains(node)) continue;
            dest.add(node);
        }
    }

    public Map<Address, Float> getCapacityFactors() {
        return this.capacityFactors;
    }

    public static class Externalizer
    extends AbstractExternalizer<DefaultConsistentHash> {
        @Override
        public void writeObject(ObjectOutput output, DefaultConsistentHash ch) throws IOException {
            output.writeInt(ch.numSegments);
            output.writeInt(ch.numOwners);
            output.writeObject(ch.members);
            output.writeObject(ch.capacityFactors);
            output.writeObject(ch.hashFunction);
            output.writeObject(ch.segmentOwners);
        }

        @Override
        public DefaultConsistentHash readObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            int numSegments = unmarshaller.readInt();
            int numOwners = unmarshaller.readInt();
            List members = (List)unmarshaller.readObject();
            Map capacityFactors = (Map)unmarshaller.readObject();
            Hash hash = (Hash)unmarshaller.readObject();
            List[] owners = (List[])unmarshaller.readObject();
            return new DefaultConsistentHash(hash, numOwners, numSegments, members, capacityFactors, owners);
        }

        @Override
        public Integer getId() {
            return 51;
        }

        @Override
        public Set<Class<? extends DefaultConsistentHash>> getTypeClasses() {
            return Collections.singleton(DefaultConsistentHash.class);
        }
    }
}

