/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.DefaultConsistentHash;
import org.infinispan.remoting.transport.Address;

public class SyncConsistentHashFactory
implements ConsistentHashFactory<DefaultConsistentHash> {
    @Override
    public DefaultConsistentHash create(Hash hashFunction, int numOwners, int numSegments, List<Address> members, Map<Address, Float> capacityFactors) {
        this.checkCapacityFactors(members, capacityFactors);
        Builder builder = new Builder(hashFunction, numOwners, numSegments, members, capacityFactors);
        SortedMap<Integer, Address> primarySegments = this.populatePrimarySegments(builder, numSegments);
        if (numSegments >= builder.nodesWithLoad()) {
            this.populateOwnersManySegments(builder, primarySegments);
        } else {
            this.populateOwnersFewSegments(builder, primarySegments);
        }
        return new DefaultConsistentHash(hashFunction, numOwners, numSegments, members, capacityFactors, builder.getAllOwners());
    }

    private void checkCapacityFactors(List<Address> members, Map<Address, Float> capacityFactors) {
        if (capacityFactors != null) {
            float totalCapacity = 0.0f;
            for (Address node : members) {
                Float capacityFactor = capacityFactors.get(node);
                if (capacityFactor == null || capacityFactor.floatValue() < 0.0f) {
                    throw new IllegalArgumentException("Invalid capacity factor for node " + node);
                }
                totalCapacity += capacityFactor.floatValue();
            }
            if (totalCapacity == 0.0f) {
                throw new IllegalArgumentException("There must be at least one node with a non-zero capacity factor");
            }
        }
    }

    protected void populateOwnersFewSegments(Builder builder, SortedMap<Integer, Address> primarySegments) {
        int actualNumOwners = builder.getActualNumOwners();
        TreeSet<Address> sortedMembers = new TreeSet<Address>(builder.getSortedMembers());
        block0: for (Map.Entry<Integer, Address> e : primarySegments.entrySet()) {
            Integer segment = e.getKey();
            Address primaryOwner = e.getValue();
            List<Address> owners = builder.getOwners(segment);
            owners.add(primaryOwner);
            if (owners.size() >= actualNumOwners) continue;
            for (Address a : sortedMembers.tailSet(primaryOwner, false)) {
                if (owners.size() >= actualNumOwners) break;
                if (!(builder.getCapacityFactor(a) > 0.0f) || owners.contains(a)) continue;
                owners.add(a);
            }
            for (Address a : sortedMembers.headSet(primaryOwner, false)) {
                if (owners.size() >= actualNumOwners) continue block0;
                if (!(builder.getCapacityFactor(a) > 0.0f) || owners.contains(a)) continue;
                owners.add(a);
            }
        }
    }

    protected int normalizedHash(Hash hashFunction, int hashcode) {
        return hashFunction.hash(hashcode) & Integer.MAX_VALUE;
    }

    protected void populateOwnersManySegments(Builder builder, SortedMap<Integer, Address> primarySegments) {
        int actualNumOwners = builder.getActualNumOwners();
        block0: for (int segment = 0; segment < builder.getNumSegments(); ++segment) {
            List<Address> owners = builder.getOwners(segment);
            for (Address a : primarySegments.tailMap(segment).values()) {
                if (owners.size() >= actualNumOwners) break;
                if (owners.contains(a)) continue;
                owners.add(a);
            }
            if (owners.size() >= actualNumOwners) continue;
            for (Address a : primarySegments.headMap(segment).values()) {
                if (owners.size() >= actualNumOwners) continue block0;
                if (owners.contains(a)) continue;
                owners.add(a);
            }
        }
    }

    private SortedMap<Integer, Address> populatePrimarySegments(Builder builder, int numSegments) {
        int collisions = 0;
        List<Address> sortedMembers = builder.getSortedMembers();
        int nodesWithLoad = builder.nodesWithLoad();
        int numNodes = sortedMembers.size();
        float maxCapacityFactor = 1.0f;
        float totalCapacity = 0.0f;
        for (Address member : sortedMembers) {
            Float capacityFactor = Float.valueOf(builder.getCapacityFactor(member));
            if (capacityFactor.floatValue() > maxCapacityFactor) {
                maxCapacityFactor = capacityFactor.floatValue();
            }
            totalCapacity += capacityFactor.floatValue();
        }
        double totalVirtualNodes = (double)nodesWithLoad * Math.sqrt(numSegments);
        HashMap<Address, Integer> virtualNodeCounts = new HashMap<Address, Integer>(numNodes);
        for (Address member : sortedMembers) {
            Float capacityFactor = Float.valueOf(builder.getCapacityFactor(member));
            int vn = 0;
            if (capacityFactor.floatValue() > 0.0f) {
                vn = (int)Math.round((double)(capacityFactor.floatValue() / totalCapacity) * totalVirtualNodes + 1.0);
            }
            virtualNodeCounts.put(member, vn);
        }
        HashMap<Integer, Address> primarySegments = new HashMap<Integer, Address>();
        int virtualNode = 0;
        while ((double)virtualNode < totalVirtualNodes) {
            block3: for (Address member : sortedMembers) {
                if (virtualNode >= (Integer)virtualNodeCounts.get(member)) continue;
                int virtualNodeHash = this.normalizedHash(builder.getHashFunction(), member.hashCode());
                if (virtualNode != 0) {
                    virtualNodeHash = this.normalizedHash(builder.getHashFunction(), virtualNodeHash + virtualNode);
                }
                int initSegment = virtualNodeHash / builder.getSegmentSize();
                for (int i = 0; i < numSegments; ++i) {
                    int segment = (initSegment + i) % numSegments;
                    if (primarySegments.containsKey(segment)) continue;
                    primarySegments.put(segment, member);
                    if (segment == initSegment) continue block3;
                    ++collisions;
                    continue block3;
                }
            }
            if (primarySegments.size() >= numSegments) break;
            ++virtualNode;
        }
        return new TreeMap<Integer, Address>(primarySegments);
    }

    @Override
    public DefaultConsistentHash updateMembers(DefaultConsistentHash baseCH, List<Address> newMembers, Map<Address, Float> actualCapacityFactors) {
        boolean sameCapacityFactors;
        this.checkCapacityFactors(newMembers, actualCapacityFactors);
        boolean bl = actualCapacityFactors == null ? baseCH.getCapacityFactors() == null : (sameCapacityFactors = actualCapacityFactors.equals(baseCH.getCapacityFactors()));
        if (newMembers.equals(baseCH.getMembers()) && sameCapacityFactors) {
            return baseCH;
        }
        int numSegments = baseCH.getNumSegments();
        int numOwners = baseCH.getNumOwners();
        HashSet<Address> leavers = new HashSet<Address>(baseCH.getMembers());
        leavers.removeAll(newMembers);
        ConsistentHash rebalancedCH = null;
        List[] newSegmentOwners = new List[numSegments];
        for (int i = 0; i < numSegments; ++i) {
            ArrayList<Address> owners = new ArrayList<Address>(baseCH.locateOwnersForSegment(i));
            owners.removeAll(leavers);
            if (!owners.isEmpty()) {
                newSegmentOwners[i] = owners;
                continue;
            }
            if (rebalancedCH == null) {
                rebalancedCH = this.create(baseCH.getHashFunction(), numOwners, numSegments, (List)newMembers, (Map)actualCapacityFactors);
            }
            newSegmentOwners[i] = rebalancedCH.locateOwnersForSegment(i);
        }
        return new DefaultConsistentHash(baseCH.getHashFunction(), numOwners, numSegments, newMembers, actualCapacityFactors, newSegmentOwners);
    }

    @Override
    public DefaultConsistentHash rebalance(DefaultConsistentHash baseCH) {
        ConsistentHash rebalancedCH = this.create(baseCH.getHashFunction(), baseCH.getNumOwners(), baseCH.getNumSegments(), (List)baseCH.getMembers(), (Map)baseCH.getCapacityFactors());
        if (((DefaultConsistentHash)rebalancedCH).equals(baseCH)) {
            return baseCH;
        }
        return rebalancedCH;
    }

    @Override
    public DefaultConsistentHash union(DefaultConsistentHash ch1, DefaultConsistentHash ch2) {
        return ch1.union(ch2);
    }

    public static class Externalizer
    extends AbstractExternalizer<SyncConsistentHashFactory> {
        @Override
        public void writeObject(ObjectOutput output, SyncConsistentHashFactory chf) {
        }

        @Override
        public SyncConsistentHashFactory readObject(ObjectInput unmarshaller) {
            return new SyncConsistentHashFactory();
        }

        @Override
        public Integer getId() {
            return 93;
        }

        @Override
        public Set<Class<? extends SyncConsistentHashFactory>> getTypeClasses() {
            return Collections.singleton(SyncConsistentHashFactory.class);
        }
    }

    protected static class Builder {
        private final Hash hashFunction;
        private final int numOwners;
        private final Map<Address, Float> capacityFactors;
        private final int actualNumOwners;
        private final int numSegments;
        private final List<Address> sortedMembers;
        private final int segmentSize;
        private final List<Address>[] segmentOwners;

        private Builder(Hash hashFunction, int numOwners, int numSegments, List<Address> members, Map<Address, Float> capacityFactors) {
            this.hashFunction = hashFunction;
            this.numSegments = numSegments;
            this.numOwners = numOwners;
            this.capacityFactors = capacityFactors;
            this.actualNumOwners = Math.min(numOwners, members.size());
            this.sortedMembers = this.sort(members, capacityFactors);
            this.segmentSize = (int)Math.ceil(2.147483647E9 / (double)numSegments);
            this.segmentOwners = new List[numSegments];
            for (int i = 0; i < numSegments; ++i) {
                this.segmentOwners[i] = new ArrayList<Address>(this.actualNumOwners);
            }
        }

        public Hash getHashFunction() {
            return this.hashFunction;
        }

        public int getNumOwners() {
            return this.numOwners;
        }

        public int getActualNumOwners() {
            return this.actualNumOwners;
        }

        public int getNumSegments() {
            return this.numSegments;
        }

        public List<Address> getSortedMembers() {
            return this.sortedMembers;
        }

        public int getSegmentSize() {
            return this.segmentSize;
        }

        public List<Address>[] getAllOwners() {
            return this.segmentOwners;
        }

        public List<Address> getOwners(int i) {
            return this.segmentOwners[i];
        }

        public float getCapacityFactor(Address node) {
            return this.capacityFactors != null ? this.capacityFactors.get(node).floatValue() : 1.0f;
        }

        private List<Address> sort(List<Address> members, final Map<Address, Float> capacityFactors) {
            ArrayList<Address> result = new ArrayList<Address>(members);
            Collections.sort(result, new Comparator<Address>(){

                @Override
                public int compare(Address o1, Address o2) {
                    int capacityComparison = capacityFactors != null ? ((Float)capacityFactors.get(o1)).compareTo((Float)capacityFactors.get(o2)) : 0;
                    return capacityComparison != 0 ? -capacityComparison : o1.compareTo(o2);
                }
            });
            return result;
        }

        private int nodesWithLoad() {
            int nodesWithLoad = this.sortedMembers.size();
            if (this.capacityFactors != null) {
                nodesWithLoad = 0;
                for (Address node : this.sortedMembers) {
                    if (this.capacityFactors.get(node).floatValue() == 0.0f) continue;
                    ++nodesWithLoad;
                }
            }
            return nodesWithLoad;
        }
    }
}

