/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.distribution.ch.DefaultConsistentHashFactory;
import org.infinispan.distribution.topologyaware.TopologyInfo;
import org.infinispan.distribution.topologyaware.TopologyLevel;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.TopologyAwareAddress;

public class TopologyAwareConsistentHashFactory
extends DefaultConsistentHashFactory {
    @Override
    protected void addBackupOwners(DefaultConsistentHashFactory.Builder builder) {
        TopologyInfo topologyInfo = new TopologyInfo(builder.getMembers(), builder.getCapacityFactors());
        this.removeExtraBackupOwners(builder);
        this.addBackupOwnersForLevel(builder, topologyInfo, TopologyLevel.SITE);
        this.addBackupOwnersForLevel(builder, topologyInfo, TopologyLevel.RACK);
        this.addBackupOwnersForLevel(builder, topologyInfo, TopologyLevel.MACHINE);
        this.addBackupOwnersForLevel(builder, topologyInfo, TopologyLevel.NODE);
        this.replaceBackupOwnersForLevel(builder, topologyInfo, TopologyLevel.SITE);
        this.replaceBackupOwnersForLevel(builder, topologyInfo, TopologyLevel.RACK);
        this.replaceBackupOwnersForLevel(builder, topologyInfo, TopologyLevel.MACHINE);
        this.replaceBackupOwnerNoLevel(builder, topologyInfo);
    }

    private void addBackupOwnersForLevel(DefaultConsistentHashFactory.Builder builder, TopologyInfo topologyInfo, TopologyLevel level) {
        int extraSegments = 0;
        while (this.doAddBackupOwnersForLevel(builder, topologyInfo, level, extraSegments)) {
            ++extraSegments;
        }
    }

    private boolean doAddBackupOwnersForLevel(DefaultConsistentHashFactory.Builder builder, TopologyInfo topologyInfo, TopologyLevel level, int extraSegments) {
        boolean sufficientOwners = true;
        for (int segment = 0; segment < builder.getNumSegments(); ++segment) {
            List<Address> owners = builder.getOwners(segment);
            if (owners.size() >= builder.getActualNumOwners()) continue;
            int maxDistinctLocations = topologyInfo.getDistinctLocationsCount(level, builder.getActualNumOwners());
            TopologyInfo ownersInfo = new TopologyInfo(owners, builder.getCapacityFactors());
            int distinctLocations = ownersInfo.getDistinctLocationsCount(level, builder.getActualNumOwners());
            if (distinctLocations == maxDistinctLocations) continue;
            float totalCapacity = topologyInfo.computeTotalCapacity(builder.getMembers(), builder.getCapacityFactors());
            for (Address candidate : builder.getMembers()) {
                int nodeExtraSegments = (int)((float)extraSegments * builder.getCapacityFactor(candidate) / totalCapacity);
                int maxSegments = topologyInfo.computeExpectedSegments(builder.getNumSegments(), builder.getActualNumOwners(), candidate) + nodeExtraSegments;
                if (builder.getOwned(candidate) >= maxSegments || owners.contains(candidate) || this.locationIsDuplicate(owners, candidate, level)) continue;
                builder.addOwner(segment, candidate);
                ++distinctLocations;
                if (owners.size() < builder.getActualNumOwners()) continue;
                break;
            }
            if (distinctLocations >= maxDistinctLocations || owners.size() >= builder.getActualNumOwners()) continue;
            sufficientOwners = false;
        }
        return !sufficientOwners;
    }

    private void replaceBackupOwnersForLevel(DefaultConsistentHashFactory.Builder builder, TopologyInfo topologyInfo, TopologyLevel level) {
        int extraSegments = 0;
        while (this.doReplaceBackupOwnersForLevel(builder, topologyInfo, level, extraSegments)) {
            ++extraSegments;
        }
    }

    private boolean doReplaceBackupOwnersForLevel(DefaultConsistentHashFactory.Builder builder, TopologyInfo topologyInfo, TopologyLevel level, int extraSegments) {
        boolean sufficientLocations = true;
        for (int segment = 0; segment < builder.getNumSegments(); ++segment) {
            List<Address> owners = builder.getOwners(segment);
            int maxDistinctLocations = topologyInfo.getDistinctLocationsCount(level, builder.getActualNumOwners());
            TopologyInfo ownersInfo = new TopologyInfo(owners, builder.getCapacityFactors());
            int distinctLocations = ownersInfo.getDistinctLocationsCount(level, builder.getActualNumOwners());
            if (distinctLocations == maxDistinctLocations) continue;
            float totalCapacity = topologyInfo.computeTotalCapacity(builder.getMembers(), builder.getCapacityFactors());
            block1: for (int i = owners.size() - 1; i >= 1; --i) {
                Address owner = owners.get(i);
                if (!this.locationIsDuplicate(owners, owner, level)) continue;
                for (Address candidate : builder.getMembers()) {
                    int expectedSegments = topologyInfo.computeExpectedSegments(builder.getNumSegments(), builder.getActualNumOwners(), candidate);
                    int nodeExtraSegments = (int)((float)extraSegments * builder.getCapacityFactor(candidate) / totalCapacity);
                    if (builder.getOwned(candidate) >= expectedSegments + nodeExtraSegments || owners.contains(candidate) || this.locationIsDuplicate(owners, candidate, level)) continue;
                    builder.addOwner(segment, candidate);
                    builder.removeOwner(segment, owner);
                    ++distinctLocations;
                    continue block1;
                }
            }
            if (distinctLocations >= maxDistinctLocations) continue;
            sufficientLocations = false;
        }
        return !sufficientLocations;
    }

    private void replaceBackupOwnerNoLevel(DefaultConsistentHashFactory.Builder builder, TopologyInfo topologyInfo) {
        this.doReplaceBackupOwnersNoLevel(builder, topologyInfo, -1, 0);
        this.doReplaceBackupOwnersNoLevel(builder, topologyInfo, -1, -1);
        this.doReplaceBackupOwnersNoLevel(builder, topologyInfo, 0, 0);
    }

    private void doReplaceBackupOwnersNoLevel(DefaultConsistentHashFactory.Builder builder, TopologyInfo topologyInfo, int minSegmentsDiff, int maxSegmentsDiff) {
        for (int ownerIdx = builder.getActualNumOwners() - 1; ownerIdx >= 1; --ownerIdx) {
            block1: for (int segment = 0; segment < builder.getNumSegments(); ++segment) {
                List<Address> owners = builder.getOwners(segment);
                Address owner = owners.get(ownerIdx);
                int maxSegments = topologyInfo.computeExpectedSegments(builder.getNumSegments(), builder.getActualNumOwners(), owner) + maxSegmentsDiff;
                if (builder.getOwned(owner) <= maxSegments) continue;
                for (Address candidate : builder.getMembers()) {
                    int minSegments = topologyInfo.computeExpectedSegments(builder.getNumSegments(), builder.getActualNumOwners(), candidate) + minSegmentsDiff;
                    if (builder.getOwned(candidate) >= minSegments || owners.contains(candidate) || !this.maintainsDiversity(owners, candidate, owner)) continue;
                    builder.addOwner(segment, candidate);
                    builder.removeOwner(segment, owner);
                    continue block1;
                }
            }
        }
    }

    private Object getLocationId(Address address, TopologyLevel level) {
        Object locationId;
        TopologyAwareAddress taa = (TopologyAwareAddress)address;
        switch (level) {
            case SITE: {
                locationId = "" + taa.getSiteId();
                break;
            }
            case RACK: {
                locationId = taa.getSiteId() + "|" + taa.getRackId();
                break;
            }
            case MACHINE: {
                locationId = taa.getSiteId() + "|" + taa.getRackId() + "|" + taa.getMachineId();
                break;
            }
            case NODE: {
                locationId = address;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown level: " + (Object)((Object)level));
            }
        }
        return locationId;
    }

    private boolean locationIsDuplicate(List<Address> addresses, Address target, TopologyLevel level) {
        Object targetLocationId = this.getLocationId(target, level);
        for (Address address : addresses) {
            if (address == target || !this.getLocationId(address, level).equals(targetLocationId)) continue;
            return true;
        }
        return false;
    }

    private boolean maintainsDiversity(List<Address> owners, Address candidate, Address replaced) {
        return this.maintainsDiversity(owners, candidate, replaced, TopologyLevel.SITE) && this.maintainsDiversity(owners, candidate, replaced, TopologyLevel.RACK) && this.maintainsDiversity(owners, candidate, replaced, TopologyLevel.MACHINE);
    }

    private boolean maintainsDiversity(List<Address> owners, Address candidate, Address replaced, TopologyLevel machine) {
        HashSet<Object> oldMachines = new HashSet<Object>(owners.size());
        HashSet<Object> newMachines = new HashSet<Object>(owners.size());
        newMachines.add(this.getLocationId(candidate, machine));
        for (Address node : owners) {
            oldMachines.add(this.getLocationId(node, machine));
            if (node.equals(replaced)) continue;
            newMachines.add(this.getLocationId(node, machine));
        }
        return newMachines.size() >= oldMachines.size();
    }

    public static class Externalizer
    extends AbstractExternalizer<TopologyAwareConsistentHashFactory> {
        @Override
        public void writeObject(ObjectOutput output, TopologyAwareConsistentHashFactory chf) {
        }

        @Override
        public TopologyAwareConsistentHashFactory readObject(ObjectInput unmarshaller) {
            return new TopologyAwareConsistentHashFactory();
        }

        @Override
        public Integer getId() {
            return 94;
        }

        @Override
        public Set<Class<? extends TopologyAwareConsistentHashFactory>> getTypeClasses() {
            return Collections.singleton(TopologyAwareConsistentHashFactory.class);
        }
    }
}

