/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.executors.ExecutorFactory;
import org.infinispan.executors.LazyInitializingBlockingTaskAwareExecutorService;
import org.infinispan.executors.LazyInitializingExecutorService;
import org.infinispan.executors.LazyInitializingScheduledExecutorService;
import org.infinispan.executors.ScheduledExecutorFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.KnownComponentNames;
import org.infinispan.factories.NamedComponentFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.util.concurrent.BlockingTaskAwareExecutorService;

@DefaultFactoryFor(classes={ExecutorService.class, Executor.class, ScheduledExecutorService.class, BlockingTaskAwareExecutorService.class})
public class NamedExecutorsFactory
extends NamedComponentFactory
implements AutoInstantiableFactory {
    private ExecutorService notificationExecutor;
    private ExecutorService asyncTransportExecutor;
    private ExecutorService persistenceExecutor;
    private BlockingTaskAwareExecutorService remoteCommandsExecutor;
    private ScheduledExecutorService evictionExecutor;
    private ScheduledExecutorService asyncReplicationExecutor;
    private BlockingTaskAwareExecutorService totalOrderExecutor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T construct(Class<T> componentType, String componentName) {
        try {
            String nodeName = this.globalConfiguration.transport().nodeName();
            if (componentName.equals("org.infinispan.executors.notification")) {
                NamedExecutorsFactory namedExecutorsFactory = this;
                synchronized (namedExecutorsFactory) {
                    if (this.notificationExecutor == null) {
                        this.notificationExecutor = this.buildAndConfigureExecutorService(this.globalConfiguration.asyncListenerExecutor().factory(), this.globalConfiguration.asyncListenerExecutor().properties(), componentName, nodeName);
                    }
                }
                return (T)this.notificationExecutor;
            }
            if (componentName.equals("org.infinispan.executors.persistence")) {
                NamedExecutorsFactory namedExecutorsFactory = this;
                synchronized (namedExecutorsFactory) {
                    if (this.persistenceExecutor == null) {
                        this.persistenceExecutor = this.buildAndConfigureExecutorService(this.globalConfiguration.persistenceExecutor().factory(), this.globalConfiguration.persistenceExecutor().properties(), componentName, nodeName);
                    }
                }
                return (T)this.persistenceExecutor;
            }
            if (componentName.equals("org.infinispan.executors.transport")) {
                NamedExecutorsFactory namedExecutorsFactory = this;
                synchronized (namedExecutorsFactory) {
                    if (this.asyncTransportExecutor == null) {
                        this.asyncTransportExecutor = this.buildAndConfigureExecutorService(this.globalConfiguration.asyncTransportExecutor().factory(), this.globalConfiguration.asyncTransportExecutor().properties(), componentName, nodeName);
                    }
                }
                return (T)this.asyncTransportExecutor;
            }
            if (componentName.equals("org.infinispan.executors.eviction")) {
                NamedExecutorsFactory namedExecutorsFactory = this;
                synchronized (namedExecutorsFactory) {
                    if (this.evictionExecutor == null) {
                        this.evictionExecutor = this.buildAndConfigureScheduledExecutorService(this.globalConfiguration.evictionScheduledExecutor().factory(), this.globalConfiguration.evictionScheduledExecutor().properties(), componentName, nodeName);
                    }
                }
                return (T)this.evictionExecutor;
            }
            if (componentName.equals("org.infinispan.executors.replicationQueue")) {
                NamedExecutorsFactory namedExecutorsFactory = this;
                synchronized (namedExecutorsFactory) {
                    if (this.asyncReplicationExecutor == null) {
                        this.asyncReplicationExecutor = this.buildAndConfigureScheduledExecutorService(this.globalConfiguration.replicationQueueScheduledExecutor().factory(), this.globalConfiguration.replicationQueueScheduledExecutor().properties(), componentName, nodeName);
                    }
                }
                return (T)this.asyncReplicationExecutor;
            }
            if (componentName.equals("org.infinispan.executors.remote")) {
                NamedExecutorsFactory namedExecutorsFactory = this;
                synchronized (namedExecutorsFactory) {
                    if (this.remoteCommandsExecutor == null) {
                        this.remoteCommandsExecutor = this.buildAndConfigureBlockingTaskAwareExecutorService(this.globalConfiguration.remoteCommandsExecutor().factory(), this.globalConfiguration.remoteCommandsExecutor().properties(), componentName, nodeName);
                    }
                }
                return (T)this.remoteCommandsExecutor;
            }
            if (componentName.equals("org.infinispan.executors.totalOrderExecutor")) {
                NamedExecutorsFactory namedExecutorsFactory = this;
                synchronized (namedExecutorsFactory) {
                    if (this.totalOrderExecutor == null) {
                        this.totalOrderExecutor = this.buildAndConfigureBlockingTaskAwareExecutorService(this.globalConfiguration.totalOrderExecutor().factory(), this.globalConfiguration.totalOrderExecutor().properties(), componentName, nodeName);
                    }
                }
                return (T)this.totalOrderExecutor;
            }
            throw new CacheConfigurationException("Unknown named executor " + componentName);
        }
        catch (CacheConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CacheConfigurationException("Unable to instantiate ExecutorFactory for named component " + componentName, e);
        }
    }

    @Stop(priority=999)
    public void stop() {
        if (this.remoteCommandsExecutor != null) {
            this.remoteCommandsExecutor.shutdownNow();
        }
        if (this.notificationExecutor != null) {
            this.notificationExecutor.shutdownNow();
        }
        if (this.persistenceExecutor != null) {
            this.persistenceExecutor.shutdownNow();
        }
        if (this.asyncTransportExecutor != null) {
            this.asyncTransportExecutor.shutdownNow();
        }
        if (this.asyncReplicationExecutor != null) {
            this.asyncReplicationExecutor.shutdownNow();
        }
        if (this.evictionExecutor != null) {
            this.evictionExecutor.shutdownNow();
        }
        if (this.totalOrderExecutor != null) {
            this.totalOrderExecutor.shutdownNow();
        }
    }

    private ExecutorService buildAndConfigureExecutorService(ExecutorFactory f, Properties p, String componentName, String nodeName) throws Exception {
        Properties props = new Properties(p);
        if (p != null && !p.isEmpty()) {
            props.putAll((Map<?, ?>)p);
        }
        this.setThreadSuffix(nodeName, props);
        this.setComponentName(componentName, props);
        this.setDefaultThreads(KnownComponentNames.getDefaultThreads(componentName), props);
        this.setDefaultThreadPrio(KnownComponentNames.getDefaultThreadPrio(componentName), props);
        this.setDefaultQueueSize(KnownComponentNames.getDefaultQueueSize(componentName), props);
        return new LazyInitializingExecutorService(f, props);
    }

    private ScheduledExecutorService buildAndConfigureScheduledExecutorService(ScheduledExecutorFactory f, Properties p, String componentName, String nodeName) throws Exception {
        Properties props = new Properties();
        if (p != null && !p.isEmpty()) {
            props.putAll((Map<?, ?>)p);
        }
        this.setThreadSuffix(nodeName, props);
        this.setComponentName(componentName, props);
        this.setDefaultThreadPrio(KnownComponentNames.getDefaultThreadPrio(componentName), props);
        return new LazyInitializingScheduledExecutorService(f, props);
    }

    private BlockingTaskAwareExecutorService buildAndConfigureBlockingTaskAwareExecutorService(ExecutorFactory f, Properties p, String componentName, String nodeName) throws Exception {
        Properties props = new Properties();
        if (p != null && !p.isEmpty()) {
            props.putAll((Map<?, ?>)p);
        }
        this.setThreadSuffix(nodeName, props);
        this.setComponentName(componentName, props);
        this.setDefaultThreads(KnownComponentNames.getDefaultThreads(componentName), props);
        this.setDefaultThreadPrio(KnownComponentNames.getDefaultThreadPrio(componentName), props);
        this.setDefaultQueueSize(KnownComponentNames.getDefaultQueueSize(componentName), props);
        return new LazyInitializingBlockingTaskAwareExecutorService(f, props, this.globalComponentRegistry.getTimeService());
    }

    private void setThreadSuffix(String nodeName, Properties props) {
        if (nodeName != null && !nodeName.isEmpty()) {
            props.setProperty("threadNameSuffix", ',' + nodeName);
        }
    }

    private void setDefaultQueueSize(int queueSize, Properties props) {
        if (!props.containsKey("queueSize")) {
            props.setProperty("queueSize", String.valueOf(queueSize));
        }
    }

    private void setDefaultThreadPrio(int prio, Properties props) {
        if (!props.containsKey("threadPriority")) {
            props.setProperty("threadPriority", String.valueOf(prio));
        }
    }

    private void setDefaultThreads(int numThreads, Properties props) {
        if (!props.containsKey("maxThreads")) {
            props.setProperty("maxThreads", String.valueOf(numThreads));
        }
    }

    private void setComponentName(String cn, Properties p) {
        if (cn != null) {
            p.setProperty("componentName", this.format(cn));
        }
    }

    private String format(String cn) {
        int dotIndex = cn.lastIndexOf(".");
        int dotIndexPlusOne = dotIndex + 1;
        String cname = cn;
        if (dotIndexPlusOne == cn.length()) {
            cname = this.format(cn.substring(0, cn.length() - 1));
        } else {
            if (dotIndex > -1 && cn.length() > dotIndexPlusOne) {
                cname = cn.substring(dotIndexPlusOne);
            }
            cname = cname + "-thread";
        }
        return cname;
    }
}

