/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.Arrays;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.EvictionConfiguration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.eviction.ActivationManager;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.CacheLoaderInterceptor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ActivationInterceptor
extends CacheLoaderInterceptor {
    private static final Log log = LogFactory.getLog(ActivationInterceptor.class);
    private Configuration cfg;
    private boolean isManualEviction;
    private ActivationManager activationManager;
    private ClusteringDependentLogic cdl;
    private DataContainer dataContainer;

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void inject(Configuration cfg, ActivationManager activationManager, ClusteringDependentLogic cdl, DataContainer dataContainer) {
        this.cfg = cfg;
        this.activationManager = activationManager;
        this.cdl = cdl;
        this.dataContainer = dataContainer;
    }

    @Start(priority=15)
    public void start() {
        EvictionConfiguration evictCfg = this.cfg.eviction();
        this.isManualEviction = evictCfg.strategy() == EvictionStrategy.NONE || evictCfg.maxEntries() < 0;
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        for (Object key : command.getAffectedKeys()) {
            this.loadIfNeeded(ctx, key, false, command);
        }
        return super.visitPutMapCommand(ctx, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Boolean loadIfNeeded(InvocationContext ctx, Object key, boolean isRetrieval, FlagAffectedCommand cmd) throws Throwable {
        CacheEntry entry = ctx.lookupEntry(key);
        if (entry != null && !entry.isNull() && entry.getValue() != null) {
            return null;
        }
        try {
            CacheEntry e;
            while (!this.cdl.lock(key, false)) {
            }
            InternalCacheEntry ice = this.dataContainer.get(key);
            if (ice != null) {
                if (cmd instanceof ApplyDeltaCommand) {
                    ctx.putLookedUpEntry(key, ice);
                    this.entryFactory.wrapEntryForDelta(ctx, key, ((ApplyDeltaCommand)cmd).getDelta());
                } else {
                    this.entryFactory.wrapEntryForPut(ctx, key, ice, false, cmd, false);
                }
                Boolean bl = null;
                return bl;
            }
            Boolean loaded = super.loadIfNeeded(ctx, key, isRetrieval, cmd);
            if (loaded == Boolean.TRUE && this.enabled && this.isManualEviction && (e = ctx.lookupEntry(key)) != null && e.isLoaded()) {
                this.cdl.commitEntry(e, null, cmd, ctx);
                this.removeFromStoreIfNeeded(key);
            }
            Boolean bl = loaded;
            return bl;
        }
        finally {
            this.cdl.unlock(key);
        }
    }

    @Override
    protected void sendNotification(Object key, Object value, boolean pre, InvocationContext ctx, FlagAffectedCommand cmd) {
        super.sendNotification(key, value, pre, ctx, cmd);
        this.notifier.notifyCacheEntryActivated(key, value, pre, ctx, cmd);
    }

    private void removeFromStoreIfNeeded(Object ... keys) {
        if (this.enabled && this.isManualEviction) {
            if (log.isTraceEnabled()) {
                log.tracef("Remove from store keys=%s, if needed", (Object)Arrays.toString(keys));
            }
            for (Object key : keys) {
                this.activationManager.activate(key);
            }
        }
    }
}

