/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.base;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.remoting.responses.IgnoreExtraResponsesValidityFilter;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SelfDeliverFilter;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptionsBuilder;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.StateConsumer;
import org.infinispan.transaction.LocalTransaction;

public abstract class BaseRpcInterceptor
extends CommandInterceptor {
    protected RpcManager rpcManager;
    private StateConsumer stateConsumer;
    protected boolean defaultSynchronous;

    @Inject
    public void inject(RpcManager rpcManager, StateConsumer stateConsumer) {
        this.rpcManager = rpcManager;
        this.stateConsumer = stateConsumer;
    }

    @Start
    public void init() {
        this.defaultSynchronous = this.cacheConfiguration.clustering().cacheMode().isSynchronous();
    }

    protected final boolean isSynchronous(FlagAffectedCommand command) {
        if (command.hasFlag(Flag.FORCE_SYNCHRONOUS)) {
            return true;
        }
        if (command.hasFlag(Flag.FORCE_ASYNCHRONOUS)) {
            return false;
        }
        return this.defaultSynchronous;
    }

    protected final boolean isLocalModeForced(FlagAffectedCommand command) {
        if (command.hasFlag(Flag.CACHE_MODE_LOCAL)) {
            if (this.getLog().isTraceEnabled()) {
                this.getLog().trace("LOCAL mode forced on invocation.  Suppressing clustered events.");
            }
            return true;
        }
        return false;
    }

    protected boolean shouldInvokeRemoteTxCommand(TxInvocationContext ctx) {
        boolean shouldInvokeRemotely;
        if (!ctx.isOriginLocal()) {
            return false;
        }
        LocalTxInvocationContext localCtx = (LocalTxInvocationContext)ctx;
        boolean bl = shouldInvokeRemotely = ctx.hasModifications() || !localCtx.getRemoteLocksAcquired().isEmpty() || localCtx.getCacheTransaction().getTopologyId() != this.rpcManager.getTopologyId();
        if (this.getLog().isTraceEnabled()) {
            this.getLog().tracef("Should invoke remotely? %b. hasModifications=%b, hasRemoteLocksAcquired=%b", (Object)shouldInvokeRemotely, (Object)ctx.hasModifications(), (Object)(!localCtx.getRemoteLocksAcquired().isEmpty() ? 1 : 0));
        }
        return shouldInvokeRemotely;
    }

    protected static void transactionRemotelyPrepared(TxInvocationContext ctx) {
        if (ctx.isOriginLocal()) {
            ((LocalTransaction)ctx.getCacheTransaction()).markPrepareSent();
        }
    }

    protected static void totalOrderTxCommit(TxInvocationContext ctx) {
        if (ctx.isOriginLocal()) {
            ((LocalTransaction)ctx.getCacheTransaction()).markCommitOrRollbackSent();
        }
    }

    protected static void totalOrderTxRollback(TxInvocationContext ctx) {
        if (ctx.isOriginLocal()) {
            ((LocalTransaction)ctx.getCacheTransaction()).markCommitOrRollbackSent();
        }
    }

    protected static boolean shouldTotalOrderRollbackBeInvokedRemotely(TxInvocationContext ctx) {
        return ctx.isOriginLocal() && ((LocalTransaction)ctx.getCacheTransaction()).isPrepareSent() && !((LocalTransaction)ctx.getCacheTransaction()).isCommitOrRollbackSent();
    }

    protected final Map<Address, Response> totalOrderAnycastPrepare(Collection<Address> recipients, PrepareCommand prepareCommand, ResponseFilter responseFilter) {
        HashSet<Address> realRecipients = new HashSet<Address>(recipients);
        realRecipients.add(this.rpcManager.getAddress());
        return this.internalTotalOrderPrepare(realRecipients, prepareCommand, responseFilter);
    }

    protected final Map<Address, Response> totalOrderBroadcastPrepare(PrepareCommand prepareCommand, ResponseFilter responseFilter) {
        return this.internalTotalOrderPrepare(null, prepareCommand, responseFilter);
    }

    private Map<Address, Response> internalTotalOrderPrepare(Collection<Address> recipients, PrepareCommand prepareCommand, ResponseFilter responseFilter) {
        if (this.defaultSynchronous) {
            RpcOptionsBuilder builder = this.rpcManager.getRpcOptionsBuilder(ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS, false);
            if (responseFilter != null) {
                builder.responseFilter(responseFilter);
            } else {
                builder.responseFilter(this.getIgnoreExtraResponseFilter(recipients));
            }
            builder.totalOrder(true);
            return this.rpcManager.invokeRemotely(recipients, (ReplicableCommand)prepareCommand, builder.build());
        }
        RpcOptionsBuilder builder = this.rpcManager.getRpcOptionsBuilder(ResponseMode.getAsyncResponseMode(this.cacheConfiguration), false);
        builder.totalOrder(true);
        return this.rpcManager.invokeRemotely(recipients, (ReplicableCommand)prepareCommand, builder.build());
    }

    protected final boolean isSyncCommitPhase() {
        return this.cacheConfiguration.transaction().syncCommitPhase();
    }

    protected final ResponseFilter getSelfDeliverFilter() {
        return new SelfDeliverFilter(this.rpcManager.getAddress());
    }

    protected final ResponseFilter getIgnoreExtraResponseFilter(Collection<Address> recipients) {
        HashSet<Address> liveMembers = new HashSet<Address>(this.stateConsumer.getCacheTopology().getMembers());
        if (recipients != null) {
            liveMembers.retainAll(recipients);
        }
        return new IgnoreExtraResponsesValidityFilter(liveMembers, this.rpcManager.getAddress(), false);
    }
}

