/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.totalorder;

import java.util.Collection;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.distribution.TxDistributionInterceptor;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TotalOrderDistributionInterceptor
extends TxDistributionInterceptor {
    private static final Log log = LogFactory.getLog(TotalOrderDistributionInterceptor.class);

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        if (Configurations.isOnePhaseTotalOrderCommit(this.cacheConfiguration) || !ctx.hasModifications() || !TotalOrderDistributionInterceptor.shouldTotalOrderRollbackBeInvokedRemotely(ctx)) {
            return this.invokeNextInterceptor(ctx, command);
        }
        TotalOrderDistributionInterceptor.totalOrderTxRollback(ctx);
        return super.visitRollbackCommand(ctx, command);
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (Configurations.isOnePhaseTotalOrderCommit(this.cacheConfiguration) || !ctx.hasModifications()) {
            return this.invokeNextInterceptor(ctx, command);
        }
        TotalOrderDistributionInterceptor.totalOrderTxCommit(ctx);
        return super.visitCommitCommand(ctx, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void prepareOnAffectedNodes(TxInvocationContext ctx, PrepareCommand command, Collection<Address> recipients, boolean sync) {
        if (log.isTraceEnabled()) {
            log.tracef("Total Order Anycast transaction %s with Total Order", (Object)command.getGlobalTransaction().globalId());
        }
        if (!ctx.hasModifications()) {
            return;
        }
        if (!ctx.isOriginLocal()) {
            throw new IllegalStateException("Expected a local context while TO-Anycast prepare command");
        }
        try {
            this.totalOrderAnycastPrepare(recipients, command, this.isSyncCommitPhase() ? null : this.getSelfDeliverFilter());
        }
        finally {
            TotalOrderDistributionInterceptor.transactionRemotelyPrepared(ctx);
        }
    }

    @Override
    protected void lockAndWrap(InvocationContext ctx, Object key, InternalCacheEntry ice, FlagAffectedCommand command) throws InterruptedException {
        this.entryFactory.wrapEntryForPut(ctx, key, ice, false, command, true);
    }

    @Override
    protected Log getLog() {
        return log;
    }
}

