/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.totalorder;

import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.interceptors.totalorder.RetryPrepareException;
import org.infinispan.remoting.RemoteException;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.topology.CacheTopology;
import org.infinispan.transaction.RemoteTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TotalOrderStateTransferInterceptor
extends CommandInterceptor {
    private static final Log log = LogFactory.getLog(TotalOrderStateTransferInterceptor.class);
    private StateTransferManager stateTransferManager;

    @Inject
    public void inject(StateTransferManager stateTransferManager) {
        this.stateTransferManager = stateTransferManager;
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (ctx.isOriginLocal()) {
            return this.localPrepare(ctx, command);
        }
        return this.remotePrepare(ctx, command);
    }

    private Object remotePrepare(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        CacheTopology cacheTopology = this.stateTransferManager.getCacheTopology();
        int topologyId = cacheTopology.getTopologyId();
        ((RemoteTransaction)ctx.getCacheTransaction()).setLookedUpEntriesTopology(command.getTopologyId());
        if (log.isTraceEnabled()) {
            log.tracef("Remote transaction received %s. Tx topology id is %s and current topology is is %s", (Object)ctx.getGlobalTransaction().globalId(), (Object)command.getTopologyId(), (Object)topologyId);
        }
        if (command.getTopologyId() < topologyId) {
            if (log.isDebugEnabled()) {
                log.debugf("Transaction %s delivered in new topology Id. Discard it because it should be retransmitted", (Object)ctx.getGlobalTransaction().globalId());
            }
            throw new RetryPrepareException();
        }
        if (command.getTopologyId() > topologyId) {
            throw new IllegalStateException("This should never happen");
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    private Object localPrepare(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        boolean needsToPrepare = true;
        Object retVal = null;
        while (needsToPrepare) {
            try {
                CacheTopology cacheTopology = this.stateTransferManager.getCacheTopology();
                command.setTopologyId(cacheTopology.getTopologyId());
                if (log.isTraceEnabled()) {
                    log.tracef("Local transaction received %s. setting topology Id to %s", (Object)command.getGlobalTransaction().globalId(), (Object)command.getTopologyId());
                }
                retVal = this.invokeNextInterceptor(ctx, command);
                needsToPrepare = false;
            }
            catch (Throwable throwable) {
                needsToPrepare = this.needsToRePrepare(throwable);
                if (log.isDebugEnabled()) {
                    log.tracef("Exception caught while preparing transaction %s (cause = %s). Needs to retransmit? %s", (Object)command.getGlobalTransaction().globalId(), (Object)throwable.getCause(), (Object)needsToPrepare);
                }
                if (needsToPrepare) continue;
                throw throwable;
            }
        }
        return retVal;
    }

    private boolean needsToRePrepare(Throwable throwable) {
        return throwable instanceof RemoteException && throwable.getCause() instanceof RetryPrepareException;
    }
}

