/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import javax.management.ServiceNotFoundException;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.factories.components.JmxAttributeMetadata;
import org.infinispan.factories.components.JmxOperationMetadata;
import org.infinispan.factories.components.JmxOperationParameter;
import org.infinispan.factories.components.ManageableComponentMetadata;
import org.infinispan.jmx.IspnMBeanOperationInfo;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ResourceDMBean
implements DynamicMBean {
    private static final String MBEAN_DESCRITION = "Dynamic MBean Description";
    private static final Log log = LogFactory.getLog(ResourceDMBean.class);
    private static final boolean trace = log.isTraceEnabled();
    private final Object obj;
    private final Class<?> objectClass;
    private final IspnMBeanOperationInfo[] opInfos;
    private final MBeanAttributeInfo[] attInfos;
    private final HashMap<String, InvokableMBeanAttributeInfo> atts = new HashMap(2);
    private final ManageableComponentMetadata mBeanMetadata;
    private static final Map<String, Field> FIELD_CACHE = CollectionFactory.makeConcurrentMap(64);
    private static final Map<String, Method> METHOD_CACHE = CollectionFactory.makeConcurrentMap(64);
    private static final Map<String[], Class<?>[]> PARAM_TYPE_CACHE = CollectionFactory.makeConcurrentMap(64);

    public ResourceDMBean(Object instance, ManageableComponentMetadata mBeanMetadata) throws NoSuchFieldException, ClassNotFoundException {
        if (instance == null) {
            throw new NullPointerException("Cannot make an MBean wrapper for null instance");
        }
        this.obj = instance;
        this.objectClass = instance.getClass();
        this.mBeanMetadata = mBeanMetadata;
        int i = 0;
        this.attInfos = new MBeanAttributeInfo[mBeanMetadata.getAttributeMetadata().size()];
        for (JmxAttributeMetadata attributeMetadata : mBeanMetadata.getAttributeMetadata()) {
            String attributeName = attributeMetadata.getName();
            InvokableMBeanAttributeInfo info = this.toJmxInfo(attributeMetadata);
            if (this.atts.containsKey(attributeName)) {
                throw new IllegalArgumentException("Component " + mBeanMetadata.getName() + " metadata has a duplicate attribute: " + attributeName);
            }
            this.atts.put(attributeName, info);
            this.attInfos[i++] = info.getMBeanAttributeInfo();
            if (!trace) continue;
            log.tracef("Attribute %s [r=%b,w=%b,is=%b,type=%s]", attributeName, info.getMBeanAttributeInfo().isReadable(), info.getMBeanAttributeInfo().isWritable(), info.getMBeanAttributeInfo().isIs(), info.getMBeanAttributeInfo().getType());
        }
        this.opInfos = new IspnMBeanOperationInfo[mBeanMetadata.getOperationMetadata().size()];
        i = 0;
        for (JmxOperationMetadata operation : mBeanMetadata.getOperationMetadata()) {
            IspnMBeanOperationInfo op = this.toJmxInfo(operation);
            this.opInfos[i++] = op;
            if (!trace) continue;
            log.tracef("Operation %s %s", (Object)op.getReturnType(), (Object)op.getName());
        }
    }

    private static Field findField(Class<?> objectClass, String fieldName) throws NoSuchFieldException {
        String key = objectClass.getName() + "#" + fieldName;
        Field f = FIELD_CACHE.get(key);
        if (f == null && (f = ReflectionUtil.getField(fieldName, objectClass)) != null) {
            FIELD_CACHE.put(key, f);
        }
        return f;
    }

    private static Method findSetter(Class<?> objectClass, String fieldName) throws NoSuchFieldException {
        String key = objectClass.getName() + "#s#" + fieldName;
        Method m = METHOD_CACHE.get(key);
        if (m == null && (m = ReflectionUtil.findSetterForField(objectClass, fieldName)) != null) {
            METHOD_CACHE.put(key, m);
        }
        return m;
    }

    private static Method findGetter(Class<?> objectClass, String fieldName) throws NoSuchFieldException {
        String key = objectClass.getName() + "#g#" + fieldName;
        Method m = METHOD_CACHE.get(key);
        if (m == null && (m = ReflectionUtil.findGetterForField(objectClass, fieldName)) != null) {
            METHOD_CACHE.put(key, m);
        }
        return m;
    }

    private InvokableMBeanAttributeInfo toJmxInfo(JmxAttributeMetadata attributeMetadata) throws NoSuchFieldException {
        Field field;
        if (!attributeMetadata.isUseSetter() && (field = ResourceDMBean.findField(this.objectClass, attributeMetadata.getName())) != null) {
            return new InvokableFieldBasedMBeanAttributeInfo(attributeMetadata.getName(), attributeMetadata.getType(), attributeMetadata.getDescription(), true, attributeMetadata.isWritable(), attributeMetadata.isIs(), field, this);
        }
        Method setter = attributeMetadata.isWritable() ? ResourceDMBean.findSetter(this.objectClass, attributeMetadata.getName()) : null;
        Method getter = ResourceDMBean.findGetter(this.objectClass, attributeMetadata.getName());
        return new InvokableSetterBasedMBeanAttributeInfo(attributeMetadata.getName(), attributeMetadata.getType(), attributeMetadata.getDescription(), true, attributeMetadata.isWritable(), attributeMetadata.isIs(), getter, setter, this);
    }

    private IspnMBeanOperationInfo toJmxInfo(JmxOperationMetadata operationMetadata) throws ClassNotFoundException {
        JmxOperationParameter[] parameters = operationMetadata.getMethodParameters();
        MBeanParameterInfo[] params = new MBeanParameterInfo[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            params[i] = new MBeanParameterInfo(parameters[i].getName(), parameters[i].getType(), parameters[i].getDescription());
        }
        return new IspnMBeanOperationInfo(operationMetadata.getMethodName(), operationMetadata.getDescription(), params, operationMetadata.getReturnType(), 3, operationMetadata.getOperationName());
    }

    Object getObject() {
        return this.obj;
    }

    @Override
    public synchronized MBeanInfo getMBeanInfo() {
        MBeanOperationInfo[] operationInfoForClient = new MBeanOperationInfo[this.opInfos.length];
        for (int i = 0; i < this.opInfos.length; ++i) {
            IspnMBeanOperationInfo current = this.opInfos[i];
            operationInfoForClient[i] = new MBeanOperationInfo(current.getOperationName(), current.getDescription(), current.getSignature(), current.getReturnType(), 3);
        }
        return new MBeanInfo(this.getObject().getClass().getCanonicalName(), this.mBeanMetadata.getDescription(), this.attInfos, null, operationInfoForClient, null);
    }

    @Override
    public Object getAttribute(String name) throws AttributeNotFoundException {
        if (name == null || name.length() == 0) {
            throw new NullPointerException("Invalid attribute requested " + name);
        }
        Attribute attr = this.getNamedAttribute(name);
        if (attr == null) {
            throw new AttributeNotFoundException("Unknown attribute '" + name + "'. Known attributes names are: " + this.atts.keySet());
        }
        return attr.getValue();
    }

    @Override
    public synchronized void setAttribute(Attribute attribute) throws AttributeNotFoundException, MBeanException {
        if (attribute == null || attribute.getName() == null) {
            throw new NullPointerException("Invalid attribute requested " + attribute);
        }
        this.setNamedAttribute(attribute);
    }

    @Override
    public synchronized AttributeList getAttributes(String[] names) {
        AttributeList al = new AttributeList();
        for (String name : names) {
            Attribute attr = this.getNamedAttribute(name);
            if (attr != null) {
                al.add(attr);
                continue;
            }
            log.couldNotFindAttribute(name);
        }
        return al;
    }

    @Override
    public synchronized AttributeList setAttributes(AttributeList list) {
        AttributeList results = new AttributeList();
        for (Object aList : list) {
            Attribute attr = (Attribute)aList;
            try {
                this.setNamedAttribute(attr);
                results.add(attr);
            }
            catch (Exception e) {
                log.failedToUpdateAttribute(attr.getName(), attr.getValue());
            }
        }
        return results;
    }

    @Override
    public Object invoke(String name, Object[] args, String[] sig) throws MBeanException, ReflectionException {
        if (log.isDebugEnabled()) {
            log.debugf("Invoke method called on %s", (Object)name);
        }
        IspnMBeanOperationInfo opInfo = null;
        for (IspnMBeanOperationInfo op : this.opInfos) {
            if (!op.getOperationName().equals(name)) continue;
            opInfo = op;
            break;
        }
        if (opInfo == null) {
            String msg = "Operation " + name + " not amongst operations in " + this.opInfos;
            throw new MBeanException(new ServiceNotFoundException(msg), msg);
        }
        for (int i = 0; i < sig.length; ++i) {
            if (args[i] == null) continue;
            if (log.isDebugEnabled()) {
                log.debugf("Argument value before transformation: %s and its class: %s. For method.invoke we need it to be class: %s", args[i], (Object)args[i].getClass(), (Object)sig[i]);
            }
            if ((sig[i].equals(Integer.TYPE.getCanonicalName()) || sig[i].equals(Integer.class.getCanonicalName())) && args[i].getClass() != Integer.class && args[i].getClass() != Integer.TYPE) {
                args[i] = Integer.parseInt((String)args[i]);
            }
            if (!sig[i].equals(Long.class.getCanonicalName()) && !sig[i].equals(Long.TYPE.getCanonicalName()) || args[i].getClass() == Long.class || args[i].getClass() == Long.TYPE) continue;
            args[i] = Long.parseLong((String)args[i]);
        }
        try {
            Class[] classes = new Class[sig.length];
            for (int i = 0; i < classes.length; ++i) {
                classes[i] = ReflectionUtil.getClassForName(sig[i], null);
            }
            Method method = this.getObject().getClass().getMethod(opInfo.getName(), classes);
            return method.invoke(this.getObject(), args);
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    private Attribute getNamedAttribute(String name) {
        Attribute result = null;
        if (name.equals(MBEAN_DESCRITION)) {
            result = new Attribute(MBEAN_DESCRITION, this.mBeanMetadata.getDescription());
        } else {
            Character firstChar;
            InvokableMBeanAttributeInfo i = this.atts.get(name);
            if (i == null && name.length() > 0 && Character.isUpperCase((firstChar = Character.valueOf(name.charAt(0))).charValue())) {
                name = name.replaceFirst(Character.toString(firstChar.charValue()), Character.toString(Character.toLowerCase(firstChar.charValue())));
                i = this.atts.get(name);
            }
            if (i != null) {
                try {
                    result = new Attribute(name, i.invoke(null));
                    if (trace) {
                        log.tracef("Attribute %s has r=%b,w=%b,is=%b and value %s", name, i.getMBeanAttributeInfo().isReadable(), i.getMBeanAttributeInfo().isWritable(), i.getMBeanAttributeInfo().isIs(), result.getValue());
                    }
                }
                catch (Exception e) {
                    log.debugf("Exception while reading value of attribute %s: %s", (Object)name, (Object)e);
                }
            } else {
                log.queriedAttributeNotFound(name);
            }
        }
        return result;
    }

    private void setNamedAttribute(Attribute attribute) throws MBeanException, AttributeNotFoundException {
        Character firstChar;
        String name;
        InvokableMBeanAttributeInfo i;
        if (log.isDebugEnabled()) {
            log.debugf("Invoking set on attribute %s with value %s", (Object)attribute.getName(), attribute.getValue());
        }
        if ((i = this.atts.get(name = attribute.getName())) == null && name.length() > 0 && Character.isUpperCase((firstChar = Character.valueOf(name.charAt(0))).charValue())) {
            name = name.replaceFirst(Character.toString(firstChar.charValue()), Character.toString(Character.toLowerCase(firstChar.charValue())));
            i = this.atts.get(name);
        }
        if (i != null) {
            try {
                i.invoke(attribute);
            }
            catch (Exception e) {
                log.errorWritingValueForAttribute(name, e);
                throw new MBeanException(e, "Error invoking setter for attribute " + name);
            }
        } else {
            log.couldNotInvokeSetOnAttribute(name, attribute.getValue());
            throw new AttributeNotFoundException("Could not find attribute " + name);
        }
    }

    public String getObjectName() {
        String s = this.mBeanMetadata.getJmxObjectName();
        return s != null && s.trim().length() > 0 ? s : this.objectClass.getSimpleName();
    }

    private static class InvokableSetterBasedMBeanAttributeInfo
    extends InvokableMBeanAttributeInfo {
        private final transient Method setter;
        private final transient Method getter;
        private final transient ResourceDMBean resource;

        public InvokableSetterBasedMBeanAttributeInfo(String name, String type, String description, boolean isReadable, boolean isWritable, boolean isIs, Method getter, Method setter, ResourceDMBean resource) {
            super(name, type, description, isReadable, isWritable, isIs);
            this.setter = setter;
            this.getter = getter;
            this.resource = resource;
        }

        @Override
        public Object invoke(Attribute a) throws IllegalAccessException, InvocationTargetException {
            if (a == null) {
                if (!Modifier.isPublic(this.getter.getModifiers())) {
                    this.getter.setAccessible(true);
                }
                return this.getter.invoke(this.resource.getObject(), null);
            }
            if (!Modifier.isPublic(this.setter.getModifiers())) {
                this.setter.setAccessible(true);
            }
            return this.setter.invoke(this.resource.getObject(), a.getValue());
        }
    }

    private static class InvokableFieldBasedMBeanAttributeInfo
    extends InvokableMBeanAttributeInfo {
        private final transient Field field;
        private final transient ResourceDMBean resource;

        public InvokableFieldBasedMBeanAttributeInfo(String name, String type, String description, boolean isReadable, boolean isWritable, boolean isIs, Field field, ResourceDMBean resource) {
            super(name, type, description, isReadable, isWritable, isIs);
            this.field = field;
            this.resource = resource;
        }

        @Override
        public Object invoke(Attribute a) throws IllegalAccessException {
            if (!Modifier.isPublic(this.field.getModifiers())) {
                this.field.setAccessible(true);
            }
            if (a == null) {
                return this.field.get(this.resource.getObject());
            }
            this.field.set(this.resource.getObject(), a.getValue());
            return null;
        }
    }

    private static abstract class InvokableMBeanAttributeInfo {
        private final MBeanAttributeInfo attributeInfo;

        public InvokableMBeanAttributeInfo(String name, String type, String description, boolean isReadable, boolean isWritable, boolean isIs) {
            this.attributeInfo = new MBeanAttributeInfo(name, type, description, isReadable, isWritable, isIs);
        }

        public abstract Object invoke(Attribute var1) throws IllegalAccessException, InvocationTargetException;

        public MBeanAttributeInfo getMBeanAttributeInfo() {
            return this.attributeInfo;
        }
    }
}

