/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commands.CancelCommand;
import org.infinispan.commands.CreateCacheCommand;
import org.infinispan.commands.RemoveCacheCommand;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.DistributedExecuteCommand;
import org.infinispan.commands.read.MapCombineCommand;
import org.infinispan.commands.read.ReduceCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.MultipleRpcCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.remote.recovery.CompleteTransactionCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTransactionsCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTxInfoCommand;
import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.tx.VersionedCommitCommand;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderCommitCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderNonVersionedPrepareCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderRollbackCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderVersionedCommitCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderVersionedPrepareCommand;
import org.infinispan.commons.io.ExposedByteArrayOutputStream;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.BufferSizePredictor;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.marshall.jboss.ExtendedRiverUnmarshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.marshall.exts.ReplicableCommandExternalizer;
import org.infinispan.statetransfer.StateRequestCommand;
import org.infinispan.statetransfer.StateResponseCommand;
import org.infinispan.xsite.XSiteAdminCommand;

public final class CacheRpcCommandExternalizer
extends AbstractExternalizer<CacheRpcCommand> {
    private final GlobalComponentRegistry gcr;
    private final ReplicableCommandExternalizer cmdExt;
    private final StreamingMarshaller globalMarshaller;

    public CacheRpcCommandExternalizer(GlobalComponentRegistry gcr, ReplicableCommandExternalizer cmdExt) {
        this.cmdExt = cmdExt;
        this.gcr = gcr;
        this.globalMarshaller = gcr.getComponent(StreamingMarshaller.class, "org.infinispan.marshaller.global");
    }

    @Override
    public Set<Class<? extends CacheRpcCommand>> getTypeClasses() {
        Set<Class<? extends CacheRpcCommand>> coreCommands = Util.asSet(MapCombineCommand.class, ReduceCommand.class, DistributedExecuteCommand.class, LockControlCommand.class, StateRequestCommand.class, StateResponseCommand.class, ClusteredGetCommand.class, MultipleRpcCommand.class, SingleRpcCommand.class, CommitCommand.class, PrepareCommand.class, RollbackCommand.class, RemoveCacheCommand.class, TxCompletionNotificationCommand.class, GetInDoubtTransactionsCommand.class, GetInDoubtTxInfoCommand.class, CompleteTransactionCommand.class, VersionedPrepareCommand.class, CreateCacheCommand.class, CancelCommand.class, VersionedCommitCommand.class, XSiteAdminCommand.class, TotalOrderNonVersionedPrepareCommand.class, TotalOrderVersionedPrepareCommand.class, TotalOrderCommitCommand.class, TotalOrderVersionedCommitCommand.class, TotalOrderRollbackCommand.class);
        coreCommands.addAll(this.gcr.getModuleProperties().moduleCacheRpcCommands());
        return coreCommands;
    }

    @Override
    public void writeObject(ObjectOutput output, CacheRpcCommand command) throws IOException {
        this.cmdExt.writeCommandHeader(output, command);
        String cacheName = command.getCacheName();
        output.writeUTF(cacheName);
        StreamingMarshaller marshaller = this.getCacheMarshaller(cacheName);
        ExposedByteArrayOutputStream os = this.marshallParameters(command, marshaller);
        UnsignedNumeric.writeUnsignedInt(output, os.size());
        output.write(os.getRawBuffer(), 0, os.size());
        if (command instanceof TopologyAffectedCommand) {
            output.writeInt(((TopologyAffectedCommand)((Object)command)).getTopologyId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExposedByteArrayOutputStream marshallParameters(CacheRpcCommand cmd, StreamingMarshaller marshaller) throws IOException {
        BufferSizePredictor sizePredictor = marshaller.getBufferSizePredictor(cmd);
        int estimatedSize = sizePredictor.nextSize(cmd);
        ExposedByteArrayOutputStream baos = new ExposedByteArrayOutputStream(estimatedSize);
        ObjectOutput output = marshaller.startObjectOutput(baos, true, estimatedSize);
        try {
            this.cmdExt.writeCommandParameters(output, cmd);
        }
        finally {
            marshaller.finishObjectOutput(output);
        }
        return baos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheRpcCommand readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        byte type = input.readByte();
        byte methodId = (byte)input.readShort();
        String cacheName = input.readUTF();
        StreamingMarshaller marshaller = this.getCacheMarshaller(cacheName);
        byte[] paramsRaw = new byte[UnsignedNumeric.readUnsignedInt(input)];
        input.readFully(paramsRaw);
        ByteArrayInputStream is = new ByteArrayInputStream(paramsRaw, 0, paramsRaw.length);
        ObjectInput paramsInput = marshaller.startObjectInput(is, true);
        if (paramsInput instanceof ExtendedRiverUnmarshaller) {
            ((ExtendedRiverUnmarshaller)paramsInput).setInfinispanMarshaller(marshaller);
        }
        try {
            Object[] args = this.cmdExt.readParameters(paramsInput);
            CacheRpcCommand cacheRpcCommand = this.cmdExt.fromStream(methodId, args, type, cacheName);
            if (cacheRpcCommand instanceof TopologyAffectedCommand) {
                int topologyId = input.readInt();
                ((TopologyAffectedCommand)((Object)cacheRpcCommand)).setTopologyId(topologyId);
            }
            CacheRpcCommand cacheRpcCommand2 = cacheRpcCommand;
            return cacheRpcCommand2;
        }
        finally {
            marshaller.finishObjectInput(paramsInput);
        }
    }

    @Override
    public Integer getId() {
        return 74;
    }

    private StreamingMarshaller getCacheMarshaller(String cacheName) {
        ComponentRegistry registry = this.gcr.getNamedComponentRegistry(cacheName);
        if (registry == null || registry.getStatus() != ComponentStatus.RUNNING) {
            return this.globalMarshaller;
        }
        return registry.getCacheMarshaller();
    }
}

