/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.EnumSet;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.Util;
import org.jboss.marshalling.util.IdentityIntMap;

@Immutable
public class EnumSetExternalizer
extends AbstractExternalizer<Set> {
    private static final int ENUM_SET = 0;
    private static final int REGULAR_ENUM_SET = 1;
    private static final int JUMBO_ENUM_SET = 2;
    private final IdentityIntMap<Class<?>> numbers = new IdentityIntMap(3);

    public EnumSetExternalizer() {
        this.numbers.put(EnumSet.class, 0);
        this.numbers.put(this.getRegularEnumSetClass(), 1);
        this.numbers.put(this.getJumboEnumSetClass(), 2);
    }

    @Override
    public void writeObject(ObjectOutput output, Set set) throws IOException {
        int number = this.numbers.get(set.getClass(), -1);
        output.writeByte(number);
        MarshallUtil.marshallCollection(set, output);
    }

    @Override
    public Set readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        int magicNumber = input.readUnsignedByte();
        EnumSet<Enum> enumSet = null;
        int size = UnsignedNumeric.readUnsignedInt(input);
        block3: for (int i = 0; i < size; ++i) {
            switch (magicNumber) {
                case 0: 
                case 1: 
                case 2: {
                    if (i == 0) {
                        enumSet = EnumSet.of((Enum)input.readObject());
                        continue block3;
                    }
                    enumSet.add((Enum)input.readObject());
                }
            }
        }
        return enumSet;
    }

    @Override
    public Integer getId() {
        return 121;
    }

    @Override
    public Set<Class<? extends Set>> getTypeClasses() {
        return Util.asSet(EnumSet.class, this.getRegularEnumSetClass(), this.getJumboEnumSetClass());
    }

    private Class<EnumSet> getJumboEnumSetClass() {
        return this.getEnumSetClass("java.util.JumboEnumSet");
    }

    private Class<EnumSet> getRegularEnumSetClass() {
        return this.getEnumSetClass("java.util.RegularEnumSet");
    }

    private Class<EnumSet> getEnumSetClass(String className) {
        return Util.loadClass(className, EnumSet.class.getClassLoader());
    }
}

